/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl.core;

import com.sonicsw.esb.service.common.impl.core.FileChangeManager;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.FileChangeHandler;
import java.util.HashMap;
import java.util.Map;

public class FileChangeManagerImpl
implements FileChangeManager {
    private static final String SONICFS = "sonicfs:///";
    private static final String SONICFS_WORKSPACE = "sonicfs:///workspace";
    private final Map xqHandlers = new HashMap();

    @Override
    public boolean supportsChangeNotifications(String path) {
        if (path == null) {
            return false;
        }
        if (path.startsWith(SONICFS)) {
            return !path.startsWith(SONICFS_WORKSPACE);
        }
        return false;
    }

    @Override
    public synchronized void registerFileChangeInterest(String path, FileChangeManager.FileChangeHandler handler) {
        DelegatingHandler xqHandler = (DelegatingHandler)this.xqHandlers.get(handler);
        if (xqHandler == null) {
            xqHandler = new DelegatingHandler(handler);
            this.xqHandlers.put(handler, xqHandler);
        } else {
            xqHandler.addReference();
        }
        XQContainer.registerFileChangeInterest((String)path, (FileChangeHandler)xqHandler);
    }

    @Override
    public synchronized void unregisterFileChangeInterest(String path, FileChangeManager.FileChangeHandler handler) {
        DelegatingHandler xqHandler = (DelegatingHandler)this.xqHandlers.get(handler);
        if (xqHandler != null) {
            xqHandler.removeReference();
            if (!xqHandler.hasReferences()) {
                this.xqHandlers.remove(handler);
            }
        }
        XQContainer.unregisterFileChangeInterest((String)path, (FileChangeHandler)xqHandler);
    }

    private static final class DelegatingHandler
    implements FileChangeHandler {
        private final FileChangeManager.FileChangeHandler target;
        private int refCount = 1;

        DelegatingHandler(FileChangeManager.FileChangeHandler target) {
            this.target = target;
        }

        public void handleFileChange(IFSElementChange fileChange) {
            this.target.handleFileChange(fileChange.getLogicalPath());
        }

        void addReference() {
            ++this.refCount;
        }

        void removeReference() {
            --this.refCount;
        }

        boolean hasReferences() {
            return this.refCount > 0;
        }
    }
}

