/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.variables;

import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableConstants;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableIterator;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.esb.service.common.util.variables.VariableResolverFactory;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;

public class VariableParserImpl
implements VariableParser {
    private VariableResolverFactory resolverFactory;

    @Override
    public String replaceAllVariables(String content) {
        if (content == null) {
            return null;
        }
        boolean hasContent = false;
        StringBuffer result = new StringBuffer();
        VariableIterator iter = this.getVariableIterator(content);
        while (iter.hasNext()) {
            String token = (String)iter.next();
            if (iter.wasLastTokenVariable()) {
                String value = this.resolveVariable(token);
                if (value == null) continue;
                result.append(value);
                hasContent = true;
                continue;
            }
            result.append(token);
            hasContent = true;
        }
        return hasContent ? result.toString() : null;
    }

    @Override
    public boolean containsVariables(String content) {
        if (content == null) {
            return false;
        }
        Matcher matcher = VariableConstants.VARIABLE_PATTERN.matcher(content);
        boolean result = matcher.find(0);
        return result;
    }

    @Override
    public boolean isVariable(String content) {
        if (content == null) {
            return false;
        }
        Matcher matcher = VariableConstants.VARIABLE_PATTERN.matcher(content);
        return matcher.matches();
    }

    @Override
    public VariableIterator getVariableIterator(String content) {
        return new VariableIteratorImpl(content);
    }

    @Override
    public String resolveVariable(String token) {
        CheckArg.notNull(token, "token");
        Check.isSet(this.resolverFactory, "resolverFactory");
        String variable = this.trimDelimiters(token);
        VariableResolver resolver = this.resolverFactory.getResolver(variable);
        if (resolver != null) {
            return resolver.resolve(variable);
        }
        throw new IllegalArgumentException("Unsupported URI scheme for variable: " + token);
    }

    private String trimDelimiters(String variableToken) {
        CheckArg.notNull(variableToken, "variableToken");
        Matcher matcher = VariableConstants.VARIABLE_PATTERN.matcher(variableToken);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("Not a variable token: " + variableToken);
        }
        String variable = matcher.group(1);
        return variable;
    }

    @Override
    public VariableFactory.Variable getVariable(String content) {
        String variable = this.trimDelimiters(content);
        VariableResolver resolver = this.resolverFactory.getResolver(variable);
        if (resolver instanceof VariableFactory) {
            return ((VariableFactory)((Object)resolver)).getVariable(variable);
        }
        return null;
    }

    @Override
    public void setVariableResolverFactory(VariableResolverFactory resolverFactory) {
        CheckArg.notNull(resolverFactory, "resolverFactory");
        this.resolverFactory = resolverFactory;
    }

    @Override
    public VariableResolverFactory getVariableResolverFactory() {
        return this.resolverFactory;
    }

    private class VariableIteratorImpl
    implements VariableIterator {
        private final String content;
        private final Matcher matcher;
        private final boolean includeLiterals;
        private int ix;
        private String lastToken;
        private boolean wasVariable;

        public VariableIteratorImpl(String content) {
            this(content, true);
        }

        public VariableIteratorImpl(String content, boolean includeLiterals) {
            this.content = content != null ? content : "";
            this.matcher = VariableConstants.VARIABLE_PATTERN.matcher(this.content);
            this.includeLiterals = includeLiterals;
        }

        @Override
        public boolean hasNext() {
            if (this.includeLiterals) {
                return this.ix < this.content.length();
            }
            return this.matcher.find(this.ix);
        }

        @Override
        public Object next() {
            if (this.matcher.find(this.ix)) {
                if (this.ix == this.matcher.start()) {
                    this.ix = this.matcher.end();
                    this.lastToken = this.matcher.group();
                    this.wasVariable = true;
                } else {
                    int start = this.ix;
                    this.ix = this.matcher.start();
                    this.lastToken = this.content.substring(start, this.ix);
                    this.wasVariable = false;
                }
            } else if (this.ix < this.content.length()) {
                String result = this.content.substring(this.ix);
                this.ix = this.content.length();
                this.lastToken = result;
                this.wasVariable = false;
            } else {
                throw new NoSuchElementException();
            }
            if (this.includeLiterals || this.wasVariable) {
                return this.lastToken;
            }
            return this.next();
        }

        @Override
        public boolean wasLastTokenVariable() {
            Check.isSet(this.lastToken, "lastToken");
            return this.wasVariable;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

