/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.ContextAwareVariableResolver;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.xq.XQInvocationContext;
import com.sonicsw.xq.XQServiceContext;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class InterfaceParameterVariableResolver
implements ContextAwareVariableResolver,
VariableFactory {
    private static final Logger logger = Logger.getLogger((String)(VariableResolver.class.getName() + '.' + "esbdl"));
    private XQServiceContext context;

    public InterfaceParameterVariableResolver() {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException excp) {
            throw new IllegalStateException(excp.getMessage());
        }
    }

    public String getScheme() {
        return "esbdl";
    }

    public InterfaceParameterVariableResolver(XQServiceContext context) {
        this.context = context;
    }

    @Override
    public final void setContext(SFCServiceContext context) {
        this.setInterfaceParameter(context.getXQServiceContext());
    }

    public final void setInterfaceParameter(XQServiceContext context) {
        this.context = context;
    }

    @Override
    public String resolve(String variableStr) {
        CheckArg.notNull(variableStr, "variableStr");
        if (this.context == null) {
            throw new IllegalStateException("Cannot resolve variable '" + variableStr + "' - there is no current ESB Service context.");
        }
        try {
            InterfaceParameterVariable var = (InterfaceParameterVariable)this.getVariable(variableStr);
            if (var.type.equals(InterfaceParameterVariable.INPUT)) {
                return this.resolveInterfaceParameter(var.getSource(), InterfaceParameterVariable.INPUT);
            }
            if (var.type.equals(InterfaceParameterVariable.OUTPUT)) {
                return this.resolveInterfaceParameter(var.getSource(), InterfaceParameterVariable.OUTPUT);
            }
            if (var.type.equals(InterfaceParameterVariable.FAULT)) {
                throw new IllegalStateException("Unsupported process context variable type: " + var.getType());
            }
            throw new IllegalStateException("Unsupported process context variable type: " + var.getType());
        }
        catch (Exception excp) {
            return null;
        }
    }

    private String resolveInterfaceParameter(String paramName, InterfaceParameterVariable.Type type) {
        String paramValue = null;
        XQInvocationContext invCtx = this.context.getInvocationContext();
        if (invCtx != null && invCtx instanceof InvocationContext) {
            ParameterValue paramValObj;
            ParameterValueMap pvl = null;
            if (type.equals(InterfaceParameterVariable.INPUT)) {
                pvl = ((InvocationContext)invCtx).getInputParameterValues();
            } else if (type.equals(InterfaceParameterVariable.OUTPUT)) {
                pvl = ((InvocationContext)invCtx).getOutputParameterValues();
            }
            if (pvl != null && (paramValObj = pvl.getParameterValue(paramName)) != null) {
                paramValue = (String)paramValObj.getValue();
            }
        }
        return paramValue;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new InterfaceParameterVariable(variableStr);
    }

    public VariableFactory.Variable createInputParameterVariable(String property) {
        return new InterfaceParameterVariable(InterfaceParameterVariable.INPUT, property);
    }

    public VariableFactory.Variable createOutputParameterVariable(String property) {
        return new InterfaceParameterVariable(InterfaceParameterVariable.OUTPUT, property);
    }

    public VariableFactory.Variable createFaultParameterVariable(String property) {
        return new InterfaceParameterVariable(InterfaceParameterVariable.FAULT, property);
    }

    public static class InterfaceParameterVariable
    implements VariableFactory.Variable {
        public static final Type INPUT = new Type("input");
        public static final Type OUTPUT = new Type("output");
        public static final Type FAULT = new Type("fault");
        public static final String SCHEME = "esbdl";
        private final Type type;
        private final String variableStr;
        private final String source;

        InterfaceParameterVariable(String variableStr) {
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (parts.countTokens() != 3 || !SCHEME.equals(parts.nextToken())) {
                throw new IllegalArgumentException("Malformed process context variable string: '" + variableStr + "'. Expected format is 'esbp:type:source'.");
            }
            this.type = this.typeFromString(parts.nextToken());
            this.source = parts.nextToken();
            this.variableStr = variableStr;
        }

        InterfaceParameterVariable(Type type, String source) {
            CheckArg.notNull(type, "type");
            CheckArg.notEmpty(source, "source");
            this.type = type;
            this.source = source;
            this.variableStr = "esbdl:" + type.name + ':' + source;
        }

        public Type getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.variableStr;
        }

        private Type typeFromString(String str) {
            if (InterfaceParameterVariable.INPUT.name.equals(str)) {
                return INPUT;
            }
            if (InterfaceParameterVariable.OUTPUT.name.equals(str)) {
                return OUTPUT;
            }
            if (InterfaceParameterVariable.FAULT.name.equals(str)) {
                return FAULT;
            }
            throw new IllegalArgumentException("Unsupported esbmsg variable type: " + str);
        }

        public static final class Type {
            protected String name;

            private Type(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

