/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCServiceDescriptor;
import com.sonicsw.esb.service.common.VersionNumber;
import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.CheckArg;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

class PropertiesBasedServiceDescriptor
implements SFCServiceDescriptor,
ResourceLoaderAware {
    private static final Logger logger = Logger.getLogger(SFCServiceDescriptor.class);
    private Properties properties;
    private ResourceLoader resourceLoader;
    private String serviceTypeName;
    private String propertiesRootPath;
    private String displayName;
    private VersionNumber versionNumber;
    private String copyright;

    public PropertiesBasedServiceDescriptor(String serviceTypeName, String propertiesRootPath) {
        this.serviceTypeName = serviceTypeName;
        this.propertiesRootPath = propertiesRootPath;
    }

    public PropertiesBasedServiceDescriptor(Properties properties) {
        this.properties = properties;
    }

    public void init() {
        if (this.properties != null) {
            logger.debug((Object)"Properties set prior to init.");
        } else {
            Check.isSet(this.serviceTypeName, "serviceTypeName");
            Check.isSet(this.propertiesRootPath, "propertiesRootPath");
            Resource resource = this.resourceLoader.getResource(this.propertiesRootPath + (this.propertiesRootPath.endsWith("/") ? "" : "/") + this.serviceTypeName + ".properties");
            this.loadProperties(resource);
        }
        String typeName = this.properties.getProperty("type.name");
        if (this.serviceTypeName == null) {
            this.serviceTypeName = typeName;
        } else if (!this.serviceTypeName.equals(typeName)) {
            throw new IllegalStateException("Type name '" + typeName + "' in properties does not match specified service type name '" + this.serviceTypeName + "'.");
        }
        this.displayName = this.properties.getProperty("type.displayName");
        String versionString = this.properties.getProperty("type.version");
        this.versionNumber = StringUtils.hasText((String)versionString) ? VersionNumber.valueOf(versionString) : VersionNumber.getDefault();
        String copyright = this.properties.getProperty("type.copyright");
        if (StringUtils.hasText((String)copyright)) {
            this.copyright = copyright;
        }
    }

    @Override
    public String getName() {
        return this.serviceTypeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public VersionNumber getVersion() {
        return this.versionNumber;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        CheckArg.notNull(resourceLoader, "resourceLoader");
        this.resourceLoader = resourceLoader;
    }

    public void setProperties(Properties properties) {
        CheckArg.notNull(properties, "properties");
        Check.notSet(this.properties, "properties");
        this.properties = properties;
    }

    private void loadProperties(Resource resource) {
        CheckArg.notNull(resource, "resource");
        Properties props = new Properties();
        try {
            logger.debug((Object)("Reading properties: " + resource));
            props.load(resource.getInputStream());
            this.setProperties(props);
        }
        catch (IOException excp) {
            throw new IllegalArgumentException("Unable to load properties: " + excp.getMessage());
        }
    }
}

