/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl.core;

import com.sonicsw.esb.service.common.impl.core.MetricsRegistrar;
import com.sonicsw.mf.common.info.INotificationInfo;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.xqimpl.service.XQContainer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

class MetricsRegistrarImpl
implements MetricsRegistrar {
    private static final Logger logger = Logger.getLogger(MetricsRegistrar.class);
    private final Map callbackObjects = new HashMap();

    MetricsRegistrarImpl() {
    }

    @Override
    public void registerInstanceMetric(IMetricInfo info, MetricsRegistrar.InstanceMetricCapable callback) {
        this.registerInstanceMetric(null, info, callback);
    }

    @Override
    public void registerInstanceMetric(String serviceName, IMetricInfo info, MetricsRegistrar.InstanceMetricCapable callback) {
        boolean commonMetric;
        this.callbackObjects.put(info.getMetricIdentity(), callback);
        boolean bl = commonMetric = !StringUtils.hasText((String)serviceName);
        if (commonMetric) {
            XQContainer.registerInstanceMetric((IMetricInfo)info);
        } else {
            XQContainer.registerInstanceMetric((IMetricInfo)info, (String)serviceName);
        }
        if (logger.isDebugEnabled()) {
            MessageFormat pattern = new MessageFormat("Registered instance metric {0} for {1}.");
            Object[] args = new Object[]{info.getMetricIdentity().getName(), commonMetric ? "all services" : "service " + serviceName};
            logger.debug((Object)pattern.format(args));
        }
    }

    @Override
    public void registerMetric(IMetricInfo info, IStatistic statistic) {
        XQContainer.registerMetricInfo((IMetricInfo)info, (IStatistic)statistic);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered global metric '" + info.getMetricIdentity().getName() + "'."));
        }
    }

    @Override
    public void addNotification(INotificationInfo info) {
        XQContainer.addNotificationInfo((INotificationInfo)info);
        if (logger.isDebugEnabled()) {
            if (info instanceof MBeanNotificationInfo) {
                MBeanNotificationInfo mbeanInfo = (MBeanNotificationInfo)info;
                Object[] notifTypes = mbeanInfo.getNotifTypes();
                String name = StringUtils.arrayToDelimitedString((Object[])notifTypes, (String)".");
                logger.debug((Object)("Registered notification '" + name + "'."));
            } else {
                logger.debug((Object)("Registered notification '" + info.getName() + "'."));
            }
        }
    }

    @Override
    public void disableInstanceMetric(IMetricIdentity id) {
        MetricsRegistrar.InstanceMetricCapable callback = (MetricsRegistrar.InstanceMetricCapable)this.callbackObjects.get(id);
        if (callback != null) {
            callback.disableInstanceMetric(id);
        }
    }

    @Override
    public IStatistic enableInstanceMetric(IMetricIdentity id) {
        MetricsRegistrar.InstanceMetricCapable callback = (MetricsRegistrar.InstanceMetricCapable)this.callbackObjects.get(id);
        if (callback != null) {
            return callback.enableInstanceMetric(id);
        }
        return null;
    }
}

