/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.metrics;

import com.sonicsw.esb.service.common.metrics.HistoryMode;
import com.sonicsw.esb.service.common.metrics.MetricDescriptor;
import com.sonicsw.esb.service.common.metrics.MetricType;
import com.sonicsw.esb.service.common.metrics.UpdateMode;

public class MetricsBuilder {
    public MetricDescriptor buildMetric(String name) {
        return this.buildMetric(name, MetricType.VALUE, UpdateMode.VALUE);
    }

    public MetricDescriptor buildTotalValueMetric(String name) {
        return this.buildMetric(name, MetricType.VALUE, UpdateMode.COUNTER);
    }

    public MetricDescriptor buildMaxValueMetric(String name) {
        return this.buildMetric(name, MetricType.VALUE, UpdateMode.MAX);
    }

    public MetricDescriptor buildMinValueMetric(String name) {
        return this.buildMetric(name, MetricType.VALUE, UpdateMode.MIN);
    }

    public MetricDescriptor buildAverageMetric(String name) {
        return this.buildMetric(name, MetricType.AVERAGE, UpdateMode.COUNTER);
    }

    public MetricDescriptor buildRollingMaxValueMetric(String name) {
        return this.buildMetric(name, MetricType.MAX, UpdateMode.VALUE, false, HistoryMode.VALUES);
    }

    public MetricDescriptor buildRollingMinValueMetric(String name) {
        return this.buildMetric(name, MetricType.MIN, UpdateMode.VALUE, false, HistoryMode.VALUES);
    }

    public MetricDescriptor buildRollingAverageMetric(String name) {
        return this.buildMetric(name, MetricType.AVERAGE, UpdateMode.COUNTER, true, HistoryMode.VALUES_AND_COUNTS);
    }

    public MetricDescriptor buildPerSecondRateMetric(String name) {
        return this.buildMetric(name, MetricType.RATE_PER_SECOND, UpdateMode.COUNTER, true, HistoryMode.VALUES);
    }

    public MetricDescriptor buildPerMinuteRateMetric(String name) {
        return this.buildMetric(name, MetricType.RATE_PER_MINUTE, UpdateMode.COUNTER, true, HistoryMode.VALUES);
    }

    protected MetricDescriptor buildMetric(String name, MetricType type, UpdateMode updateMode) {
        return this.buildMetric(name, type, updateMode, false, HistoryMode.NONE);
    }

    protected MetricDescriptor buildMetric(String name, MetricType type, UpdateMode updateMode, boolean intervalMode, HistoryMode historyMode) {
        MetricDescriptor desc = new MetricDescriptor();
        desc.setName(name);
        desc.setType(type);
        desc.setUpdateMode(updateMode);
        desc.setIntervalMode(intervalMode);
        desc.setHistoryMode(historyMode);
        return desc;
    }
}

