/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.cleanup.impl;

import com.sonicsw.esb.service.common.ramps.cleanup.ICleanupActions;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileCleaner
implements ICleanupActions {
    private static final Logger LOGGER = Logger.getLogger(FileCleaner.class);

    @Override
    public void deleteFile(String _path) throws IOException {
        File localSystemFilePath = new File(_path);
        if (localSystemFilePath.delete()) {
            LOGGER.info((Object)("Successfully cleaned the file : " + localSystemFilePath));
        } else {
            LOGGER.error((Object)("Failed  cleaning the file : " + localSystemFilePath));
        }
    }

    @Override
    public void renameFile(String _src, String _dest) throws IOException {
        File from = new File(_src);
        File to = new File(_dest);
        if (from.renameTo(to)) {
            LOGGER.info((Object)("Successfully cleaned the file : " + _src));
        }
        try {
            FileCleaner.copyFile(from, to);
            if (from.delete()) {
                LOGGER.info((Object)("Successfully cleaned the file : " + _src));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Failed  cleaning the file : " + _src));
        }
    }

    private static void copyFile(File _src, File _dest) throws IOException {
        if (!_src.exists()) {
            throw new FileNotFoundException(_src.getCanonicalPath());
        }
        if (_dest.exists() && !_dest.isFile()) {
            throw new IOException("Destination " + _dest.getCanonicalPath() + " is not a file.");
        }
        _dest.getParentFile().mkdirs();
        Utils.copyAndCloseStreams(new FileInputStream(_src), new FileOutputStream(_dest));
    }
}

