/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.variables;

import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemPropertyVariableResolver
implements VariableResolver,
VariableFactory {
    private static final String SCHEME = "system";
    private static final Logger logger = LogManager.getLogger((String)(VariableResolver.class.getName() + '.' + "system"));

    public String getScheme() {
        return SCHEME;
    }

    @Override
    public String resolve(String variableStr) {
        CheckArg.notNull(variableStr, "variableStr");
        SystemPropertyVariable var = (SystemPropertyVariable)this.getVariable(variableStr);
        return System.getProperty(var.getPropertyName());
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new SystemPropertyVariable(variableStr);
    }

    public VariableFactory.Variable createVariable(String propertyName) {
        String variableStr = "system:" + propertyName;
        return new SystemPropertyVariable(variableStr);
    }

    public static class SystemPropertyVariable
    implements VariableFactory.Variable {
        private final String propertyName;
        private final String variableStr;

        SystemPropertyVariable(String variableStr) {
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (parts.countTokens() != 2 || !SystemPropertyVariableResolver.SCHEME.equals(parts.nextToken())) {
                throw new IllegalArgumentException("Malformed message variable string: '" + variableStr + "'. Expected format is 'system:property'.");
            }
            this.propertyName = parts.nextToken();
            this.variableStr = variableStr;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String toString() {
            return this.variableStr;
        }
    }
}

