/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.ramps.impl.ErrorHandler;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSyncRamp {
    private final ErrorHandler errorHandler_;
    private boolean retainMessage_ = true;
    private static final Map BLOCKING_SERVICES = new HashMap();
    private final String serviceGroupName_;
    protected volatile boolean stopRequested_;

    protected AbstractSyncRamp(String _serviceGroupName) {
        this.serviceGroupName_ = _serviceGroupName;
        this.errorHandler_ = new ErrorHandler();
    }

    protected final ErrorHandler getErrorHandler() {
        return this.errorHandler_;
    }

    protected final void internalInit(SFCInitializationContext _ctx) throws XQServiceException {
        this.errorHandler_.init(_ctx.getParameters());
        this.retainMessage_ = Boolean.valueOf(_ctx.getParameters().getParameter("RetainMessage", String.valueOf(this.retainMessage_)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeFromBlocking() {
        Map map = BLOCKING_SERVICES;
        synchronized (map) {
            Set activeInstances = (Set)BLOCKING_SERVICES.get(this.serviceGroupName_);
            if (null != activeInstances) {
                activeInstances.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addToBlocking() {
        Map map = BLOCKING_SERVICES;
        synchronized (map) {
            HashSet<AbstractSyncRamp> activeInstances = (HashSet<AbstractSyncRamp>)BLOCKING_SERVICES.get(this.serviceGroupName_);
            if (null == activeInstances) {
                activeInstances = new HashSet<AbstractSyncRamp>();
                BLOCKING_SERVICES.put(this.serviceGroupName_, activeInstances);
            }
            activeInstances.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String _serviceGroupName) {
        Map map = BLOCKING_SERVICES;
        synchronized (map) {
            Set activeInstances = (Set)BLOCKING_SERVICES.get(_serviceGroupName);
            if (null != activeInstances) {
                for (AbstractSyncRamp ramp : activeInstances) {
                    ramp.stop();
                }
            }
        }
    }

    public final void stop() {
        this.stopRequested_ = true;
        this.errorHandler_.stop();
    }

    protected final XQMessage handleMessageRetaining(XQMessage _message) throws XQMessageException {
        if (this.retainMessage_) {
            return _message;
        }
        XQMessage newMessage = (XQMessage)_message.clone();
        newMessage.removeAllParts();
        return newMessage;
    }

    protected static boolean getInitialRetryValue(XQMessage _msg) throws XQServiceException {
        try {
            return _msg.getBooleanHeader("JMSRedelivered");
        }
        catch (XQMessageException e) {
            throw new XQServiceException((Throwable)e);
        }
    }
}

