/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@Plugin(name="MDCFilter", category="Core", elementType="filter", printObject=true)
public class MDCFilter
extends AbstractFilter {
    private final String key;
    private final String value;
    private boolean required = true;
    private boolean invert = false;

    private MDCFilter(String key, String value, boolean required, boolean invert) {
        this.key = key;
        this.value = value;
        this.required = required;
        this.invert = invert;
    }

    public Filter.Result filter(LogEvent event) {
        if (this.value == null) {
            return this.required ? Filter.Result.DENY : Filter.Result.NEUTRAL;
        }
        String check = ThreadContext.get((String)this.key);
        if (check == null) {
            return this.required ? Filter.Result.DENY : Filter.Result.NEUTRAL;
        }
        if (this.invert) {
            return this.value.equals(check) ? Filter.Result.DENY : Filter.Result.NEUTRAL;
        }
        return this.value.equals(check) ? Filter.Result.NEUTRAL : Filter.Result.DENY;
    }

    @PluginFactory
    public static MDCFilter createFilter(@PluginAttribute(value="key") String key, @PluginAttribute(value="value") String value, @PluginAttribute(value="required", defaultBoolean=true) Boolean required, @PluginAttribute(value="invert") Boolean invert) {
        if (key == null) {
            LOGGER.error("A key must be provided for MDCFilter");
            return null;
        }
        if (value == null) {
            LOGGER.error("A value must be provided for MDCFilter");
            return null;
        }
        return new MDCFilter(key, value, required, invert);
    }
}

