/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.variables;

import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.esb.service.common.util.variables.VariableResolverFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class VariableResolverFactoryImpl
implements VariableResolverFactory,
BeanPostProcessor {
    private static final Logger logger = LogManager.getLogger(VariableResolverFactory.class);
    private final Map resolvers = new HashMap();
    private final Map resolverFactories = new HashMap();

    @Override
    public VariableResolver getResolver(String variable) {
        VariableResolverFactory factory;
        if (variable == null) {
            return null;
        }
        String scheme = this.getScheme(variable);
        VariableResolver resolver = this.getResolverForScheme(scheme);
        if (resolver == null && (factory = this.getResolverFactoryForScheme(scheme)) != null) {
            resolver = factory.getResolver(variable);
        }
        return resolver;
    }

    protected VariableResolver getResolverForScheme(String scheme) {
        return (VariableResolver)this.resolvers.get(scheme);
    }

    protected VariableResolverFactory getResolverFactoryForScheme(String scheme) {
        return (VariableResolverFactory)this.resolverFactories.get(scheme);
    }

    private String getScheme(String variable) {
        int ix = variable.indexOf(58);
        if (ix > 0) {
            return variable.substring(0, ix);
        }
        return "";
    }

    public void registerResolver(String scheme, VariableResolver resolver) {
        CheckArg.notNull(resolver, "resolver");
        CheckArg.notEmpty(scheme, "scheme");
        this.resolvers.put(scheme, resolver);
        logger.debug("Registered variable resolver for scheme: " + scheme);
    }

    public void registerResolverFactory(String scheme, VariableResolverFactory resolverFactory) {
        CheckArg.notNull(resolverFactory, "resolverFactory");
        CheckArg.notEmpty(scheme, "scheme");
        this.resolverFactories.put(scheme, this.resolverFactories);
        logger.debug("Registered variable resolver factory for scheme: " + scheme);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        BeanWrapperImpl wrapper;
        if (bean != null && VariableResolver.class.isAssignableFrom(bean.getClass()) && (wrapper = new BeanWrapperImpl(bean)).isReadableProperty("scheme")) {
            this.registerResolver((String)wrapper.getPropertyValue("scheme"), (VariableResolver)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

