/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xqimpl.service.XQContainer;

class SFCInitializationContextImpl
implements SFCInitializationContext {
    private XQInitContext xqInitContext;
    private final SFCParameters parameters;
    private final VariableParser variableParser;
    private int numberOfListeners;

    public SFCInitializationContextImpl(SFCParameters parameters, VariableParser variableParser) {
        this.parameters = parameters;
        this.variableParser = variableParser;
    }

    @Override
    public SFCParameters getParameters() {
        return this.parameters;
    }

    @Override
    public VariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public String getDomainName() {
        return this.getXQStringParam("SonicXQ.DomainName");
    }

    @Override
    public String getMFContainerName() {
        return this.getXQStringParam("SonicXQ.ContainerName");
    }

    @Override
    public String getESBContainerName() {
        return XQContainer.getXQContainerName();
    }

    @Override
    public String getServiceName() {
        return this.getXQStringParam("SonicXQ.ServiceName");
    }

    @Override
    public String getServiceTypeName() {
        return this.getXQStringParam("SonicXQ.ServiceType");
    }

    @Override
    public String getAbsoluteServiceInstanceName() {
        return this.getDomainName() + '.' + this.getMFContainerName() + '.' + this.getESBContainerName() + '.' + this.getServiceName();
    }

    @Override
    public int getNumberOfListeners() {
        if (this.numberOfListeners == 0) {
            String num = this.getXQStringParam("SonicXQ.Listeners");
            this.numberOfListeners = num != null ? Integer.parseInt(num) : 1;
        }
        return this.numberOfListeners;
    }

    private String getXQStringParam(String name) {
        return this.xqInitContext.getParameters().getParameter(name, 1);
    }

    @Override
    public void setXQInitContext(XQInitContext xqInitContext) {
        Check.notSet(this.xqInitContext, "xqInitContext");
        this.xqInitContext = xqInitContext;
    }

    @Override
    public XQInitContext getXQInitContext() {
        return this.xqInitContext;
    }

    @Override
    public XQAddressFactory getAddressFactory() {
        return this.xqInitContext.getAddressFactory();
    }

    @Override
    public XQDispatch getDispatcher() {
        return this.xqInitContext.getDispatcher();
    }

    @Override
    public XQEndpointManager getEndpointManager() {
        return this.xqInitContext.getEndpointManager();
    }

    @Override
    public XQEnvelopeFactory getEnvelopeFactory() {
        return this.xqInitContext.getEnvelopeFactory();
    }

    @Override
    public XQMessageFactory getMessageFactory() {
        return this.xqInitContext.getMessageFactory();
    }

    @Override
    public XQLifeCycleManager getLifeCycle() {
        return this.xqInitContext.getLifeCycle();
    }
}

