/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCService;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.metrics.MetricDescriptor;
import com.sonicsw.esb.service.common.metrics.MetricsBuilder;
import com.sonicsw.esb.service.common.metrics.MetricsCapable;
import com.sonicsw.esb.service.common.metrics.MetricsHandler;
import com.sonicsw.esb.service.common.metrics.SFCMetric;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ServiceMetricsDecorator
implements SFCService,
MetricsCapable {
    private static Logger logger = LogManager.getLogger(SFCService.class);
    private SFCService target;
    private SFCMetric envelopesReceived;
    private SFCMetric envelopesReceivedPerSecond;
    private SFCMetric serviceFaultedCount;
    private SFCMetric serviceFailedCount;
    private SFCMetric averageExecutionTime;

    ServiceMetricsDecorator() {
    }

    @Override
    public void doInit(SFCInitializationContext context) throws XQServiceException {
        this.target.doInit(context);
    }

    @Override
    public void doStart() throws XQServiceException {
        this.target.doStart();
    }

    @Override
    public void doService(SFCServiceContext context, XQEnvelope envelope) throws XQServiceException {
        long startTime = System.currentTimeMillis();
        this.envelopesReceived.incrementValue();
        this.envelopesReceivedPerSecond.incrementValue();
        try {
            this.target.doService(context, envelope);
            if (context.hasFaults()) {
                this.serviceFaultedCount.incrementValue();
                logger.debug("Invocation resulted in one or more fault messages.");
            }
        }
        catch (XQServiceException excp) {
            this.serviceFailedCount.incrementValue();
            throw excp;
        }
        catch (RuntimeException excp) {
            this.serviceFailedCount.incrementValue();
            throw excp;
        }
        long execTime = System.currentTimeMillis() - startTime;
        this.averageExecutionTime.updateValue(execTime);
    }

    @Override
    public void doStop() throws XQServiceException {
        this.target.doStop();
    }

    @Override
    public void doDestroy() throws XQServiceException {
        this.target.doDestroy();
    }

    @Override
    public void initializeContainerMetrics(MetricsBuilder builder, MetricsHandler metricsHandler) {
    }

    @Override
    public void initializeServiceMetrics(MetricsBuilder builder, MetricsHandler handler) {
        MetricDescriptor desc = builder.buildTotalValueMetric("esb.service.common.envelopesReceived");
        desc.setDescription("Total number of times this service has been invoked since the last reset.");
        this.envelopesReceived = handler.registerMetric(desc);
        desc = builder.buildTotalValueMetric("esb.service.common.serviceFaultedCount");
        desc.setDescription("Total number of times this service has been invoked and produced a fault since the last reset.");
        this.serviceFaultedCount = handler.registerMetric(desc);
        desc = builder.buildTotalValueMetric("esb.service.common.serviceFailedCount");
        desc.setDescription("Total number of times this service has been invoked and threw an exception since the last reset.");
        this.serviceFailedCount = handler.registerMetric(desc);
        desc = builder.buildPerSecondRateMetric("esb.service.common.envelopesReceivedPerSecond");
        desc.setDescription("Rate (per second) at which this service has been invoked over the collection interval.");
        desc.setSupportsHighThresholdAlerts(true);
        desc.setSupportsLowThresholdAlerts(true);
        this.envelopesReceivedPerSecond = handler.registerMetric(desc);
        desc = builder.buildRollingAverageMetric("esb.service.common.averageExecutionTime");
        desc.setDescription("Average execution time (in miliseconds) over the collection interval.");
        desc.setSupportsHighThresholdAlerts(true);
        desc.setSupportsLowThresholdAlerts(true);
        this.averageExecutionTime = handler.registerMetric(desc);
    }

    public void setTarget(SFCService target) {
        this.target = target;
    }
}

