/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.ramps.IAsycnRamp;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IDataSource;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.esb.service.common.ramps.MappingException;
import com.sonicsw.esb.service.common.ramps.impl.AsyncJob;
import com.sonicsw.esb.service.common.ramps.impl.OnRampParameter;
import com.sonicsw.esb.service.common.ramps.impl.QuartzUtils;
import com.sonicsw.esb.service.common.ramps.impl.ReconnectJob;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQDispatchException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public final class AsyncOnRamp
implements IAsycnRamp {
    private static final Logger LOGGER = LogManager.getLogger(AsyncOnRamp.class);
    private static final long MIN_RETRY_INTERVAL = 1000L;
    private static final String SCHEDULE_JOB_NAME = "AsyncOnRampJob";
    private static final String RECONNECT_JOB_NAME = "AsyncReconnectJob";
    private volatile boolean initialized_;
    private volatile boolean started_;
    private final Object startedLock_ = new Object();
    private long timerInterval_;
    private String cronString_;
    private long retryInterval_ = 60000L;
    private Scheduler scheduler_;
    private SFCInitializationContext initContext_;
    private IDataSource dataSource_;
    private final OnRampParameter onRampParams_;
    private String jobAndTriggerGroup_;
    private IConnectionContext eventDrivenConnection_;

    public AsyncOnRamp() {
        this(null);
    }

    public AsyncOnRamp(IDataSource _dataSource) {
        this.dataSource_ = _dataSource;
        this.onRampParams_ = new OnRampParameter(-1);
    }

    public void setDataSource(IDataSource _dataSource) {
        this.dataSource_ = _dataSource;
    }

    @Override
    public IDataSource getDataSource() {
        return this.dataSource_;
    }

    public SFCInitializationContext getInitialContext() {
        return this.initContext_;
    }

    public OnRampParameter getOnRampParams() {
        return this.onRampParams_;
    }

    public void setEventDrivenConnection(IConnectionContext _eventDrivenConnection) {
        this.eventDrivenConnection_ = _eventDrivenConnection;
    }

    public void init(SFCInitializationContext _context) throws XQServiceException {
        if (null == _context) {
            throw new IllegalArgumentException("The context must not be null.");
        }
        this.initContext_ = _context;
        SFCParameters params = this.initContext_.getParameters();
        this.cronString_ = params.getParameter("CronString", "").trim();
        try {
            this.timerInterval_ = Long.parseLong(params.getParameter("CheckInterval", Long.toString(this.timerInterval_)));
        }
        catch (NumberFormatException e) {
            throw new XQServiceException("Cannot parse the parameter CheckInterval since it is not a long number.");
        }
        if (this.timerInterval_ < 0L) {
            throw new XQServiceException("Parameter value of CheckInterval needs to be greater or equal to zero. Value specified is " + this.timerInterval_ + ".");
        }
        try {
            this.retryInterval_ = Long.parseLong(params.getParameter("RetryTimeout", Long.toString(this.retryInterval_)));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the parameter RetryTimeout since it is not a long number.");
        }
        if (this.retryInterval_ <= 1000L) {
            LOGGER.warn("Parameter value of RetryTimeout needs to be greater or equal to 1000ms. Value specified is " + this.retryInterval_ + ". Enforcing the minimum");
            this.retryInterval_ = 1000L;
        }
        this.jobAndTriggerGroup_ = this.initContext_.getServiceName() + this.hashCode();
        try {
            ArrayList cronStrings = this.parseCronStrings();
            int threadPoolSize = Math.min(5, cronStrings.size());
            this.scheduler_ = QuartzUtils.getScheduler(threadPoolSize);
            JobDetail jobDetail = new JobDetail(SCHEDULE_JOB_NAME, this.jobAndTriggerGroup_, AsyncJob.class);
            this.addJob(jobDetail);
            if (!cronStrings.isEmpty()) {
                LOGGER.info("Cron-Timing found. Cron String = " + this.cronString_);
                for (int i = 0; i < cronStrings.size(); ++i) {
                    String triggerName = "AsyncOnRampCron" + i;
                    CronTrigger trigger = new CronTrigger(triggerName, this.jobAndTriggerGroup_, (String)cronStrings.get(i));
                    this.scheduleJob(SCHEDULE_JOB_NAME, (Trigger)trigger);
                    LOGGER.info("Scheduling AsyncOnRamp trigger for " + cronStrings.get(i));
                }
            } else if (this.timerInterval_ > 0L) {
                SimpleTrigger trigger = new SimpleTrigger("AsyncOnRampTimer", this.jobAndTriggerGroup_, new Date(), null, -1, this.timerInterval_);
                this.scheduleJob(SCHEDULE_JOB_NAME, (Trigger)trigger);
                LOGGER.info("Scheduling AsyncOnRamp trigger for timer interval (in ms) " + this.timerInterval_);
            }
        }
        catch (SchedulerException e) {
            throw new XQServiceException((Throwable)e);
        }
        catch (ParseException e) {
            throw new XQServiceException((Throwable)e);
        }
        Utils.delegateCall(this.dataSource_, "init", new Class[]{SFCInitializationContext.class}, new Object[]{_context});
        Utils.delegateCall(this.dataSource_, "setAsyncRamp", new Class[]{IAsycnRamp.class}, new Object[]{this});
        this.onRampParams_.init(params);
        this.initialized_ = true;
    }

    private void scheduleJob(String _jobName, Trigger _trigger) throws SchedulerException {
        _trigger.setJobName(_jobName);
        _trigger.setJobGroup(this.jobAndTriggerGroup_);
        this.scheduler_.scheduleJob(_trigger);
    }

    private ArrayList parseCronStrings() {
        ArrayList<String> cronStrings = new ArrayList<String>();
        if (!"".equals(this.cronString_)) {
            StringTokenizer st = new StringTokenizer(this.cronString_, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                cronStrings.add(s.trim());
            }
        }
        return cronStrings;
    }

    private void addJob(JobDetail _jobDetail) throws SchedulerException {
        JobDataMap jdm = _jobDetail.getJobDataMap();
        jdm.put((Object)"actionObject", (Object)this);
        jdm.put((Object)"actionContext", (Object)this.initContext_);
        this.scheduler_.addJob(_jobDetail, true);
    }

    private void dispatch(XQEnvelope _envelope) throws XQDispatchException {
        XQDispatch dispatcher = this.initContext_.getDispatcher();
        try {
            dispatcher.dispatch(_envelope, XQQualityofService.EXACTLY_ONCE);
        }
        catch (XQDispatchException xde) {
            LOGGER.error("Message could not be dispatched", (Throwable)xde);
            throw xde;
        }
    }

    @Override
    public void mapAndDispatch(IConnectionContext _connectionContext, Object[] _rawMessages) throws XQDispatchException, InvalidConnectionException {
        if (!this.isStarted()) {
            throw new IllegalStateException("OnRamp is not yet started and cannot dispatch.");
        }
        this.checkDataSource();
        XQMessage[] messages = null;
        try {
            messages = this.dataSource_.getMessageMapper().mapForOnramp(_rawMessages, _connectionContext, this.initContext_, null, -1);
            if (null == messages || 0 == messages.length) {
                throw new IllegalStateException("No output messages result from the input messages [" + _rawMessages + "].");
            }
        }
        catch (MappingException me) {
            LOGGER.error("Error mapping incoming object to XQMessage.", (Throwable)me);
            throw new XQDispatchException((Throwable)me, null);
        }
        for (int i = 0; i < messages.length; ++i) {
            XQMessage message = messages[i];
            XQEnvelope envelope = this.initContext_.getEnvelopeFactory().createDefaultEnvelope();
            envelope.setMessage(message);
            LOGGER.debug("Dispatching message...");
            this.dispatch(envelope);
        }
    }

    private void checkDataSource() {
        if (null == this.dataSource_) {
            throw new IllegalStateException("OnRamp is not configured with a data source yet.");
        }
    }

    @Override
    public void reconnectRequest() throws XQServiceException {
        this.cleanupEventDrivenConnection(false);
        this.scheduleReconnect();
    }

    private void scheduleReconnect() throws XQServiceException {
        Date firstTime = new Date(new Date().getTime() + this.retryInterval_);
        SimpleTrigger trigger = new SimpleTrigger("AsyncOnRampReconnect", this.jobAndTriggerGroup_, firstTime, null, -1, this.retryInterval_);
        JobDetail jobDetail = new JobDetail(RECONNECT_JOB_NAME, this.jobAndTriggerGroup_, ReconnectJob.class);
        try {
            this.addJob(jobDetail);
            this.scheduleJob(RECONNECT_JOB_NAME, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new XQServiceException("Error scheduling the reconnect request. The stale connection was cleaned up but you need to manually reconnect now.", (Throwable)e);
        }
    }

    private void cleanupEventDrivenConnection(boolean _success) {
        if (null != this.eventDrivenConnection_) {
            this.eventDrivenConnection_.deactivate(_success);
            this.dataSource_.destroyConnection(this.eventDrivenConnection_, _success);
            this.eventDrivenConnection_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startedLock_;
        synchronized (object) {
            if (!this.initialized_) {
                throw new IllegalStateException("AsyncOnRamp components is not initialized.");
            }
            if (this.started_) {
                throw new IllegalStateException("AsyncOnRamp components is already started.");
            }
            if (null != this.scheduler_) {
                LOGGER.info("starting the scheduler");
                try {
                    this.scheduler_.start();
                    this.scheduler_.resumeTriggerGroup(this.jobAndTriggerGroup_);
                    this.scheduler_.resumeJobGroup(this.jobAndTriggerGroup_);
                }
                catch (SchedulerException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                Utils.delegateCall(this.dataSource_, "start");
            }
            catch (XQServiceException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.started_ = true;
        }
        if (this.isEventDrivenOnRamp() && !this.activateEventDrivenConnection()) {
            try {
                this.reconnectRequest();
            }
            catch (XQServiceException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public boolean activateEventDrivenConnection() {
        this.checkDataSource();
        try {
            IConnectionContext connection = this.dataSource_.createConnection(this.initContext_);
            if (null != connection) {
                try {
                    connection.activate();
                    this.eventDrivenConnection_ = connection;
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                    this.dataSource_.destroyConnection(connection, false);
                }
            }
        }
        catch (XQServiceException e) {
            LOGGER.error((Object)e);
        }
        catch (XQMessageException e) {
            LOGGER.error((Object)e);
        }
        return false;
    }

    private boolean isEventDrivenOnRamp() {
        return "".equals(this.cronString_) && this.timerInterval_ <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isEventDrivenOnRamp() && null != this.eventDrivenConnection_) {
            this.cleanupEventDrivenConnection(true);
        }
        Object object = this.startedLock_;
        synchronized (object) {
            if (!this.initialized_) {
                throw new IllegalStateException("AsyncOnRamp components is not initialized.");
            }
            if (!this.started_) {
                throw new IllegalStateException("AsyncOnRamp components is not started.");
            }
            if (null != this.scheduler_) {
                LOGGER.info("stopping the scheduler");
                try {
                    this.scheduler_.pauseTriggerGroup(this.jobAndTriggerGroup_);
                    this.scheduler_.pauseJobGroup(this.jobAndTriggerGroup_);
                    this.scheduler_.interrupt(SCHEDULE_JOB_NAME, this.jobAndTriggerGroup_);
                    this.scheduler_.interrupt(RECONNECT_JOB_NAME, this.jobAndTriggerGroup_);
                    int size = this.scheduler_.getCurrentlyExecutingJobs().size();
                    if (size > 0) {
                        LOGGER.warn("******************************** Currently executing jobs is at " + size);
                    }
                }
                catch (SchedulerException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                Utils.delegateCall(this.dataSource_, "stop");
            }
            catch (XQServiceException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.started_ = false;
        }
    }

    public void destroy() {
        if (null != this.scheduler_) {
            try {
                this.scheduler_.deleteJob(SCHEDULE_JOB_NAME, this.jobAndTriggerGroup_);
                this.scheduler_.deleteJob(RECONNECT_JOB_NAME, this.jobAndTriggerGroup_);
                if (this.scheduler_.getJobGroupNames().length == 0) {
                    this.scheduler_.shutdown(true);
                }
                this.scheduler_ = null;
            }
            catch (SchedulerException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            Utils.delegateCall(this.dataSource_, "destroy");
        }
        catch (XQServiceException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.initialized_ = false;
    }

    protected void finalize() throws Throwable {
        if (this.started_) {
            this.stop();
        }
        if (this.initialized_) {
            this.destroy();
        }
        super.finalize();
    }

    public String toString() {
        return "AsyncOnRamp [initialized=" + this.initialized_ + "; timerInterval=" + this.timerInterval_ + "; cronString=" + this.cronString_ + "]";
    }

    public boolean isInitialized() {
        return this.initialized_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.startedLock_;
        synchronized (object) {
            return this.started_;
        }
    }
}

