/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common;

import java.util.Comparator;
import java.util.StringTokenizer;

public final class VersionNumber
implements Comparable<VersionNumber> {
    private static final VersionNumber DEFAULT = new VersionNumber(1, 0, 0);
    private final int major;
    private final int minor;
    private final int point;
    private final int build;
    private final String asString;
    public static final Comparator<VersionNumber> MAJOR_MINOR_COMPARATOR = new MajorMinorComparator();

    public VersionNumber(int major, int minor, int point, int build) {
        this.major = major;
        this.minor = minor;
        this.point = point;
        this.build = build;
        this.asString = point > 0 ? major + "." + minor + "." + point + "." + build : major + "." + minor + "." + build;
    }

    public VersionNumber(int major, int minor, int build) {
        this(major, minor, 0, build);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPoint() {
        return this.point;
    }

    public int getBuild() {
        return this.build;
    }

    public String getDisplayString() {
        if (this.point > 0) {
            return "Version " + this.major + "." + this.minor + "." + this.point + " Build Number " + this.build;
        }
        return "Version " + this.major + "." + this.minor + " Build Number " + this.build;
    }

    @Override
    public int compareTo(VersionNumber other) {
        int majorDiff = this.major - other.major;
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = this.minor - other.minor;
        if (minorDiff != 0) {
            return minorDiff;
        }
        int pointDiff = this.point - other.point;
        if (pointDiff != 0) {
            return pointDiff;
        }
        return this.build - other.build;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        return this.major == other.major && this.minor == other.minor && this.point == other.point && this.build == other.build;
    }

    public int hashCode() {
        return this.asString.hashCode();
    }

    public String toString() {
        return this.asString;
    }

    public static VersionNumber valueOf(String str) {
        int minor;
        StringTokenizer tokens = new StringTokenizer(str, ".");
        int count = tokens.countTokens();
        if (count == 0 || count > 4) {
            throw new IllegalArgumentException("Version string '" + str + "' is not in the required format: major.minor.point.build");
        }
        int major = Integer.parseInt(tokens.nextToken());
        int n = minor = tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0;
        int point = count > 3 ? (tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0) : 0;
        int build = tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0;
        return new VersionNumber(major, minor, point, build);
    }

    public static VersionNumber getDefault() {
        return DEFAULT;
    }

    private static final class MajorMinorComparator
    implements Comparator<VersionNumber> {
        private MajorMinorComparator() {
        }

        @Override
        public int compare(VersionNumber v1, VersionNumber v2) {
            int majorDiff = v1.major - v2.major;
            if (majorDiff != 0) {
                return majorDiff;
            }
            return v1.minor - v2.minor;
        }
    }
}

