/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.ContextAwareVariableResolver;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableFactory;
import com.sonicsw.esb.service.common.util.variables.VariableResolver;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageVariableResolver
implements ContextAwareVariableResolver,
VariableFactory {
    public static final String SCHEME = "esbmsg";
    private static final Logger logger = LogManager.getLogger((String)(VariableResolver.class.getName() + '.' + "esbmsg"));
    private XQMessage message;

    public MessageVariableResolver() {
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException excp) {
            throw new IllegalStateException(excp.getMessage());
        }
    }

    public String getScheme() {
        return SCHEME;
    }

    public MessageVariableResolver(XQMessage message) {
        this.message = message;
    }

    @Override
    public final void setContext(SFCServiceContext context) {
        this.setMessage(context.getMessageEnvelope().getMessage());
    }

    public final void setMessage(XQMessage message) {
        this.message = message;
    }

    @Override
    public String resolve(String variableStr) {
        CheckArg.notNull(variableStr, "variableStr");
        if (this.message == null) {
            throw new IllegalStateException("Cannot resolve variable '" + variableStr + "' - there is no current ESB message.");
        }
        try {
            MessageVariable var = (MessageVariable)this.getVariable(variableStr);
            if (var.type.equals(MessageVariable.HEADER)) {
                return this.resolveHeader(var.getSource());
            }
            if (var.type.equals(MessageVariable.PART_BY_NAME)) {
                return this.resolvePartByContentID(var.getSource());
            }
            if (var.type.equals(MessageVariable.PART_BY_INDEX)) {
                return this.resolvePartByIndex(var.getSource());
            }
            throw new IllegalStateException("Unsupported message variable type: " + var.getType());
        }
        catch (XQMessageException excp) {
            return null;
        }
    }

    private String resolveHeader(String headerName) throws XQMessageException {
        Object value = this.message.getHeaderValue(headerName);
        return value != null ? value.toString() : null;
    }

    private String resolvePartByContentID(String contentID) throws XQMessageException {
        XQPart part = this.message.getPart(contentID);
        return this.partToString(part);
    }

    private String resolvePartByIndex(String key) throws XQMessageException {
        int index = Integer.parseInt(key);
        XQPart part = this.message.getPart(index);
        return this.partToString(part);
    }

    private String partToString(XQPart part) {
        if (part != null) {
            Object content = part.getContent();
            return content != null ? content.toString() : null;
        }
        return null;
    }

    @Override
    public VariableFactory.Variable getVariable(String variableStr) {
        return new MessageVariable(variableStr);
    }

    public VariableFactory.Variable createHeaderVariable(String header) {
        return new MessageVariable(MessageVariable.HEADER, header);
    }

    public VariableFactory.Variable createPartVariable(String contentID) {
        return new MessageVariable(MessageVariable.PART_BY_NAME, contentID);
    }

    public VariableFactory.Variable createPartByIndexVariable(int index) {
        return new MessageVariable(MessageVariable.PART_BY_INDEX, Integer.toString(index));
    }

    public static class MessageVariable
    implements VariableFactory.Variable {
        public static final Type HEADER = new Type("header");
        public static final Type PART_BY_NAME = new Type("part");
        public static final Type PART_BY_INDEX = new Type("part_idx");
        public static final String SCHEME = "esbmsg";
        private final Type type;
        private final String variableStr;
        private final String source;

        MessageVariable(String variableStr) {
            StringTokenizer parts = new StringTokenizer(variableStr, ":");
            if (parts.countTokens() != 3 || !"esbmsg".equals(parts.nextToken())) {
                throw new IllegalArgumentException("Malformed message variable string: '" + variableStr + "'. Expected format is 'esbmsg:type:source'.");
            }
            this.type = this.typeFromString(parts.nextToken());
            this.source = parts.nextToken();
            this.variableStr = variableStr;
        }

        MessageVariable(Type type, String source) {
            CheckArg.notNull(type, "type");
            CheckArg.notEmpty(source, "source");
            this.type = type;
            this.source = source;
            this.variableStr = "esbmsg:" + type.name + ':' + source;
        }

        public Type getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.variableStr;
        }

        private Type typeFromString(String str) {
            if (MessageVariable.HEADER.name.equals(str)) {
                return HEADER;
            }
            if (MessageVariable.PART_BY_NAME.name.equals(str)) {
                return PART_BY_NAME;
            }
            if (MessageVariable.PART_BY_INDEX.name.equals(str)) {
                return PART_BY_INDEX;
            }
            throw new IllegalArgumentException("Unsupported esbmsg variable type: " + str);
        }

        public static final class Type {
            protected String name;

            private Type(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

