/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.metrics.MetricDescriptor;
import com.sonicsw.esb.service.common.metrics.SFCMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;

class SFCMetricImpl
implements SFCMetric {
    private final MetricDescriptor desc;
    private final IMetricInfo info;
    private IStatistic statistic;
    private boolean enabled = false;

    public SFCMetricImpl(MetricDescriptor desc) {
        IMetricInfo newInfo = this.createMetricInfo(desc);
        IStatistic statistic = null;
        if (!desc.isInstanceMetric()) {
            statistic = this.createStatistic(desc);
        }
        this.desc = desc;
        this.info = newInfo;
        this.statistic = statistic;
    }

    public void enable() {
        if (this.desc.isInstanceMetric()) {
            this.statistic = this.createStatistic(this.desc);
        }
        this.enabled = true;
    }

    public void disable() {
        if (this.desc.isInstanceMetric()) {
            this.statistic = null;
        }
        this.enabled = false;
    }

    @Override
    public long getRawValue() {
        if (!this.enabled) {
            throw new IllegalStateException("Metric not enabled.");
        }
        return this.statistic.getCurrentValue();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void resetValue() {
        if (this.statistic != null) {
            this.statistic.reset();
        }
    }

    @Override
    public void incrementValue() {
        this.updateValue(1L);
    }

    @Override
    public void updateValue(long value) {
        if (this.statistic != null) {
            this.statistic.updateValue(value);
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.desc;
    }

    public IMetricInfo getMetricInfo() {
        return this.info;
    }

    public IStatistic getStatistic() {
        return this.statistic;
    }

    private IStatistic createStatistic(MetricDescriptor desc) {
        IStatisticProvider[] providers = null;
        IStatistic statistic = StatisticsFactory.createStatistic((short)desc.getUpdateMode().getValue(), (boolean)desc.intervalMode(), providers, (short)desc.getHistoryMode().getValue());
        statistic.setInitialValue(desc.getInitialValue());
        return statistic;
    }

    private IMetricIdentity createMetricIdentity(MetricDescriptor desc) {
        return MetricsFactory.createMetricIdentity((String)desc.getName());
    }

    private IMetricInfo createMetricInfo(MetricDescriptor desc) {
        IMetricIdentity id = this.createMetricIdentity(desc);
        return MetricsFactory.createMetricInfo((IMetricIdentity)id, (short)desc.getType().getValue(), (String)desc.getDescription(), null, (boolean)desc.isInstanceMetric(), (boolean)true, (boolean)desc.supportsHighThresholdAlerts(), (boolean)desc.supportsLowThresholdAlerts(), (String)desc.getUnits());
    }
}

