/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCDiagnosticContext;
import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCRuntimeException;
import com.sonicsw.esb.service.common.SFCService;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.SFCServiceDescriptor;
import com.sonicsw.esb.service.common.SFCServiceException;
import com.sonicsw.esb.service.common.VersionNumber;
import com.sonicsw.esb.service.common.impl.SFCDiagnosticContextFactory;
import com.sonicsw.esb.service.common.impl.SFCDiagnosticContextFactoryImpl;
import com.sonicsw.esb.service.common.impl.SFCServiceContextFactory;
import com.sonicsw.esb.service.common.impl.SimpleServiceDescriptor;
import com.sonicsw.esb.service.common.impl.core.AbstractXQService;
import com.sonicsw.esb.service.common.impl.events.SFCServiceLifecycleEvent;
import com.sonicsw.esb.service.common.metrics.ContainerMetricsHandler;
import com.sonicsw.esb.service.common.metrics.MetricsBuilder;
import com.sonicsw.esb.service.common.metrics.MetricsCapable;
import com.sonicsw.esb.service.common.metrics.NoOpMetricsHandler;
import com.sonicsw.esb.service.common.metrics.NoOpNotificationsHandler;
import com.sonicsw.esb.service.common.metrics.NotificationsCapable;
import com.sonicsw.esb.service.common.metrics.NotificationsHandler;
import com.sonicsw.esb.service.common.metrics.ServiceMetricsHandler;
import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceEx;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.service.ESBSpringUtils;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.GenericApplicationContext;

public abstract class AbstractSFCServiceImpl
extends AbstractXQService
implements XQServiceEx,
SFCServiceDescriptor,
SFCService,
ApplicationContextAware {
    private static ApplicationContext sharedApplicationContext;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private SFCServiceDescriptor serviceDescriptor = new SimpleServiceDescriptor("unspecified");
    private SFCInitializationContext initContext;
    private SFCServiceContextFactory contextFactory;
    private MetricsBuilder metricsBuilder = new MetricsBuilder();
    private ContainerMetricsHandler containerMetricsHandler = new NoOpMetricsHandler();
    private ServiceMetricsHandler serviceMetricsHandler = new NoOpMetricsHandler();
    private NotificationsHandler notificationsHandler = new NoOpNotificationsHandler();
    private MetricsCapable defaultMetricsProvider;
    private NotificationsCapable defaultNotificationsProvider;
    private SFCDiagnosticContextFactory diagnosticContextFactory = new SFCDiagnosticContextFactoryImpl();
    private SFCService serviceDelegate = this;
    private Properties initContextProperties;
    private ApplicationContext applicationContext;
    private final Set activeListeners = new HashSet();
    private boolean disableApplicationContexts = false;

    public final void init(XQInitContext xqInitContext) throws XQServiceException {
        CheckArg.notNull(xqInitContext, "xqInitContext");
        try {
            this.initializeApplicationContext(xqInitContext);
            this.updateInitContext(xqInitContext);
            this.setThreadContext();
            this.writeStartupMessage();
            SFCDiagnosticContext.writeToLog();
            this.initContext.getParameters().writeToLog();
            this.initMetricsAndNotifications();
            Check.isSet(this.serviceDelegate, "serviceDelegate");
            this.fireLifecycleEvent(0);
            this.serviceDelegate.doInit(this.initContext);
            this.fireLifecycleEvent(1);
        }
        catch (SFCRuntimeException excp) {
            throw (SFCServiceException)((Object)excp.getCause());
        }
        catch (XQServiceException excp) {
            throw excp;
        }
        catch (RuntimeException excp) {
            throw excp;
        }
        finally {
            this.unsetThreadContext();
        }
    }

    private void updateInitContext(XQInitContext xqInitContext) {
        Check.isSet(this.initContext, "initContext");
        this.initContext.setXQInitContext(xqInitContext);
    }

    public final void start() {
        try {
            this.setThreadContext();
            this.fireLifecycleEvent(2);
            this.serviceDelegate.doStart();
            this.fireLifecycleEvent(3);
        }
        catch (XQServiceException excp) {
            throw new RuntimeException(excp);
        }
        catch (RuntimeException excp) {
            throw excp;
        }
        finally {
            this.unsetThreadContext();
        }
    }

    public final void stop() {
        try {
            this.setThreadContext();
            this.fireLifecycleEvent(4);
            this.serviceDelegate.doStop();
            this.fireLifecycleEvent(5);
        }
        catch (XQServiceException excp) {
            throw new RuntimeException(excp);
        }
        catch (RuntimeException excp) {
            throw excp;
        }
        finally {
            this.unsetThreadContext();
        }
    }

    public final void destroy() {
        try {
            this.setThreadContext();
            this.fireLifecycleEvent(6);
            this.serviceDelegate.doDestroy();
            this.fireLifecycleEvent(7);
        }
        catch (XQServiceException excp) {
            throw new RuntimeException(excp);
        }
        finally {
            this.unsetThreadContext();
        }
    }

    public final void service(XQServiceContext xqContext) throws XQServiceException {
        CheckArg.notNull(xqContext, "xqContext");
        this.trackThread();
        SFCServiceContext context = this.contextFactory.createServiceContext(xqContext);
        Properties previousContext = this.setThreadContext(context);
        try {
            SFCDiagnosticContext.writeToLog();
            context.getParameters().writeToLog();
            this.writeServiceMessage(context);
            this.serviceDelegate.doService(context, context.getMessageEnvelope());
        }
        catch (SFCRuntimeException excp) {
            throw (SFCServiceException)((Object)excp.getCause());
        }
        catch (XQServiceException excp) {
            throw excp;
        }
        catch (RuntimeException excp) {
            throw excp;
        }
        finally {
            this.setThreadContext(previousContext);
            this.releaseThread();
        }
    }

    private void fireLifecycleEvent(int eventType) {
        if (this.applicationContext != null) {
            this.applicationContext.publishEvent((ApplicationEvent)new SFCServiceLifecycleEvent(this, eventType));
        }
    }

    @Override
    public void doInit(SFCInitializationContext context) throws XQServiceException {
    }

    @Override
    public void doStart() throws XQServiceException {
    }

    @Override
    public void doStop() throws XQServiceException {
    }

    @Override
    public void doDestroy() throws XQServiceException {
    }

    @Override
    public abstract void doService(SFCServiceContext var1, XQEnvelope var2) throws XQServiceException;

    protected void writeStartupMessage() {
        VersionNumber version = this.getVersion();
        if (version == null) {
            version = VersionNumber.getDefault();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n\n\t").append(this.getDisplayName());
        buffer.append("\n\t").append(version.getDisplayString());
        String copyright = this.getCopyright();
        if (copyright != null && copyright.length() > 0) {
            buffer.append("\n\t").append(copyright);
        }
        buffer.append("\n");
        this.logger.info((CharSequence)buffer);
    }

    protected void writeServiceMessage(SFCServiceContext context) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        StringBuffer msg = new StringBuffer("Handling message");
        if (context.isInProcess()) {
            msg.append(" as step '").append(context.getProcessStepName());
            msg.append("' of process '").append(context.getProcessName());
            msg.append("'");
        }
        msg.append(" on listener ").append(context.getCurrentListener());
        msg.append(" of ").append(this.initContext.getNumberOfListeners());
        msg.append(".");
        this.logger.debug((CharSequence)msg);
    }

    private void initMetricsAndNotifications() {
        if (this.defaultMetricsProvider != null) {
            this.logger.debug("Initializing default metrics.");
            this.defaultMetricsProvider.initializeContainerMetrics(this.metricsBuilder, this.containerMetricsHandler);
            this.defaultMetricsProvider.initializeServiceMetrics(this.metricsBuilder, this.serviceMetricsHandler);
        }
        if (this.defaultNotificationsProvider != null) {
            this.logger.debug("Initializing default notifications.");
            this.defaultNotificationsProvider.initializeNotifications(this.notificationsHandler);
        }
        if (this instanceof MetricsCapable) {
            this.logger.debug("Initializing custom metrics.");
            ((MetricsCapable)((Object)this)).initializeContainerMetrics(this.metricsBuilder, this.containerMetricsHandler);
            ((MetricsCapable)((Object)this)).initializeServiceMetrics(this.metricsBuilder, this.serviceMetricsHandler);
        }
        if (this instanceof NotificationsCapable) {
            this.logger.debug("Initializing custom notifications.");
            ((NotificationsCapable)((Object)this)).initializeNotifications(this.notificationsHandler);
        }
        this.logger.debug("Metrics and notifications registration period has ended.");
    }

    @Override
    public String getName() {
        Check.isSet(this.serviceDescriptor, "serviceDescriptor");
        return this.serviceDescriptor.getName();
    }

    @Override
    public String getDisplayName() {
        Check.isSet(this.serviceDescriptor, "serviceDescriptor");
        return this.serviceDescriptor.getDisplayName();
    }

    @Override
    public VersionNumber getVersion() {
        Check.isSet(this.serviceDescriptor, "serviceDescriptor");
        return this.serviceDescriptor.getVersion();
    }

    @Override
    public String getCopyright() {
        Check.isSet(this.serviceDescriptor, "copyright");
        return this.serviceDescriptor.getCopyright();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackThread() {
        Set set = this.activeListeners;
        synchronized (set) {
            this.activeListeners.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseThread() {
        Set set = this.activeListeners;
        synchronized (set) {
            this.activeListeners.remove(Thread.currentThread());
        }
    }

    private Properties setThreadContext(Properties props) {
        return SFCDiagnosticContext.set(props);
    }

    private Properties setThreadContext() {
        if (this.initContextProperties == null) {
            Check.isSet(this.initContext, "initContext");
            Check.isSet(this.diagnosticContextFactory, "diagnosticContextFactory");
            this.initContextProperties = this.diagnosticContextFactory.extractProperties(this.initContext);
        }
        return this.setThreadContext(this.initContextProperties);
    }

    private Properties setThreadContext(SFCServiceContext serviceContext) {
        return this.setThreadContext(this.diagnosticContextFactory.extractProperties(serviceContext));
    }

    private void unsetThreadContext() {
        SFCDiagnosticContext.remove();
    }

    private void initializeApplicationContext(XQInitContext xqInitContext) {
        if (this.disableApplicationContexts || this.applicationContext != null) {
            return;
        }
        AbstractSFCServiceImpl.initializeSharedApplicationContext(xqInitContext.getLog());
        GenericApplicationContext ctx = ESBSpringUtils.createApplicationContext((String)"ESBServiceApplicationContext_");
        ctx.setParent(sharedApplicationContext);
        PropertyPlaceholderConfigurer propertyProcessor = new PropertyPlaceholderConfigurer();
        propertyProcessor.setProperties(this.getServiceProperties(xqInitContext.getParameters()));
        propertyProcessor.setOrder(Integer.MIN_VALUE);
        ctx.getBeanFactory().registerSingleton("servicePropertyConfigurer", (Object)propertyProcessor);
        ctx.getBeanFactory().registerSingleton("xqServiceFactory", new Object(){

            public XQService getService() {
                return AbstractSFCServiceImpl.this;
            }
        });
        ctx.getBeanFactory().registerSingleton("initParameters", (Object)xqInitContext.getParameters());
        ESBSpringUtils.readBeanConfigurationsFromClassPath((String)"classpath*:config/esb/serviceAppContext.xml", (BeanDefinitionRegistry)ctx);
        ctx.refresh();
        this.applicationContext = ctx;
    }

    private Properties getServiceProperties(XQParameters params) {
        Properties props = new Properties();
        props.put("SonicXQ.ServiceName", params.getParameter("SonicXQ.ServiceName", 1));
        props.put("SonicXQ.ServiceType", params.getParameter("SonicXQ.ServiceType", 1));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSharedApplicationContext(XQLog xqLog) {
        if (sharedApplicationContext != null) {
            return;
        }
        GenericApplicationContext ctx = ESBSpringUtils.createApplicationContext((String)"ESBSharedApplicationContext");
        ctx.getBeanFactory().registerSingleton("xqLog", (Object)xqLog);
        ctx.getBeanFactory().registerSingleton("xqConfigManager", (Object)XQConfigManager.getInstance(null));
        ctx.getBeanFactory().registerSingleton("containerComponentContext", (Object)XQConfigManager.getInstance(null).getComponentContext());
        ESBSpringUtils.readBeanConfigurationsFromClassPath((String)"classpath*:config/esb/containerAppContext.xml", (BeanDefinitionRegistry)ctx);
        ctx.refresh();
        Class<AbstractSFCServiceImpl> clazz = AbstractSFCServiceImpl.class;
        synchronized (AbstractSFCServiceImpl.class) {
            sharedApplicationContext = ctx;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setInitializationContext(SFCInitializationContext initContext) {
        CheckArg.notNull(initContext, "initContext");
        this.initContext = initContext;
    }

    public void setServiceContextFactory(SFCServiceContextFactory contextFactory) {
        CheckArg.notNull(contextFactory, "contextFactory");
        this.contextFactory = contextFactory;
    }

    public void setContainerMetricsHandler(ContainerMetricsHandler metricsHandler) {
        CheckArg.notNull(metricsHandler, "metricsHandler");
        this.containerMetricsHandler = metricsHandler;
    }

    public void setServiceMetricsHandler(ServiceMetricsHandler metricsHandler) {
        CheckArg.notNull(metricsHandler, "metricsHandler");
        this.serviceMetricsHandler = metricsHandler;
    }

    public void setNotificationsHandler(NotificationsHandler notificationsHandler) {
        CheckArg.notNull(notificationsHandler, "notificationsHandler");
        this.notificationsHandler = notificationsHandler;
    }

    public void setServiceDescriptor(SFCServiceDescriptor serviceDescriptor) {
        CheckArg.notNull(serviceDescriptor, "serviceDescriptor");
        this.serviceDescriptor = serviceDescriptor;
    }

    public void setDiagnosticContextFactory(SFCDiagnosticContextFactory diagnosticContextFactory) {
        CheckArg.notNull(diagnosticContextFactory, "diagnosticContextFactory");
        this.diagnosticContextFactory = diagnosticContextFactory;
    }

    public void setDefaultMetricsProvider(MetricsCapable defaultMetricsProvider) {
        this.defaultMetricsProvider = defaultMetricsProvider;
    }

    public void setDefaultNotificationsProvider(NotificationsCapable defaultNotificationsProvider) {
        this.defaultNotificationsProvider = defaultNotificationsProvider;
    }

    public void setMetricsBuilder(MetricsBuilder metricsBuilder) {
        this.metricsBuilder = metricsBuilder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setServiceDelegate(SFCService delegate) {
        this.serviceDelegate = delegate != null ? delegate : this;
    }

    public final void doNotCreateApplicationContexts() {
        this.disableApplicationContexts = true;
    }
}

