/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.SFCDiagnosticContextFactory;
import java.util.Properties;
import org.springframework.util.StringUtils;

class SFCDiagnosticContextFactoryImpl
implements SFCDiagnosticContextFactory {
    private static final String DOMAIN = "Domain";
    private static final String MF_CONTAINER = "MFContainer";
    private static final String ESB_CONTAINER = "ESBContainer";
    private static final String SERVICE = "Service";
    private static final String SERVICE_TYPE = "ServiceType";
    private static final String CURRENT_LISTENER = "CurrentListener";
    private static final String PROCESS = "Process";
    private static final String PROCESS_STEP = "ProcessStep";
    private static final String PROCESS_ID = "ProcessID";

    SFCDiagnosticContextFactoryImpl() {
    }

    @Override
    public Properties extractProperties(SFCInitializationContext context) {
        Properties props = new Properties();
        this.addInitContext(props, context);
        return props;
    }

    @Override
    public Properties extractProperties(SFCServiceContext context) {
        Properties props = this.extractProperties((SFCInitializationContext)context);
        this.addProperty(props, CURRENT_LISTENER, Integer.toString(context.getCurrentListener()));
        if (context.isInProcess()) {
            this.addProperty(props, PROCESS_ID, context.getProcessID());
            this.addProperty(props, PROCESS, context.getProcessName());
            this.addProperty(props, PROCESS_STEP, context.getProcessStepName());
        }
        return props;
    }

    private void addInitContext(Properties props, SFCInitializationContext context) {
        this.addProperty(props, DOMAIN, context.getDomainName());
        this.addProperty(props, MF_CONTAINER, context.getMFContainerName());
        this.addProperty(props, ESB_CONTAINER, context.getESBContainerName());
        this.addProperty(props, SERVICE, context.getServiceName());
        this.addProperty(props, SERVICE_TYPE, context.getServiceTypeName());
    }

    private void addProperty(Properties props, String key, String value) {
        if (StringUtils.hasLength((String)key) && StringUtils.hasLength((String)value)) {
            props.setProperty(key, value);
        }
    }
}

