/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.esbclient.impl;

import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIFactory;
import com.sonicsw.esb.mgmtapi.config.IAddress;
import com.sonicsw.esb.mgmtapi.config.IConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IJMSConnectionConfig;
import com.sonicsw.esb.mgmtapi.config.IJMSEndpointConfig;
import com.sonicsw.esb.mgmtapi.config.IProcessConfig;
import com.sonicsw.esb.mgmtapi.config.IProcessConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IServiceConfig;
import com.sonicsw.esb.mgmtapi.config.IServiceConfigAPI;
import com.sonicsw.esb.service.common.util.esbclient.ESBClientMsgUtil;
import com.sonicsw.esb.service.common.util.esbclient.ESBClientUtilContext;
import com.sonicsw.esb.service.common.util.esbclient.ESBClientUtilException;
import com.sonicsw.esb.service.common.util.esbclient.ESBClientUtilFactory;
import com.sonicsw.esb.service.common.util.esbclient.ESBMessageListener;
import com.sonicsw.esb.service.common.util.esbclient.IReceiveRegistration;
import com.sonicsw.esb.service.common.util.esbclient.impl.ReceiveRegistrationImpl;
import com.sonicsw.esb.service.common.util.message.EsbMsgTypeUtil;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.XQJMSMessageMapper;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.util.sonicfs.Handler;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.DeliveryMode;
import progress.message.jclient.Topic;

public class ESBClientMsgUtilImpl
implements ESBClientMsgUtil {
    private ESBAPI m_api = null;
    private String m_domain = null;
    private String m_url = null;
    private String m_user = null;
    private String m_password = null;
    private IServiceConfigAPI m_serviceApi = null;
    private IProcessConfigAPI m_processApi = null;
    private IEndpointConfigAPI m_endpointApi = null;
    private static volatile ESBAPIFactory m_fact = null;
    private int m_cacheSize = 10;
    private LinkedList m_msgConsumer = new LinkedList();
    private ESBClientUtilFactory fact = new ESBClientUtilFactory();
    private IReceiveRegistration receive = this.fact.getIReceiveRegistration();
    private ReceiveRegistrationImpl rec = new ReceiveRegistrationImpl();
    private Map mProducerCache = new LinkedHashMap(this.m_cacheSize, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean cacheMap = false;
            if (this.size() > ESBClientMsgUtilImpl.this.m_cacheSize) {
                try {
                    MessageProducer msgProd = (MessageProducer)eldest.getValue();
                    msgProd.close();
                    cacheMap = true;
                }
                catch (Exception e) {
                    throw new ESBClientUtilException("Not able to close and remove least recently used MessageProducer from cache", e);
                }
            }
            return cacheMap;
        }
    };
    private Map mSessionCache = new LinkedHashMap(this.m_cacheSize, 0.75f, true){
        private static final long serialVersionUID = 2L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean cacheMap = false;
            if (this.size() > ESBClientMsgUtilImpl.this.m_cacheSize) {
                try {
                    SessionRecord sessRec = (SessionRecord)eldest.getValue();
                    LinkedList producerList = sessRec.getMsgProducer();
                    for (int i = 0; i <= producerList.size(); ++i) {
                        MessageProducer msgProd = (MessageProducer)producerList.get(i);
                        msgProd.close();
                    }
                    sessRec.getSession().close();
                    sessRec.getConnection().close();
                    cacheMap = true;
                }
                catch (Exception e) {
                    throw new ESBClientUtilException("Not able to close and remove least recently used SessionRecord instance from cache", e);
                }
            }
            return cacheMap;
        }
    };

    public ESBClientMsgUtilImpl(String domain, String url, String userName, String passWord, int cacheSize) {
        this.m_domain = domain;
        this.m_url = url;
        this.m_user = userName;
        this.m_password = passWord;
        try {
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if ("sonicfs".equals(protocol)) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("DOMAIN_NAME", ESBClientMsgUtilImpl.this.m_domain);
                        map.put("user", ESBClientMsgUtilImpl.this.m_user);
                        map.put("password", ESBClientMsgUtilImpl.this.m_password);
                        map.put("java.naming.provider.url", ESBClientMsgUtilImpl.this.m_url);
                        System.setProperty("com.sonicsw.xqimpl.config.isExtraContainer", "true");
                        Handler.setOverrideProperties(map);
                        return new Handler();
                    }
                    return null;
                }
            });
        }
        catch (Error error) {
            // empty catch block
        }
        if (cacheSize > 10 || cacheSize == 0) {
            this.m_cacheSize = cacheSize;
        }
        this.createApiInstances();
    }

    private void createApiInstances() throws ESBClientUtilException {
        try {
            m_fact = ESBAPIFactory.createESBAPIFactory();
            this.m_api = m_fact.createAPI(this.m_domain, this.m_url, this.m_user, this.m_password);
            if (this.m_api == null) {
                throw new ESBClientUtilException("ESBAPI instance is null ");
            }
            this.m_serviceApi = this.m_api.getServiceConfigAPI();
            this.m_processApi = this.m_api.getProcessConfigAPI();
            this.m_endpointApi = this.m_api.getEndpointConfigAPI();
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Failed to create ESBAPI, Service, Process and Endpoint api instances using Connection parameters", e);
        }
    }

    @Override
    public void sendMsgToEsbAddress(IAddress esbAddress, XQMessage msg, IAddress esbReplyToAddress) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Send XQMessage to ESBAddress ");
        ctx.setAddress(esbAddress);
        if (esbAddress == null) {
            throw new ESBClientUtilException("ESB Address is null", ctx);
        }
        if (msg == null) {
            throw new ESBClientUtilException("XQMessage is null ", ctx);
        }
        this.sendToAddress(esbAddress, msg);
    }

    @Override
    public void sendMsgToEsbService(String serviceName, XQMessage msg, IAddress esbReplyToAddress) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Send XQMessage to an ESB Service");
        ctx.setServiceName(serviceName);
        if (serviceName == null) {
            throw new ESBClientUtilException("Service Name is null ", ctx);
        }
        if (msg == null) {
            throw new ESBClientUtilException("XQMessage is null", ctx);
        }
        this.checkServiceApi(ctx);
        IServiceConfig endptServConfig = this.m_serviceApi.getServiceConfig(serviceName);
        if (endptServConfig == null) {
            throw new ESBClientUtilException(" Unable to retrieve Service Endpoint Configuration with  this Service Name as it is null");
        }
        IEndpointConfig endptConfig = endptServConfig.getEntryEndpointConfig();
        this.checkEndptConfigValidity(endptConfig, ctx);
        this.sendMsgToEntryEndpoint(endptConfig, msg, esbReplyToAddress);
    }

    @Override
    public void sendMsgToEsbProcess(String processName, XQMessage msg, IAddress esbReplyToAddress) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Sending XQMessage to an ESB Process");
        ctx.setProcessName(processName);
        if (processName == null) {
            throw new ESBClientUtilException("Process Name is null", ctx);
        }
        if (msg == null) {
            throw new ESBClientUtilException("XQMessage is null ", ctx);
        }
        if (this.m_processApi == null) {
            throw new ESBClientUtilException("ESBAPI instance is disposed(cleaned up) so process api instance is null", ctx);
        }
        IProcessConfig endptProcConfig = this.m_processApi.getProcess(processName);
        if (endptProcConfig == null) {
            throw new ESBClientUtilException("Unable to retrieve Process Endpoint Configuration with this Process Name as it is null");
        }
        IEndpointConfig endptConfig = endptProcConfig.getEntryEndpointConfig();
        this.checkEndptConfigValidity(endptConfig, ctx);
        this.sendMsgToEntryEndpoint(endptConfig, msg, esbReplyToAddress);
    }

    @Override
    public void sendMsgToEsbEndPoint(String endpointName, XQMessage msg, IAddress esbReplyToAddress) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Send XQMessage to an ESB Endpoint");
        ctx.setEndpointName(endpointName);
        if (endpointName == null) {
            throw new ESBClientUtilException(" Endpoint Name is null ", ctx);
        }
        if (msg == null) {
            throw new ESBClientUtilException(" Message is null ", ctx);
        }
        IAddress addr = this.validateEndPointGetAddress(ctx, endpointName);
        IEndpointConfig endptConfig = this.checkAddressGetAndValidateEndPointConfig(addr, ctx);
        this.sendMsgToEntryEndpoint(endptConfig, msg, esbReplyToAddress);
    }

    private void checkEndptConfigValidity(IEndpointConfig endptConfig, ESBClientUtilContext ctx) {
        if (endptConfig == null) {
            throw new ESBClientUtilException("Endpoint Configuration is null", ctx);
        }
    }

    private void sendToAddress(IAddress addr, XQMessage msg) throws ESBClientUtilException {
        try {
            switch (addr.getAddressType().getNumericType()) {
                case 1: {
                    this.sendMsgToEsbService(addr.getDestinationName(), msg, null);
                    break;
                }
                case 0: {
                    this.sendMsgToEsbEndPoint(addr.getDestinationName(), msg, null);
                }
            }
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to send Message to given ESB Address", e);
        }
    }

    private SessionRecord createSessionRecord(String brokerUrl, String brokeruserName, String brokerpassWord) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Create Connection using broker url, broker username and broker password");
        ctx.setBrokerurl(brokerUrl);
        ctx.setUsername(brokeruserName);
        ctx.setPassword(brokerpassWord);
        Connection conn = null;
        Session session = null;
        try {
            SessionRecord sessionRecNew = new SessionRecord();
            ConnectionFactory cf = new ConnectionFactory(brokerUrl, brokeruserName, brokerpassWord);
            if (!cf.getFaultTolerant().booleanValue()) {
                cf.setFaultTolerant(new Boolean(true));
            }
            if ((conn = cf.createConnection()) == null) {
                throw new ESBClientUtilException("Connection is null");
            }
            sessionRecNew.setConnection(conn);
            conn.start();
            session = conn.createSession(false, 1);
            if (session == null) {
                throw new ESBClientUtilException("Session is null");
            }
            sessionRecNew.setSession(session);
            return sessionRecNew;
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Connection  failed.", e, ctx);
        }
    }

    private void sendMsgToEntryEndpoint(IEndpointConfig endptConfig, XQMessage xqMessage, IAddress esbReplyToAddress) throws ESBClientUtilException {
        MessageProducer msgProducer = null;
        int deliveryMode = 0;
        try {
            IJMSEndpointConfig jmsEndptConfig = (IJMSEndpointConfig)endptConfig.getAdapter();
            if (jmsEndptConfig == null) {
                throw new ESBClientUtilException("Endpoint Configuration is null");
            }
            msgProducer = this.getMessageProducer(endptConfig, jmsEndptConfig, xqMessage, esbReplyToAddress);
            this.assignReplyTo(jmsEndptConfig, xqMessage, esbReplyToAddress);
            Message jmsMsg = (Message)XQJMSMessageMapper.create().translateInput(xqMessage, null);
            if (jmsMsg == null) {
                throw new ESBClientUtilException("Not able to convert XQMessage to Message");
            }
            if (jmsEndptConfig.getQOSLevel().equals(XQQualityofService.BEST_EFFORT)) {
                deliveryMode = 1;
                jmsMsg.setObjectProperty("JMS_SonicMQ_preserveUndelivered", null);
                jmsMsg.setObjectProperty("JMS_SonicMQ_notifyUndelivered", null);
            } else if (jmsEndptConfig.getQOSLevel().equals(XQQualityofService.BEST_EFFORT_DISCARDABLE)) {
                deliveryMode = DeliveryMode.DISCARDABLE;
                jmsMsg.setObjectProperty("JMS_SonicMQ_preserveUndelivered", null);
                jmsMsg.setObjectProperty("JMS_SonicMQ_notifyUndelivered", null);
            } else {
                deliveryMode = 2;
                jmsMsg.setBooleanProperty("JMS_SonicMQ_preserveUndelivered", true);
                jmsMsg.setBooleanProperty("JMS_SonicMQ_notifyUndelivered", true);
            }
            jmsMsg.setJMSPriority(jmsEndptConfig.getPriority());
            jmsMsg.setJMSExpiration(jmsEndptConfig.getTimeToLive());
            msgProducer.setDeliveryMode(deliveryMode);
            msgProducer.send(jmsMsg);
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to send Message to Destination using Endpoint Configuration", e);
        }
    }

    private MessageProducer getMessageProducer(IEndpointConfig endptConfig, IJMSEndpointConfig jmsConfig, XQMessage xqMessage, IAddress esbReplyToAddress) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Create MessageProducer based on Destination type from Endpoint Configuration");
        ctx.setEndpointConfig(endptConfig);
        MessageProducer msgProducer = null;
        Session session = null;
        try {
            IEndpointConfig.EndpointDestinationType destType = endptConfig.getDestinationType();
            IConnectionConfig iconnConfig = this.m_endpointApi.getConnectionConfig(endptConfig.getConnection());
            IConnectionConfig.ConnectionType connType = iconnConfig.getConnectionType();
            IJMSConnectionConfig connConfig = (IJMSConnectionConfig)iconnConfig.getAdapter(connType);
            ctx.setOperation("Create MessageProducer key  using Destination Name, EndpointDestinationType, Broker url and Broker user name. ");
            String producerKey = this.getCacheKey(endptConfig.getName(), destType, connConfig.getBrokerURLs(), connConfig.getUserName());
            msgProducer = (MessageProducer)this.mProducerCache.get(producerKey);
            if (msgProducer == null) {
                SessionRecord sessionRecord = this.createSessionRecordPopulateCache(ctx, connConfig);
                ctx.setOperation("Session Record exists, so get Session instance from it");
                session = sessionRecord.getSession();
                msgProducer = this.createMsgProdUsingDest(destType, session, jmsConfig, xqMessage, esbReplyToAddress);
                if (this.m_cacheSize > 0) {
                    ctx.setOperation("LRU caching for MessageProducer enabled, as cache size > 0");
                    sessionRecord.addMessageProducer(msgProducer);
                    this.mProducerCache.put(producerKey, msgProducer);
                }
            }
            return msgProducer;
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to create Message Producer", e, ctx);
        }
    }

    private MessageProducer createMsgProdUsingDest(IEndpointConfig.EndpointDestinationType destType, Session session, IJMSEndpointConfig jmsConfig, XQMessage xqMessage, IAddress esbReplyToAddress) throws ESBClientUtilException {
        Queue destination = null;
        MessageProducer msgProducer = null;
        Object endptConf = null;
        try {
            if (destType == IEndpointConfig.JMS_QUEUE) {
                destination = session.createQueue(jmsConfig.getDestinationName());
            } else if (destType == IEndpointConfig.JMS_TOPIC) {
                destination = session.createTopic(jmsConfig.getDestinationName());
            } else {
                throw new ESBClientUtilException("Unknown Destination type:" + destType);
            }
            if (destination == null) {
                throw new ESBClientUtilException("Destination is null");
            }
            msgProducer = session.createProducer((Destination)destination);
            if (msgProducer == null) {
                throw new ESBClientUtilException("Message Producer is null");
            }
            return msgProducer;
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to create Message Producer using Session on the Destination from Destination Type", e);
        }
    }

    private void assignReplyTo(IJMSEndpointConfig jmsConfig, XQMessage xqMessage, IAddress esbReplyToAddress) throws ESBClientUtilException {
        progress.message.jclient.Queue value = null;
        IEndpointConfig endptConf = null;
        progress.message.jclient.Queue dest = null;
        IEndpointConfig.EndpointDestinationType destType = jmsConfig.getDestinationType();
        try {
            if (esbReplyToAddress != null) {
                if (esbReplyToAddress.getAddressType().getTypeName().equals("ENDPOINT")) {
                    endptConf = this.m_endpointApi.getEndpoint(esbReplyToAddress.getDestinationName());
                } else if (esbReplyToAddress.getAddressType().getTypeName().equals("SERVICE")) {
                    IServiceConfig serviceConfig = this.m_serviceApi.getServiceConfig(esbReplyToAddress.getDestinationName());
                    endptConf = serviceConfig.getEntryEndpointConfig();
                } else if (esbReplyToAddress.getAddressType().getTypeName().equals("PROCESS")) {
                    IProcessConfig processConfig = this.m_processApi.getProcess(esbReplyToAddress.getDestinationName());
                    endptConf = processConfig.getEntryEndpointConfig();
                }
                IEndpointConfig.EndpointDestinationType destinationType = endptConf.getDestinationType();
                IJMSEndpointConfig jmsEndptConfig = (IJMSEndpointConfig)endptConf.getAdapter();
                if (destinationType == IEndpointConfig.JMS_QUEUE) {
                    dest = new progress.message.jclient.Queue(jmsEndptConfig.getDestinationName());
                } else if (destinationType == IEndpointConfig.JMS_TOPIC) {
                    dest = new Topic(jmsEndptConfig.getDestinationName());
                } else {
                    throw new ESBClientUtilException("Unknown Destination type:" + destType);
                }
                value = dest;
                if (value == null) {
                    throw new ESBClientUtilException("Destination is null, so cannot set ReplyTo header in XQMessage");
                }
                xqMessage.setHeaderValue("JMSReplyTo", (Object)value);
            }
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to set ReplyTo", e);
        }
    }

    private String getCacheKey(String destName, IEndpointConfig.EndpointDestinationType destType, String endpointUrl, String userName) {
        StringBuffer sbMsgProducer = new StringBuffer();
        sbMsgProducer.append(destName).append(endpointUrl).append(userName).append(destType.getName());
        return sbMsgProducer.toString();
    }

    private String getSessionCacheKey(String brokerUrl, String userName) {
        StringBuffer sbSession = new StringBuffer();
        sbSession.append(brokerUrl).append(userName);
        return sbSession.toString();
    }

    @Override
    public IReceiveRegistration registerForReceiveFromService(String serviceName, ESBMessageListener esbListener, IAddress esbAddressReplyTo) throws ESBClientUtilException {
        this.m_msgConsumer.clear();
        ESBClientUtilContext ctx = new ESBClientUtilContext("Receive Message from an  ESB Service Exit  Endpoint");
        ctx.setServiceName(serviceName);
        if (serviceName == null) {
            throw new ESBClientUtilException("Name of service exit endpoint is null ", ctx);
        }
        if (esbListener == null) {
            throw new ESBClientUtilException("ESBMessageListener instance is null", ctx);
        }
        this.checkServiceApi(ctx);
        IServiceConfig endptServConfig = this.m_serviceApi.getServiceConfig(serviceName);
        if (endptServConfig == null) {
            throw new ESBClientUtilException(" Unable to retrieve Service Exit Endpoint Configuration with  this Service Name, as it is null");
        }
        IAddress addr = endptServConfig.getFaultAddress();
        if (addr != null) {
            this.receiveFromExitEsbAddress(addr, esbListener, ESBMessageListener.SERVICE_FAULTED_MESSAGE, esbAddressReplyTo);
        }
        if ((addr = endptServConfig.getRejectedMessageAddress()) != null) {
            this.receiveFromExitEsbAddress(addr, esbListener, ESBMessageListener.SERVICE_REJECTED_MESSAGE, esbAddressReplyTo);
        }
        IAddress[] iaddress = endptServConfig.getExitAddresses();
        for (int i = 0; i < iaddress.length; ++i) {
            this.receiveFromExitEsbAddress(iaddress[i], esbListener, ESBMessageListener.SERVICE_EXIT_MESSAGE, esbAddressReplyTo);
        }
        return this.configReceiveMsgConsumer();
    }

    private void checkServiceApi(ESBClientUtilContext ctx) {
        if (this.m_serviceApi == null) {
            throw new ESBClientUtilException("ESBAPI instance is disposed(cleaned up) so service api instance is null ", ctx);
        }
    }

    @Override
    public IReceiveRegistration registerForReceiveFromProcess(String processName, ESBMessageListener esbListener, IAddress esbAddressReplyTo) throws ESBClientUtilException {
        this.m_msgConsumer.clear();
        ESBClientUtilContext ctx = new ESBClientUtilContext("Receive Message from an  ESB Process Exit  Endpoint");
        ctx.setProcessName(processName);
        if (processName == null) {
            throw new ESBClientUtilException("Name of process exit endpoint is null ", ctx);
        }
        if (esbListener == null) {
            throw new ESBClientUtilException("ESBMessageListener is null", ctx);
        }
        if (this.m_processApi == null) {
            throw new ESBClientUtilException("ESBAPI instance is disposed(cleaned up) so process api instance is null ", ctx);
        }
        IProcessConfig endptProcConfig = this.m_processApi.getProcess(processName);
        if (endptProcConfig == null) {
            throw new ESBClientUtilException(" Unable to retrieve Process Exit Endpoint Configuration with  this Process Name, as it is null");
        }
        IAddress addr = endptProcConfig.getFaultAddress();
        if (addr != null) {
            this.receiveFromExitEsbAddress(addr, esbListener, ESBMessageListener.PROCESS_FAULTED_MESSAGE, esbAddressReplyTo);
        }
        if ((addr = endptProcConfig.getRejectedMessageAddress()) != null) {
            this.receiveFromExitEsbAddress(addr, esbListener, ESBMessageListener.PROCESS_REJECTED_MESSAGE, esbAddressReplyTo);
        }
        IAddress[] iaddress = endptProcConfig.getExitAddresses();
        for (int i = 0; i < iaddress.length; ++i) {
            this.receiveFromExitEsbAddress(iaddress[i], esbListener, ESBMessageListener.PROCESS_EXIT_MESSAGE, esbAddressReplyTo);
        }
        return this.configReceiveMsgConsumer();
    }

    @Override
    public IReceiveRegistration registerForReceiveFromEndpoint(String endpointName, ESBMessageListener esbListener) throws ESBClientUtilException {
        this.m_msgConsumer.clear();
        ESBClientUtilContext ctx = new ESBClientUtilContext("Receive Message from an  ESB Exit Endpoint");
        ctx.setEndpointName(endpointName);
        if (endpointName == null) {
            throw new ESBClientUtilException("Name of exit endpoint is null ", ctx);
        }
        if (esbListener == null) {
            throw new ESBClientUtilException("ESBMessageListener is null", ctx);
        }
        IAddress addr = this.validateEndPointGetAddress(ctx, endpointName);
        IEndpointConfig endptConfig = this.checkAddressGetAndValidateEndPointConfig(addr, ctx);
        this.receiveMessage(endptConfig, esbListener, ESBMessageListener.OTHER_ADDRESS, addr);
        return this.configReceiveMsgConsumer();
    }

    private IAddress validateEndPointGetAddress(ESBClientUtilContext ctx, String endpointName) {
        if (this.m_endpointApi == null) {
            throw new ESBClientUtilException("ESBAPI instance is disposed(cleaned up) so endpoint api instance is null ", ctx);
        }
        IAddress addr = this.m_endpointApi.getEndpoint(endpointName).getAsAddress();
        return addr;
    }

    private IEndpointConfig checkAddressGetAndValidateEndPointConfig(IAddress addr, ESBClientUtilContext ctx) {
        if (addr == null) {
            throw new ESBClientUtilException("ESBAddress is null and so unable to retrieve Endpoint Configuration with this Endpoint Name ");
        }
        IEndpointConfig endptConfig = this.m_endpointApi.getEndpoint(addr.getDestinationName());
        this.checkEndptConfigValidity(endptConfig, ctx);
        return endptConfig;
    }

    @Override
    public IReceiveRegistration registerForReceiveFromESBAddress(IAddress esbAddress, ESBMessageListener esbListener) throws ESBClientUtilException {
        this.m_msgConsumer.clear();
        if (esbAddress == null) {
            throw new ESBClientUtilException("Name of ESB Address is null ");
        }
        if (esbListener == null) {
            throw new ESBClientUtilException("ESBMessageListener is null");
        }
        this.receivefromAddress(esbAddress, esbListener);
        return this.configReceiveMsgConsumer();
    }

    private IReceiveRegistration configReceiveMsgConsumer() {
        this.rec.setList(this.m_msgConsumer);
        this.receive = this.rec;
        return this.receive;
    }

    private void receivefromAddress(IAddress addr, ESBMessageListener esbListener) {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Receive Message from given ESB Address");
        ctx.setAddress(addr);
        try {
            switch (addr.getAddressType().getNumericType()) {
                case 1: {
                    ctx.setOperation("to receive message from the Service ESBAddress -service entry endpoint");
                    IServiceConfig serviceConfig = this.m_serviceApi.getServiceConfig(addr.getDestinationName());
                    IEndpointConfig endpointConfig = serviceConfig.getEntryEndpointConfig();
                    this.checkEndptConfigValidity(endpointConfig, ctx);
                    this.receiveMessage(endpointConfig, esbListener, ESBMessageListener.SERVICE_EXIT_MESSAGE, addr);
                    break;
                }
                case 0: {
                    ctx.setOperation("to receive message from the Endpoint ESBAddress");
                    IEndpointConfig endpointConfig = this.m_endpointApi.getEndpoint(addr.getDestinationName());
                    this.checkEndptConfigValidity(endpointConfig, ctx);
                    this.receiveMessage(endpointConfig, esbListener, ESBMessageListener.OTHER_ADDRESS, addr);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to receive Message from given ESBAddress", e, ctx);
        }
    }

    private void receiveFromExitEsbAddress(IAddress addr, ESBMessageListener esbListener, ESBMessageListener.AddressType addressType, IAddress esbAddressReplyTo) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Receive Message from given Exit ESB Address");
        ctx.setAddress(addr);
        ctx.setReplyToAddr(esbAddressReplyTo);
        try {
            switch (addr.getAddressType().getNumericType()) {
                case 0: {
                    ctx.setOperation("to receive message from endpoint ");
                    this.checkAndReceiveMessage(addr, ctx, esbListener, addressType);
                    break;
                }
                case 3: {
                    if (esbAddressReplyTo == null) {
                        throw new ESBClientUtilException("Not able to receive Message from REPLY_TO as replyto address provided is null ", ctx);
                    }
                    if (esbAddressReplyTo.getAddressType().getTypeName().equals("ENDPOINT")) {
                        ctx.setOperation("to receive message from REPLY_TO, if replyto ESBAddress is an Endpoint");
                        this.checkAndReceiveMessage(esbAddressReplyTo, ctx, esbListener, addressType);
                        break;
                    }
                    if (!esbAddressReplyTo.getAddressType().getTypeName().equals("SERVICE")) break;
                    ctx.setOperation("to receive message from REPLY_TO, if replyto ESBAddress is a Service");
                    IServiceConfig serviceConfig = this.m_serviceApi.getServiceConfig(esbAddressReplyTo.getDestinationName());
                    IEndpointConfig endpointConfig = serviceConfig.getEntryEndpointConfig();
                    this.checkEndptConfigValidity(endpointConfig, ctx);
                    this.receiveMessage(endpointConfig, esbListener, addressType, esbAddressReplyTo);
                }
            }
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to receive  Message from the Exit ESB Address", e, ctx);
        }
    }

    private void checkAndReceiveMessage(IAddress esbAddressReplyTo, ESBClientUtilContext ctx, ESBMessageListener esbListener, ESBMessageListener.AddressType addressType) {
        IEndpointConfig endpointConfig = this.m_endpointApi.getEndpoint(esbAddressReplyTo.getDestinationName());
        this.checkEndptConfigValidity(endpointConfig, ctx);
        this.receiveMessage(endpointConfig, esbListener, addressType, esbAddressReplyTo);
    }

    private void receiveMessage(IEndpointConfig endptConfig, ESBMessageListener esbListener, ESBMessageListener.AddressType addrType, IAddress addr) throws ESBClientUtilException {
        try {
            IJMSEndpointConfig jmsEndptConfig = (IJMSEndpointConfig)endptConfig.getAdapter();
            if (jmsEndptConfig == null) {
                throw new ESBClientUtilException("JMS Endpoint Configuration is null");
            }
            ESBJMSMessageAdapter listenerAdapter = new ESBJMSMessageAdapter(esbListener, addrType, addr);
            MessageConsumer messageConsumer = this.getMessageConsumer(endptConfig, jmsEndptConfig);
            this.m_msgConsumer.add(messageConsumer);
            messageConsumer.setMessageListener((MessageListener)listenerAdapter);
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to receive Message from Destination using Endpoint Configuration", e);
        }
    }

    private MessageConsumer getMessageConsumer(IEndpointConfig endptConfig, IJMSEndpointConfig jmsConfig) throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("Create MessageConsumer based on Destination type from Endpoint Configuration");
        ctx.setEndpointConfig(endptConfig);
        MessageConsumer msgConsumer = null;
        Session session = null;
        try {
            IEndpointConfig.EndpointDestinationType destType = endptConfig.getDestinationType();
            IConnectionConfig iconnConfig = this.m_endpointApi.getConnectionConfig(endptConfig.getConnection());
            IConnectionConfig.ConnectionType connType = iconnConfig.getConnectionType();
            IJMSConnectionConfig connConfig = (IJMSConnectionConfig)iconnConfig.getAdapter(connType);
            if (msgConsumer == null) {
                SessionRecord sessionRecord = this.getSessionRecord(connConfig, ctx);
                ctx.setOperation("SessionRecord exists, so get Session instance from it");
                session = sessionRecord.getSession();
                msgConsumer = this.createMsgConsumerUsingDest(destType, session, jmsConfig);
            }
            return msgConsumer;
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to create MessageConsumer instance", e, ctx);
        }
    }

    private SessionRecord getSessionRecord(IJMSConnectionConfig connConfig, ESBClientUtilContext ctx) {
        SessionRecord sessionRecord = this.createSessionRecordPopulateCache(ctx, connConfig);
        return sessionRecord;
    }

    private SessionRecord createSessionRecordPopulateCache(ESBClientUtilContext ctx, IJMSConnectionConfig connConfig) {
        ctx.setOperation("Get Session key using broker url and broker username");
        String sessionKey = this.getSessionCacheKey(connConfig.getBrokerURLs(), connConfig.getUserName());
        SessionRecord sessionRecord = (SessionRecord)this.mSessionCache.get(sessionKey);
        if (sessionRecord == null) {
            ctx.setOperation("Session Record  doesn't exist so create Session ");
            sessionRecord = this.createSessionRecord(connConfig.getBrokerURLs(), connConfig.getUserName(), connConfig.getPassword());
            if (this.m_cacheSize > 0) {
                ctx.setOperation("LRU caching for SessionRecord enabled, as cache size > 0");
                this.mSessionCache.put(sessionKey, sessionRecord);
            }
        }
        return sessionRecord;
    }

    private MessageConsumer createMsgConsumerUsingDest(IEndpointConfig.EndpointDestinationType destType, Session session, IJMSEndpointConfig jmsConfig) throws ESBClientUtilException {
        Queue destination = null;
        MessageConsumer msgConsumer = null;
        try {
            if (destType == IEndpointConfig.JMS_QUEUE) {
                destination = session.createQueue(jmsConfig.getDestinationName());
            } else if (destType == IEndpointConfig.JMS_TOPIC) {
                destination = session.createTopic(jmsConfig.getDestinationName());
            } else {
                throw new ESBClientUtilException("Unknown Destination type:" + destType);
            }
            if (destination == null) {
                throw new ESBClientUtilException("Destination is null");
            }
            msgConsumer = session.createConsumer((Destination)destination);
            if (msgConsumer == null) {
                throw new ESBClientUtilException("MessageConsumer is null");
            }
            return msgConsumer;
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Not able to create Message Consumer using Session on the Destination from Destination Type", e);
        }
    }

    @Override
    public void cleanUp() throws ESBClientUtilException {
        ESBClientUtilContext ctx = new ESBClientUtilContext("To cleanup  resources used by the API instance.");
        ctx.setOperation("To dispose api instances and clear cachemaps");
        try {
            this.mProducerCache = null;
            this.mSessionCache = null;
            this.m_serviceApi = null;
            this.m_processApi = null;
            this.m_endpointApi = null;
            this.m_msgConsumer = null;
            this.m_api.dispose();
        }
        catch (Exception e) {
            throw new ESBClientUtilException("Failed to cleanup used resources", e, ctx);
        }
    }

    class ESBJMSMessageAdapter
    implements MessageListener {
        private XQMessage xqMsg = null;
        private ESBMessageListener listener = null;
        private ESBMessageListener.AddressType addrType = null;
        private IAddress iaddress = null;

        ESBJMSMessageAdapter(ESBMessageListener listener, ESBMessageListener.AddressType messageType, IAddress addr) {
            this.listener = listener;
            this.addrType = messageType;
            this.iaddress = addr;
        }

        public void onMessage(Message msg) {
            try {
                this.xqMsg = XQJMSMessageMapper.create().translateOutput((Object)msg, null);
                boolean rmeMsg = RMEMessage.isRME((XQMessage)this.xqMsg);
                boolean faultMsg = EsbMsgTypeUtil.isFault(this.xqMsg);
                if (this.addrType.isRejected()) {
                    if (rmeMsg) {
                        this.listener.onMessage(this.xqMsg, this.addrType, this.iaddress);
                    }
                } else if (this.addrType.isFaulted()) {
                    if (faultMsg) {
                        this.listener.onMessage(this.xqMsg, this.addrType, this.iaddress);
                    }
                } else if (this.addrType.isExited() && !rmeMsg && !faultMsg) {
                    this.listener.onMessage(this.xqMsg, this.addrType, this.iaddress);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class SessionRecord {
        protected Connection connection = null;
        Session session = null;
        protected LinkedList msgProducer = new LinkedList();
        LinkedList msgConsumer = new LinkedList();

        SessionRecord() {
        }

        void setConnection(Connection conn) {
            this.connection = conn;
        }

        void setSession(Session sess) {
            this.session = sess;
        }

        void addMessageProducer(MessageProducer msgProd) {
            this.msgProducer.add(msgProd);
        }

        Connection getConnection() {
            return this.connection;
        }

        Session getSession() {
            return this.session;
        }

        LinkedList getMsgProducer() {
            return this.msgProducer;
        }
    }
}

