/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.message.impl;

import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsContext;
import com.sonicsw.esb.service.common.util.message.EsbMsgUtilsException;
import com.sonicsw.esb.service.common.util.message.XmlToXQMessage;
import com.sonicsw.esb.service.common.util.message.impl.XmlOldToXQMessageImpl;
import com.sonicsw.esbmsg.filebased.PartTypeFileRef;
import com.sonicsw.esbmsg.headerbased.JMSDestinationType;
import com.sonicsw.esbmsg.message.EsbmsgDocument;
import com.sonicsw.esbmsg.message.HeaderType;
import com.sonicsw.esbmsg.message.PartType;
import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.jms.Session;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlToXQMessageImpl
implements XmlToXQMessage {
    private Session m_session;
    private Map m_headerAdapterMap = new HashMap();
    private Map m_unProcessedhdrs = new HashMap();
    private static final String URI = "http://www.sonicsw.com/esbmsg/message";
    protected JMSHeaderAdapter defaultAdapter = new NullAdapter();

    public XmlToXQMessageImpl() {
        this.sethdrMap();
    }

    public XmlToXQMessageImpl(Session sess) {
        this.m_session = sess;
        this.sethdrMap();
    }

    private void sethdrMap() {
        this.m_headerAdapterMap.put("JMSPriority", new IntAdapter());
        this.m_headerAdapterMap.put("JMSDeliveryMode", new IntAdapter());
        this.m_headerAdapterMap.put("JMSReplyTo", new DestinationAdapter());
        this.m_headerAdapterMap.put("JMSExpiration", new LongAdapter());
        this.m_headerAdapterMap.put("JMSDestination", new DestinationAdapter());
        this.m_headerAdapterMap.put("JMSRedelivered", new BooleanAdapter());
        this.m_headerAdapterMap.put("JMSTimestamp", new LongAdapter());
    }

    @Override
    public boolean isESBMessage(Element documentElement) {
        boolean result = false;
        try {
            EsbmsgDocument esbDoc = this.getEsbmsgDocument(documentElement);
            result = esbDoc.validate();
        }
        catch (EsbMsgUtilsException e) {
            return false;
        }
        return result;
    }

    @Override
    public XQMessage createXQMessage(Element documentElement) throws EsbMsgUtilsException {
        return this.createXQMessageInternal(documentElement);
    }

    private XQMessage createXQMessageInternal(Element documentElement) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQMessage");
        ctx.setObjectType("Element");
        ctx.setOperation("Convert esbmsg xml as Element to XQMessage");
        ctx.setElement(documentElement);
        try {
            if (!this.checkNameSpaceValidity(documentElement)) {
                XmlOldToXQMessageImpl impl = new XmlOldToXQMessageImpl();
                return impl.createXQMessage(documentElement);
            }
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse((Node)documentElement);
            EsbmsgDocument.Esbmsg esb = esbDoc.getEsbmsg();
            XQMessage xqMsg = this.getEmptyXQMsg();
            return this.populateXQMessage(esb, xqMsg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as Element", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQMessage");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Convert esbsmg xml  as InputStream to XQMessage");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            Document doc = builder.parse(inputStream);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQMessageInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as InputStream", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(InputSource is) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml as InputSource to XQMessage");
        ctx.setObjectType("InputSource");
        ctx.setOperation("Convert esbsmg xml  as InputSource to XQMessage");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            Document doc = builder.parse(is);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQMessageInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as InputSource", e, ctx);
        }
    }

    @Override
    public XQMessage createXQMessage(String s) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQMessage");
        ctx.setObjectType("String");
        ctx.setOperation("Convert esbsmg xml as String to XQMessage");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            InputSource is = new InputSource(new ByteArrayInputStream(s.getBytes()));
            Document doc = builder.parse(is);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQMessageInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQMessage from esbmsg(xml) as String", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(Element documentElement) throws EsbMsgUtilsException {
        return this.createXQPartInternal(documentElement);
    }

    private XQPart createXQPartInternal(Element documentElement) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xmlpart as Element to XQPart");
        ctx.setObjectType("Element");
        ctx.setOperation("Convert esbsmg xml as Element to XQPart");
        ctx.setElement(documentElement);
        Element esbElement = null;
        try {
            if (!this.checkPartNSValidity(documentElement)) {
                XmlOldToXQMessageImpl impl = new XmlOldToXQMessageImpl();
                return impl.createXQMessagePart(documentElement);
            }
            if ("part".equals(documentElement.getLocalName())) {
                esbElement = this.getEsbmsgElem(documentElement);
            }
            EsbmsgDocument esbDoc = EsbmsgDocument.Factory.parse(esbElement);
            EsbmsgDocument.Esbmsg esb = esbDoc.getEsbmsg();
            XQMessage xqMsg = this.getEmptyXQMsg();
            return this.populateXQPart(esb, xqMsg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as Element", e, ctx);
        }
    }

    private Element getEsbmsgElem(Element documentElement) {
        Element esbMsgElem = documentElement.getOwnerDocument().createElementNS(URI, "esbmsg");
        esbMsgElem.appendChild(documentElement);
        return esbMsgElem;
    }

    private XQPart populateXQPart(EsbmsgDocument.Esbmsg esb, XQMessage xqMsg) {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Populate XQPart");
        try {
            PartType[] part = esb.getPartArray();
            XQPart xqPart = this.getNewMsgPart(xqMsg, part[0]);
            ctx.setXqpart(xqPart);
            this.setPartHeaders(xqPart, part, 0);
            if (xqPart != null) {
                return xqPart;
            }
            return null;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from Element", e, ctx);
        }
    }

    private void setPartHeaders(XQPart xqPart, PartType[] part, int i) {
        XQHeader newPartHeaders = xqPart.getHeader();
        QNameSet qns = QNameSet.forWildcardNamespaceString((String)"##any", (String)URI);
        XmlObject[] xos = part[i].selectAttributes(qns);
        for (int j = 0; j < xos.length; ++j) {
            XmlCursor xmlCursor = xos[j].newCursor();
            String headerName = xmlCursor.getName().getLocalPart();
            if ("content-type".equals(headerName) || "content-id".equals(headerName)) continue;
            String headerVal = xmlCursor.getTextValue();
            newPartHeaders.setValue(headerName, headerVal);
        }
    }

    @Override
    public XQPart createXQMessagePart(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQPart");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Convert esbmsg xml as InputStream to XQPart");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            Document doc = builder.parse(inputStream);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQPartInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as InputStream", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(InputSource is) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQPart");
        ctx.setObjectType("InputSource");
        ctx.setOperation("Convert esbsmg xml as InputSource to XQPart");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            Document doc = builder.parse(is);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQPartInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as InputSource", e, ctx);
        }
    }

    @Override
    public XQPart createXQMessagePart(String s) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Convert xml to XQPart");
        ctx.setObjectType("String");
        ctx.setOperation("Convert esbsmg xml as String to XQPart");
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            InputSource is = new InputSource(new ByteArrayInputStream(s.getBytes()));
            Document doc = builder.parse(is);
            ctx.setElement(doc.getDocumentElement());
            return this.createXQPartInternal(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to create XQPart from esbmsg(xml) as String", e, ctx);
        }
    }

    private XQMessage getEmptyXQMsg() {
        XQMessageFactoryImpl xqFactImpl = new XQMessageFactoryImpl();
        XQMessage msg = xqFactImpl.createMessage();
        return msg;
    }

    private EsbmsgDocument getEsbmsgDocument(Element element) throws EsbMsgUtilsException {
        try {
            EsbmsgDocument esbDocument = EsbmsgDocument.Factory.newInstance();
            esbDocument = EsbmsgDocument.Factory.parse((Node)element);
            return esbDocument;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("The Element cannot be parsed and cannot return an EsbmsgDocument", e);
        }
    }

    private boolean checkNameSpaceValidity(Element root) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Validate XQMessage Namespace");
        ctx.setObjectType("Namespace");
        ctx.setOperation("Implementation based on relevant message namespace");
        return this.populateNameSpaceCheckUri(root, ctx);
    }

    private boolean checkPartNSValidity(Element root) {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Validate XQPart Namespace");
        ctx.setObjectType("Namespace");
        ctx.setOperation("Implementation based on relevant part namespace");
        return this.populateNameSpaceCheckUri(root, ctx);
    }

    private boolean populateNameSpaceCheckUri(Element root, EsbMsgUtilsContext ctx) {
        boolean value = false;
        try {
            String namespace = root.getNamespaceURI();
            ctx.setNamespace(namespace);
            if (namespace.equals(URI)) {
                value = true;
            }
            return value;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get NameSpace from Element", e, ctx);
        }
    }

    private static boolean isTextContent(String contentType) {
        try {
            MimeType mimeType = new MimeType(contentType);
            String type = mimeType.getPrimaryType();
            return "text".equals(type);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Charset getCharset(String contentType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get charset from content-type");
        ctx.setObjectType("contentType");
        ctx.setOperation("Get charset from content type else use the platform default charset");
        try {
            MimeType mimeType = new MimeType(contentType);
            String charset = mimeType.getParameter("charset");
            if (charset != null) {
                return Charset.forName(charset);
            }
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get charset", e, ctx);
        }
        return Charset.forName(System.getProperty("file.encoding"));
    }

    private static String getTextContent(InputStream inputStream, String contentType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To get Text content from the file reference");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get Text content based on the charset received from content-type");
        try {
            InputStreamReader r = new InputStreamReader(inputStream, XmlToXQMessageImpl.getCharset(contentType));
            BufferedReader br = new BufferedReader(r);
            StringBuffer buf = new StringBuffer();
            char[] cbuf = new char[4096];
            int i = 0;
            while ((i = br.read(cbuf, 0, cbuf.length)) != -1) {
                buf.append(cbuf, 0, i);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get Text content from file reference", e, ctx);
        }
    }

    private static byte[] getBinaryContent(InputStream inputStream) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To get Binary content from the file reference");
        ctx.setObjectType("InputStream");
        ctx.setOperation("Get Binary content based on the charset received from content-type");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int read = 0;
            byte[] buf = new byte[4096];
            while ((read = inputStream.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get Binary content from file reference", e, ctx);
        }
    }

    private XQMessage setHeaders(EsbmsgDocument.Esbmsg esb, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Set xml message headers in  XQMessage");
        ctx.setObjectType("HeaderType");
        ctx.setOperation("Set header name and value in XQMessage");
        HeaderType[] headerTypes = esb.getHeaderArray();
        int hdrCount = headerTypes.length;
        String hdrName = null;
        try {
            for (int i = 0; i < hdrCount; ++i) {
                Object jmsDestHeaderValue = null;
                hdrName = headerTypes[i].getName();
                try {
                    JMSHeaderAdapter adapterHdr = (JMSHeaderAdapter)this.m_headerAdapterMap.get(hdrName);
                    if (adapterHdr == null) {
                        adapterHdr = this.defaultAdapter;
                    }
                    jmsDestHeaderValue = adapterHdr.getJMSValue(headerTypes[i]);
                    this.useMap(msg, hdrName, jmsDestHeaderValue);
                    continue;
                }
                catch (Exception e) {
                    this.useMap(msg, hdrName, jmsDestHeaderValue);
                }
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set message headers", e, ctx);
        }
        return msg;
    }

    private void useMap(XQMessage msg, String hdrName, Object jmsDestHeaderValue) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Non settable XQMessage Headers is put in a Map");
        ctx.setObjectType("HeaderType");
        ctx.setHeaderName(hdrName);
        ctx.setHeaderValue(jmsDestHeaderValue);
        try {
            if (!this.setHeadersTest(msg, hdrName, jmsDestHeaderValue)) {
                this.putHdrsinMap(hdrName, jmsDestHeaderValue);
            }
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to put, nonsettable XQMessage Headers in a Map , ", e, ctx);
        }
    }

    private boolean setHeadersTest(XQMessage msg, String hdrName, Object jmsHdrVal) {
        boolean boolVal = false;
        if (jmsHdrVal != null) {
            try {
                msg.setHeaderValue(hdrName, jmsHdrVal);
                Object value = msg.getHeaderValue(hdrName);
                if (value != null) {
                    boolVal = jmsHdrVal.equals(value);
                }
            }
            catch (Exception e) {
                return boolVal;
            }
        }
        return boolVal;
    }

    private void putHdrsinMap(String hdrName, Object jmsHdr) {
        this.m_unProcessedhdrs.put(hdrName, jmsHdr);
    }

    @Override
    public Map getUnprocessedHdrs() {
        return this.m_unProcessedhdrs;
    }

    private XQMessage setParts(EsbmsgDocument.Esbmsg esbmsg, XQMessage msg) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("To set (esbmsg)xml message parts in XQPart");
        ctx.setObjectType("PartType");
        ctx.setOperation("Set XQPart in XQMessage");
        PartType[] parts = esbmsg.getPartArray();
        int partCount = parts.length;
        try {
            for (int i = 0; i < partCount; ++i) {
                XQPart newPart = this.getNewMsgPart(msg, parts[i]);
                this.setPartHeaders(newPart, parts, i);
                msg.addPart(newPart);
            }
            ctx.setXqmessage(msg);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to set message parts", e, ctx);
        }
        return msg;
    }

    private XQPart getNewMsgPart(XQMessage msg, PartType partType) throws EsbMsgUtilsException {
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get file type message part");
        ctx.setObjectType("PartType");
        ctx.setOperation("Get file reference or part content as Text/Binary ");
        try {
            String contentId = partType.getContentId();
            String contentType = partType.getContentType();
            String fileRef = null;
            Object partContents = null;
            if (partType instanceof PartTypeFileRef) {
                fileRef = ((PartTypeFileRef)partType).getFileRef();
            }
            if (fileRef != null && !"".equals(fileRef.trim())) {
                partContents = this.getFileContents(fileRef, contentType);
            } else {
                Node node = partType.getDomNode();
                Node childNode = node.getFirstChild();
                if (childNode instanceof Text) {
                    partContents = childNode.getNodeValue();
                } else if (childNode instanceof Element) {
                    partContents = DOMUtils.serializeChildNodes((Element)((Element)childNode.getParentNode()));
                }
            }
            if (partContents == null) {
                partContents = XmlToXQMessageImpl.isTextContent(contentType) ? new String("") : (Object)new byte[0];
            }
            XQPart newPart = msg.createPart(partContents, contentType);
            newPart.setContentId(contentId);
            return newPart;
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get part content", e, ctx);
        }
    }

    private Object getFileContents(String fileRef, String contentType) throws EsbMsgUtilsException {
        byte[] byArray;
        EsbMsgUtilsContext ctx = new EsbMsgUtilsContext("Get file reference, part contents ");
        ctx.setObjectType("file-Ref");
        ctx.setOperation(" Get file contents as text or binary");
        InputStream inputStream = null;
        try {
            URL url = new URL(fileRef);
            inputStream = url.openStream();
            if (XmlToXQMessageImpl.isTextContent(contentType)) {
                String string = XmlToXQMessageImpl.getTextContent(inputStream, contentType);
                return string;
            }
            byArray = XmlToXQMessageImpl.getBinaryContent(inputStream);
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to get part, file content", e, ctx);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return byArray;
    }

    private XQMessage populateXQMessage(EsbmsgDocument.Esbmsg esb, XQMessage msg) throws EsbMsgUtilsException {
        try {
            this.m_unProcessedhdrs.clear();
            return this.setParts(esb, this.setHeaders(esb, msg));
        }
        catch (Exception e) {
            throw new EsbMsgUtilsException("Not able to populate XQMessage with headers and parts", e);
        }
    }

    class DestinationAdapter
    implements JMSHeaderAdapter {
        DestinationAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) throws Exception {
            String value = headerType.getValue();
            String destType = headerType.getDestType();
            Session jmsSession = XmlToXQMessageImpl.this.m_session;
            if (jmsSession != null) {
                if (destType == null) {
                    throw new EsbMsgUtilsException("Unknown Destination Type: " + value);
                }
                if (destType.equals(JMSDestinationType.TOPIC.toString())) {
                    value = jmsSession.createTopic(value);
                } else if (destType.equals(JMSDestinationType.QUEUE.toString())) {
                    value = jmsSession.createQueue(value);
                }
            }
            return value;
        }
    }

    static class BooleanAdapter
    implements JMSHeaderAdapter {
        BooleanAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Boolean(Boolean.getBoolean(headerType.getValue()));
        }
    }

    static class IntAdapter
    implements JMSHeaderAdapter {
        IntAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Integer(Integer.parseInt(headerType.getValue()));
        }
    }

    static class LongAdapter
    implements JMSHeaderAdapter {
        LongAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return new Long(Long.parseLong(headerType.getValue()));
        }
    }

    static class NullAdapter
    implements JMSHeaderAdapter {
        NullAdapter() {
        }

        @Override
        public Object getJMSValue(HeaderType headerType) {
            return headerType.getValue();
        }
    }

    static interface JMSHeaderAdapter {
        public Object getJMSValue(HeaderType var1) throws Exception;
    }
}

