/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.ContextAwareVariableResolverFactory;
import com.sonicsw.esb.service.common.impl.SFCParametersImpl;
import com.sonicsw.esb.service.common.impl.SFCServiceContextFactory;
import com.sonicsw.esb.service.common.impl.SFCServiceContextImpl;
import com.sonicsw.esb.service.common.impl.ScopedParameters;
import com.sonicsw.esb.service.common.util.variables.VariableParserImpl;
import com.sonicsw.esb.service.common.util.variables.VariableResolverFactory;
import com.sonicsw.xq.XQServiceContext;

class SFCServiceContextFactoryImpl
implements SFCServiceContextFactory {
    private final SFCInitializationContext initContext;
    private final VariableResolverFactory variableResolverFactory;

    public SFCServiceContextFactoryImpl(SFCInitializationContext initContext, VariableResolverFactory variableResolverFactory) {
        this.initContext = initContext;
        this.variableResolverFactory = variableResolverFactory;
    }

    @Override
    public SFCServiceContext createServiceContext(XQServiceContext xqServiceContext) {
        VariableParserImpl parser = new VariableParserImpl();
        ScopedParameters params = new ScopedParameters(this.initContext.getParameters(), parser);
        params.setName("service");
        params.push(new SFCParametersImpl(xqServiceContext.getParameters()));
        ContextAwareVariableResolverFactory factory = new ContextAwareVariableResolverFactory(this.variableResolverFactory);
        parser.setVariableResolverFactory(factory);
        SFCServiceContextImpl newContext = new SFCServiceContextImpl(this.initContext, params, parser, factory);
        newContext.setXQServiceContext(xqServiceContext);
        factory.setContext(newContext);
        return newContext;
    }
}

