/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.spring;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class PatternBasedBeanDefinitionProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private ApplicationContext context;
    private String pattern;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.context;
        try {
            Resource[] resources = this.context.getResources(this.pattern);
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader(registry);
            if (resources != null) {
                for (int i = 0; i < resources.length; ++i) {
                    Resource resrc = resources[i];
                    if (!resrc.exists()) continue;
                    xmlReader.loadBeanDefinitions(resrc);
                }
            }
        }
        catch (IOException excp) {
            throw new FatalBeanException("Failed to read resources: " + this.pattern, (Throwable)excp);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

