/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.ramps.AbstractSyncRamp;
import com.sonicsw.esb.service.common.ramps.ICompositeConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IDataSource;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.esb.service.common.ramps.MappingException;
import com.sonicsw.esb.service.common.ramps.TimeoutException;
import com.sonicsw.esb.service.common.ramps.impl.ExitToServiceException;
import com.sonicsw.esb.service.common.ramps.impl.OnRampParameter;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;

public final class SyncOnRamp
extends AbstractSyncRamp {
    public static final String HEADER_TIMEOUT = "SonicESB.SyncOnRamp.Timeout";
    public static final String HEADER_TIMEOUT_OCCURRED = "occurred";
    private IDataSource dataSource_;
    private final OnRampParameter onRampParams_ = new OnRampParameter(1);

    public SyncOnRamp(IDataSource _source, String _serviceGroupName) {
        this(_serviceGroupName);
        this.setDataSource(_source);
    }

    public SyncOnRamp(String _serviceGroupName) {
        super(_serviceGroupName);
    }

    public void setDataSource(IDataSource _dataSource) {
        this.dataSource_ = _dataSource;
        this.getErrorHandler().setFaultInfoProvider(this.dataSource_);
        this.getErrorHandler().setConnectionFactory(this.dataSource_);
    }

    public void init(SFCInitializationContext _ctx) throws XQServiceException {
        this.internalInit(_ctx);
        this.onRampParams_.init(_ctx.getParameters());
        Utils.delegateCall(this.dataSource_, "init", new Class[]{SFCInitializationContext.class}, new Object[]{_ctx});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SFCServiceContext _ctx, XQEnvelope _envelope) throws XQMessageException, XQServiceException {
        this.validateCurrentState(_envelope);
        XQMessage msg = _envelope.getMessage();
        boolean isRetry = SyncOnRamp.getInitialRetryValue(msg);
        this.stopRequested_ = false;
        boolean success = false;
        boolean blockForCompletion = this.getErrorHandler().getBlockForCompletion();
        if (blockForCompletion) {
            this.addToBlocking();
        }
        try {
            do {
                IConnectionContext connection = this.getErrorHandler().createConnection(this.dataSource_, _ctx, msg);
                try {
                    do {
                        this.getErrorHandler().openConnection(connection, _ctx, msg);
                        try {
                            XQMessage retainedMessage = this.handleMessageRetaining(msg);
                            IConnectionContext underlying = connection;
                            if (connection instanceof ICompositeConnectionContext) {
                                underlying = ((ICompositeConnectionContext)((Object)connection)).getUnderlying();
                            }
                            do {
                                try {
                                    this.produceOutboxCleanup(_ctx, isRetry, underlying, retainedMessage);
                                    success = true;
                                }
                                catch (XQServiceException e) {
                                    this.getErrorHandler().handleException(_ctx, msg, connection, e);
                                }
                                finally {
                                    isRetry = true;
                                }
                            } while (!success && !this.stopRequested_);
                        }
                        catch (InvalidConnectionException e) {
                            this.getErrorHandler().handleInvalidConnectionException(e);
                        }
                        finally {
                            connection.deactivate(success);
                        }
                    } while (!success && !this.stopRequested_);
                }
                catch (InvalidConnectionException e) {
                    this.getErrorHandler().handleInvalidConnectionException(e);
                }
                finally {
                    this.dataSource_.destroyConnection(connection, success);
                }
            } while (!success && !this.stopRequested_);
            if (this.stopRequested_ && !success) {
                this.getErrorHandler().failureModeAbort_Service(_ctx, msg, null, null);
            }
        }
        catch (ExitToServiceException exitToServiceException) {
        }
        finally {
            if (blockForCompletion) {
                this.removeFromBlocking();
            }
        }
    }

    private void validateCurrentState(XQEnvelope _envelope) {
        if (null == this.dataSource_) {
            throw new IllegalStateException("No data source is set.");
        }
        if (null == this.dataSource_.getMessageMapper()) {
            throw new IllegalStateException("The data source has no mapper set.");
        }
        if (!_envelope.getAddresses().hasNext()) {
            throw new IllegalStateException("The there is no next step. Unable to produce any messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceOutboxCleanup(SFCServiceContext _ctx, boolean _isRetry, IConnectionContext _connection, XQMessage _retainedMessage) throws XQServiceException, XQMessageException, InvalidConnectionException {
        block8: {
            try {
                Object[] rawMessages = this.dataSource_.produce(_connection, this.onRampParams_.getMaxMessages(), this.onRampParams_.getTimeout(), _isRetry);
                try {
                    try {
                        XQMessage[] messagesToSend = this.dataSource_.getMessageMapper().mapForOnramp(rawMessages, _connection, _ctx, _retainedMessage, this.onRampParams_.getMaxMessages());
                        if (null != messagesToSend && messagesToSend.length > 0) {
                            this.onRampParams_.validateMessageCount(messagesToSend);
                            this.addAllToOutbox(_ctx, messagesToSend);
                            break block8;
                        }
                        throw new TimeoutException("Timeout occurred due to no messages being produced");
                    }
                    catch (MappingException e) {
                        throw new XQMessageException((Throwable)e);
                    }
                }
                finally {
                    this.dataSource_.getMessageMapper().cleanup(_connection, rawMessages);
                }
            }
            catch (TimeoutException e) {
                _retainedMessage.setHeaderValue(HEADER_TIMEOUT, (Object)HEADER_TIMEOUT_OCCURRED);
                this.onRampParams_.handleTimeout(e);
                this.noDataAvailable(_ctx, _retainedMessage);
            }
        }
    }

    private void noDataAvailable(SFCServiceContext _ctx, XQMessage _retainedMessage) {
        _ctx.addOutgoing(_retainedMessage);
    }

    private void addAllToOutbox(SFCServiceContext _ctx, XQMessage[] _messagesToSend) throws MappingException {
        for (int i = 0; i < _messagesToSend.length; ++i) {
            XQMessage message = _messagesToSend[i];
            if (null == message) {
                throw new MappingException("Encountered a null entry in the mapped messages");
            }
            _ctx.addOutgoing(message);
        }
    }
}

