// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The {@linkplain Operation} annotation specifies the operation of {@linkplain SonicPOJO} ESB Service.
 * Indicates that the annotated method can be called from an itinerary. Method input parameters are provisioned
 * by itinerary input mapping. Method output is returned by itinerary output mapping.
 * <p>
 * Annotation attributes aid UI rendering, interface assist fly-overs, validation, and reflect expected content-type,
 * and xsd types(simple types) for parameters.
 * <p>
 * Each {@linkplain SonicPOJO} ESB Service must have at least one operation method.
 * <p>
 * A single output parameter may be returned. One or more input parameters are permitted. The type of each parameter must be one of:
 * <ul>
 * <li>a Java primitive type</li>
 * <li>an array of a Java primitive type.</li>
 * </ul>
 * 
 * For more complex data binding, Sonic Connect JAXRS services may be used.
 *
 * @since 10.0.7
 */
@Documented
@Inherited
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.CLASS)
public @interface Operation {

    /**
     * Operation description
     * @return description of operation
     */
    String description() default "";

    /**
     * Operation output MIME content-type that itinerary should expect(default text/plain). Under most cases, 
     * "text/plain" applies.
     * @return content type of operation
     *
     */
    String contentType() default "text/plain";

    /**
     * Indicates the operation output type to the itinerary developer, using xml(xsd) familiar types. 
     * So, Java output parameter types are
     * expressed in  their corresponding xsd type.
     * @return output type of operation, xsd simple types
     */
    String outputType() default "";

    /**
     * Operation output name(default: output)
     * @return output name of operation, mapping will use this for defaulting part names to produce. 
     *
     */
    String outputName() default "output";


}