// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The {@linkplain Parameter} annotation specifies the parameter of an {@linkplain Operation}. For each method that is annotated as
 * {@linkplain Operation}; all input parameters are implictly Parameters. This annotation be used to
 * revise default settings.
 *
 * @since 10.0.7
 */
@Documented
@Inherited
@Target(ElementType.PARAMETER)
@Retention(RetentionPolicy.CLASS)
public @interface Parameter {

    /**
     * Input parameter MIME content-type(default text/plain). Under most cases, 
     * "text/plain" applies.
     * @return content type of parameter
     *
     */
    String contentType() default "text/plain";

    /**
     * Indicates the parameter type to the itinerary developer, using xml(xsd) familiar types. 
     * So, Java output parameter types are
     * expressed in  their corresponding xsd type.
     * @return input type of operation, xsd simple types
     */
    String inputType() default "";
}
