/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.processor.model.AttributeModel;
import com.aurea.sonic.esb.pojo.processor.model.OperationModel;
import com.aurea.sonic.esb.pojo.processor.model.ParameterModel;
import com.aurea.sonic.esb.pojo.processor.model.ServiceModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class ESBServiceGenerator {
    private final Filer filer;
    private final Messager messager;
    private final String projectName;
    private static final String SONIC_PACKAGE = "sonicesb.services";
    private static final StandardLocation SONIC_LOCATION = StandardLocation.SOURCE_OUTPUT;

    public ESBServiceGenerator(ProcessorContext context) {
        this.filer = context.getFiler();
        this.messager = context.getMessager();
        this.projectName = this.getProjectName();
    }

    public void generateService(ServiceModel service) {
        try {
            Document esbTypeXml = this.createEsbtypXml(service);
            this.writeSonicXml(service.getName() + ".esbstyp", esbTypeXml);
            Properties esbTypeProperties = this.createEsbTypeProperties(service);
            this.writeSonicProperties(service.getName() + ".properties", esbTypeProperties);
            Document esbTypeInterfaceXml = this.createEsbtypInterfaceXml(service);
            this.writeSonicXml(service.getName() + "Interface.xml", esbTypeInterfaceXml);
            this.copyServiceIconFile(service);
        }
        catch (Exception ex) {
            this.addError(service.getType(), "Error while generating " + service.getName() + " service resources: " + ex.getMessage(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyServiceIconFile(ServiceModel service) {
        String Icon = service.getName() + ".gif";
        try {
            FileObject inputFile = this.filer.getResource(StandardLocation.SOURCE_PATH, "", Icon);
            FileObject outputFile = this.filer.createResource(SONIC_LOCATION, SONIC_PACKAGE, Icon, new Element[0]);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int length;
                inputStream = inputFile.openInputStream();
                outputStream = outputFile.openOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        this.addError(service.getType(), e.getMessage(), new Object[0]);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        this.addError(service.getType(), e.getMessage(), new Object[0]);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "There is no Service Icon File");
        }
        catch (IOException ex) {
            this.addError(service.getType(), "Error while copying Service Icon " + service.getName() + " service resources: " + ex.getMessage(), new Object[0]);
        }
    }

    private void addError(Element element, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.messager.printMessage(Diagnostic.Kind.ERROR, formattedMessage, element);
    }

    private Document createEsbtypXml(ServiceModel service) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.newDocument();
        org.w3c.dom.Element serviceType = doc.createElement("serviceType");
        serviceType.setAttribute("name", service.getName());
        serviceType.setAttribute("factoryClass", "com.sonicsw.xq.service.executor.POJOExecutor");
        serviceType.setAttribute("xmlns", "http://www.sonicsw.com/sonicxq");
        serviceType.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serviceType.setAttribute("xsi:schemaLocation", "http://www.sonicsw.com/sonicxq file:///C:/Sonic/ESB2015/schema/serviceType.xsd");
        doc.appendChild(serviceType);
        org.w3c.dom.Element validParams = doc.createElement("validParams");
        serviceType.appendChild(validParams);
        org.w3c.dom.Element init = doc.createElement("init");
        validParams.appendChild(init);
        for (AttributeModel attribute : service.getAttributes()) {
            org.w3c.dom.Element initParam = doc.createElement("stringParam");
            initParam.setAttribute("name", attribute.getName());
            initParam.setAttribute("required", Boolean.toString(attribute.isRequired()));
            init.appendChild(initParam);
            org.w3c.dom.Element defaultValue = doc.createElement("default");
            defaultValue.setAttribute("edittable", "true");
            defaultValue.setAttribute("editAsRef", "false");
            defaultValue.setTextContent(attribute.getDefaultValue());
            initParam.appendChild(defaultValue);
        }
        org.w3c.dom.Element initParamDelegate = doc.createElement("stringParam");
        initParamDelegate.setAttribute("name", "com.sonicsw.xq.service.executor.POJOExecutor.delegate");
        initParamDelegate.setAttribute("required", "false");
        init.appendChild(initParamDelegate);
        org.w3c.dom.Element defaultValueDelegate = doc.createElement("default");
        defaultValueDelegate.setAttribute("edittable", "true");
        defaultValueDelegate.setAttribute("editAsRef", "false");
        defaultValueDelegate.setTextContent(service.getClassName());
        initParamDelegate.appendChild(defaultValueDelegate);
        org.w3c.dom.Element runtime = doc.createElement("runtime");
        validParams.appendChild(runtime);
        org.w3c.dom.Element operationId = doc.createElement("stringParam");
        operationId.setAttribute("name", "operationId");
        runtime.appendChild(operationId);
        org.w3c.dom.Element classLoading = doc.createElement("classLoading");
        serviceType.appendChild(classLoading);
        org.w3c.dom.Element serviceTypeCL = doc.createElement("serviceType");
        classLoading.appendChild(serviceTypeCL);
        org.w3c.dom.Element clList = doc.createElement("classpath_list");
        serviceTypeCL.appendChild(clList);
        org.w3c.dom.Element clWorkspace = doc.createElement("classpath");
        clWorkspace.setTextContent("sonicfs:///workspace/" + this.projectName + "/lib/custom-services-classes.jar");
        clList.appendChild(clWorkspace);
        return doc;
    }

    private final String getProjectName() {
        try {
            FileObject resource = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", ".tmp", new Element[0]);
            Path projectPath = Paths.get(resource.toUri()).getParent().getParent();
            if ("target".equals(projectPath.getFileName().toString())) {
                projectPath = projectPath.getParent();
            }
            return projectPath.getFileName().toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Properties createEsbTypeProperties(ServiceModel service) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("type.name", service.getName());
        properties.setProperty("type.displayName", service.getDisplayName());
        properties.setProperty("type.shortDesc", service.getDescription());
        properties.setProperty("type.defaultInstance", service.getInstanceName());
        properties.setProperty("type.isDecision", "false");
        properties.setProperty("type.mappingMode", "1");
        String initParamNames = "";
        for (AttributeModel attribute : service.getAttributes()) {
            properties.setProperty("initParam." + attribute.getName() + ".name", attribute.getName());
            properties.setProperty("initParam." + attribute.getName() + ".displayName", attribute.getDisplayName());
            properties.setProperty("initParam." + attribute.getName() + ".shortDesc", attribute.getDescription());
            if (attribute.isPassword()) {
                properties.setProperty("initParam." + attribute.getName() + ".type", "password");
            } else {
                properties.setProperty("initParam." + attribute.getName() + ".type", "string");
            }
            properties.setProperty("initParam." + attribute.getName() + ".required", Boolean.toString(attribute.isRequired()));
            properties.setProperty("initParam." + attribute.getName() + ".hidden", Boolean.toString(attribute.isHidden()));
            properties.setProperty("initParam." + attribute.getName() + ".readOnly", Boolean.toString(attribute.isReadOnly()));
            properties.setProperty("initParam." + attribute.getName() + ".enableSubstitution", Boolean.toString(attribute.isEnableSubstitution()));
            properties.setProperty("initParam." + attribute.getName() + ".defaultValue", attribute.getDefaultValue());
            initParamNames = initParamNames + attribute.getName() + ",";
        }
        String delegateInitParam = "com.sonicsw.xq.service.executor.POJOExecutor.delegate";
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.name", "com.sonicsw.xq.service.executor.POJOExecutor.delegate");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.displayName", "POJOExecutor.delegate");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.shortDesc", "src/main/sonicesb/services");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.type", "string");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.required", "false");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.hidden", "true");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.readOnly", "false");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.enableSubstitution", "false");
        properties.setProperty("initParam.com.sonicsw.xq.service.executor.POJOExecutor.delegate.defaultValue", service.getClassName());
        initParamNames = initParamNames + "com.sonicsw.xq.service.executor.POJOExecutor.delegate";
        properties.setProperty("type.initParamNames", initParamNames);
        String operationRuntimeParam = "operationId";
        properties.setProperty("runtimeParam.operationId.name", "operationId");
        properties.setProperty("runtimeParam.operationId.displayName", "operationId");
        properties.setProperty("runtimeParam.operationId.shortDesc", "");
        properties.setProperty("runtimeParam.operationId.type", "operationIdentifier");
        properties.setProperty("runtimeParam.operationId.required", "true");
        properties.setProperty("runtimeParam.operationId.hidden", "false");
        properties.setProperty("runtimeParam.operationId.readOnly", "false");
        properties.setProperty("runtimeParam.operationId.enableSubstitution", "false");
        properties.setProperty("runtimeParam.operationId.defaultValue", "");
        properties.setProperty("type.runtimeParamNames", "operationId");
        return properties;
    }

    private Document createEsbtypInterfaceXml(ServiceModel service) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.newDocument();
        org.w3c.dom.Element serviceInterface = doc.createElement("interface");
        serviceInterface.setAttribute("name", service.getName());
        serviceInterface.setAttribute("xmlns", "http://www.sonicsw.com/sonicxq");
        doc.appendChild(serviceInterface);
        org.w3c.dom.Element interfaceDocumentation = doc.createElement("documentation");
        interfaceDocumentation.setTextContent(service.getDescription());
        serviceInterface.appendChild(interfaceDocumentation);
        for (OperationModel operation : service.getOperations()) {
            org.w3c.dom.Element operationTag = doc.createElement("operation");
            operationTag.setAttribute("name", operation.getName());
            serviceInterface.appendChild(operationTag);
            org.w3c.dom.Element operationDocumentation = doc.createElement("documentation");
            operationDocumentation.setTextContent(operation.getDescription());
            operationTag.appendChild(operationDocumentation);
            org.w3c.dom.Element input = doc.createElement("input");
            input.setAttribute("name", "Input");
            operationTag.appendChild(input);
            for (ParameterModel parameter : operation.getParameters()) {
                org.w3c.dom.Element inputParameter = doc.createElement("parameter");
                inputParameter.setAttribute("name", parameter.getName());
                inputParameter.setAttribute("type", parameter.getInputType());
                inputParameter.setAttribute("contentType", parameter.getContentType());
                inputParameter.setAttribute("collection", Boolean.toString(parameter.isCollection()));
                inputParameter.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
                input.appendChild(inputParameter);
            }
            org.w3c.dom.Element output = doc.createElement("output");
            output.setAttribute("name", "Output");
            operationTag.appendChild(output);
            org.w3c.dom.Element outputParameter = doc.createElement("parameter");
            outputParameter.setAttribute("name", operation.getOutputName());
            outputParameter.setAttribute("type", operation.getOutputType());
            outputParameter.setAttribute("contentType", operation.getContentType());
            outputParameter.setAttribute("collection", Boolean.toString(operation.isCollection()));
            outputParameter.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            output.appendChild(outputParameter);
        }
        return doc;
    }

    private void writeXmlDocument(Document xml, Writer out) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        tf.transform(new DOMSource(xml), new StreamResult(out));
    }

    private void writeProperties(Properties properties, Writer out) throws Exception {
        Properties sortedProperties = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        sortedProperties.putAll((Map<?, ?>)properties);
        sortedProperties.store(out, null);
    }

    private void writeSonicXml(String name, Document xml) throws Exception {
        FileObject resource = this.filer.createResource(SONIC_LOCATION, SONIC_PACKAGE, name, new Element[0]);
        try (Writer out = resource.openWriter();){
            this.writeXmlDocument(xml, out);
        }
    }

    private void writeSonicProperties(String name, Properties properties) throws Exception {
        FileObject resource = this.filer.createResource(SONIC_LOCATION, SONIC_PACKAGE, name, new Element[0]);
        try (Writer out = resource.openWriter();){
            this.writeProperties(properties, out);
        }
    }
}

