/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.InitParameter;
import com.aurea.sonic.esb.pojo.annotation.Operation;
import com.aurea.sonic.esb.pojo.annotation.SonicPOJO;
import com.aurea.sonic.esb.pojo.processor.ESBServiceGenerator;
import com.aurea.sonic.esb.pojo.processor.ESBServiceValidator;
import com.aurea.sonic.esb.pojo.processor.model.AttributeModel;
import com.aurea.sonic.esb.pojo.processor.model.OperationModel;
import com.aurea.sonic.esb.pojo.processor.model.ServiceModel;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class AnnotationProcessor
extends AbstractProcessor {
    private ProcessorContext context;
    private ESBServiceGenerator generator;
    private ESBServiceValidator validator;
    private Map<Element, ServiceModel> services;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context = new ProcessorContext(processingEnv);
        this.generator = new ESBServiceGenerator(this.context);
        this.validator = new ESBServiceValidator(this.context);
        this.services = new LinkedHashMap<Element, ServiceModel>();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(SonicPOJO.class.getCanonicalName());
        annotations.add(Operation.class.getCanonicalName());
        annotations.add(InitParameter.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(SonicPOJO.class)) {
            ServiceModel service = new ServiceModel(this.context, element);
            this.services.put(service.getType(), service);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Operation.class)) {
            OperationModel operation = new OperationModel(this.context, element);
            ServiceModel serviceType = this.getEnclosedServiceType(element);
            if (serviceType == null) continue;
            serviceType.addOperation(operation);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(InitParameter.class)) {
            AttributeModel attribute = new AttributeModel(this.context, element);
            ServiceModel service = this.getEnclosedServiceType(element);
            if (service == null) continue;
            service.addAttribute(attribute);
        }
        if (roundEnv.processingOver()) {
            for (ServiceModel serviceModel : this.services.values()) {
                if (!this.validator.validateService(serviceModel)) continue;
                this.generator.generateService(serviceModel);
            }
            this.services.clear();
        }
        return true;
    }

    private ServiceModel getEnclosedServiceType(Element element) {
        Element operationClass = element.getEnclosingElement();
        return this.services.get(operationClass);
    }
}

