// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.processor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.SonicPOJO;

/**
 * <!-- ========================================================================================================== -->
 * Data model of {@linkplain SonicPOJO} service
 * <!-- --------------------------------------------------------------------------------------------------------- -->
 */
public class ServiceModel {

    private final Element type;

    private String name;

    private String displayName;

    private String instanceName;

    private String description;

    private final List<OperationModel> operations = new ArrayList<>();

    private final List<AttributeModel> attributes = new ArrayList<>();

    private final String className;

    public ServiceModel(final ProcessorContext context, final Element element) {
        this.type = element;

        final SonicPOJO serviceAnnotation = element.getAnnotation(SonicPOJO.class);
        this.name = "".equals(serviceAnnotation.name()) ? element.getSimpleName().toString() : serviceAnnotation.name();
        this.displayName = "".equals(serviceAnnotation.displayName()) ? this.name : serviceAnnotation.displayName();
        this.instanceName = "".equals(serviceAnnotation.instanceName()) ? this.name + "Instance" : serviceAnnotation
                .instanceName();
        this.description = serviceAnnotation.description();

        final TypeElement classElement = (TypeElement) element;
        this.className = classElement.getQualifiedName().toString();
    }

    public Element getType() {
        return type;
    }

    public List<OperationModel> getOperations() {
        return Collections.unmodifiableList(operations);
    }

    public List<AttributeModel> getAttributes() {
        return Collections.unmodifiableList(attributes);
    }

    public void addOperation(final OperationModel operation) {
        this.operations.add(operation);
    }

    public void addAttribute(final AttributeModel attribute) {
        this.attributes.add(attribute);
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(final String displayName) {
        this.displayName = displayName;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(final String instanceName) {
        this.instanceName = instanceName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public String getClassName() {
        return className;
    }

    @Override
    public String toString() {
        return "ServiceType [type=" + type + ", name=" + name + ", displayName=" + displayName + ", instanceName="
                + instanceName + ", description=" + description + ", operations=" + operations + ", attributes="
                + attributes + ", className=" + className + "]";
    }

}
