/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.processor.model.AttributeModel;
import com.aurea.sonic.esb.pojo.processor.model.OperationModel;
import com.aurea.sonic.esb.pojo.processor.model.ServiceModel;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class ESBServiceValidator {
    private final Messager messager;

    public ESBServiceValidator(ProcessorContext context) {
        this.messager = context.getMessager();
    }

    public boolean validateService(ServiceModel service) {
        boolean hasError = false;
        if (service.getOperations().isEmpty()) {
            this.addError(service.getType(), service.getName() + " service must have operations", new Object[0]);
            hasError = true;
        }
        for (AttributeModel attribute : service.getAttributes()) {
            if (this.validateAttribute(attribute)) continue;
            hasError = true;
        }
        for (OperationModel operation : service.getOperations()) {
            if (this.validateOperation(operation)) continue;
            hasError = true;
        }
        return !hasError;
    }

    private boolean validateAttribute(AttributeModel attribute) {
        if (!this.hasAttributeSetter(attribute)) {
            this.addError(attribute.getType(), attribute.getName() + " attribute must implement a public setter method", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean validateOperation(OperationModel operation) {
        ExecutableElement method = (ExecutableElement)operation.getType();
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            this.addError(method, operation.getName() + " operation must be public", new Object[0]);
            return false;
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            this.addError(method, operation.getName() + " operation must not be static", new Object[0]);
            return false;
        }
        if (method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            this.addError(method, operation.getName() + " operation must have return type", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean hasAttributeSetter(AttributeModel attribute) {
        String attributeSetter1 = "set" + this.upperFirstLetter(attribute.getName());
        String attributeSetter2 = "set" + attribute.getName();
        TypeElement attributeClass = (TypeElement)attribute.getType().getEnclosingElement();
        Element attributeSetterElement = null;
        List<ExecutableElement> classElements = ElementFilter.methodsIn(attributeClass.getEnclosedElements());
        for (ExecutableElement e : classElements) {
            if (!e.getSimpleName().toString().equals(attributeSetter1) && !e.getSimpleName().toString().equals(attributeSetter2)) continue;
            attributeSetterElement = e;
            break;
        }
        return attributeSetterElement != null && attributeSetterElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private String upperFirstLetter(String str) {
        if (str.length() > 1) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return "";
    }

    private void addError(Element element, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        this.messager.printMessage(Diagnostic.Kind.ERROR, formattedMessage, element);
    }
}

