// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.processor.model;

import javax.lang.model.element.Element;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.InitParameter;

/**
 * <!-- ========================================================================================================== -->
 * Data model of {@linkplain InitParameter}
 * <!-- --------------------------------------------------------------------------------------------------------- -->
 */
public class AttributeModel {

    private final Element type;

    private String name;

    private String displayName;

    private String description;

    private boolean required;

    private boolean hidden;

    private boolean password;

    private boolean readOnly;

    private boolean enableSubstitution;

    private String defaultValue;

    public AttributeModel(final ProcessorContext context, final Element element) {
        this.type = element;

        final InitParameter attributeAnnotation = element.getAnnotation(InitParameter.class);
        this.name = "".equals(attributeAnnotation.name()) ? element.getSimpleName().toString() : attributeAnnotation
                .name();
        this.displayName = "".equals(attributeAnnotation.displayName()) ? element.getSimpleName().toString()
                : attributeAnnotation.displayName();
        this.description = attributeAnnotation.description();
        this.required = attributeAnnotation.required();
        this.hidden = attributeAnnotation.hidden();
        this.password = attributeAnnotation.password();
        this.readOnly = attributeAnnotation.readOnly();
        this.enableSubstitution = attributeAnnotation.enableSubstitution();
        this.defaultValue = attributeAnnotation.defaultValue();
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(final String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public boolean isRequired() {
        return required;
    }

    public void setRequired(final boolean required) {
        this.required = required;
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(final boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isPassword() {
        return password;
    }

    public void setPassword(final boolean password) {
        this.password = password;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public void setReadOnly(final boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isEnableSubstitution() {
        return enableSubstitution;
    }

    public void setEnableSubstitution(final boolean enableSubstitution) {
        this.enableSubstitution = enableSubstitution;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(final String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Element getType() {
        return type;
    }

    @Override
    public String toString() {
        return "AttributeType [type=" + type + ", name=" + name + ", displayName=" + displayName + ", description="
                + description + ", required=" + required + ", hidden=" + hidden + ", readOnly=" + readOnly
                + ", enableSubstitution=" + enableSubstitution + ", defaultValue=" + defaultValue + "]";
    }

}
