/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor.model;

import com.aurea.sonic.esb.annotation.util.ElementUtil;
import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.Parameter;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ParameterModel {
    private final Element type;
    private String name;
    private String inputType;
    private String contentType;
    private boolean isCollection;

    public ParameterModel(ProcessorContext context, Element element) {
        this.type = element;
        this.name = element.getSimpleName().toString();
        this.isCollection = element.asType().getKind() == TypeKind.ARRAY;
        Class javaType = ElementUtil.classFromType((Types)context.getTypes(), (TypeMirror)element.asType());
        String xmlType = ElementUtil.classToXmlType((Class)javaType, (boolean)this.isCollection);
        Parameter parameterAnnotation = element.getAnnotation(Parameter.class);
        if (parameterAnnotation != null) {
            this.inputType = "".equals(parameterAnnotation.inputType()) ? xmlType : parameterAnnotation.inputType();
            this.contentType = parameterAnnotation.contentType();
        } else {
            this.inputType = xmlType;
            this.contentType = "text/plain";
        }
    }

    public Element getType() {
        return this.type;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public void setCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public String toString() {
        return "ParameterType [type=" + this.type + ", name=" + this.name + ", inputType=" + this.inputType + ", contentType=" + this.contentType + ", isCollection=" + this.isCollection + "]";
    }
}

