// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.processor.model;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;

import com.aurea.sonic.esb.annotation.util.ElementUtil;
import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.Parameter;

/**
 * <!-- ========================================================================================================== -->
 * Data model of {@linkplain Parameter}
 * <!-- --------------------------------------------------------------------------------------------------------- -->
 */
public class ParameterModel {

    private final Element type;

    private String name;

    private String inputType;

    private String contentType;

    private boolean isCollection;

    public ParameterModel(final ProcessorContext context, final Element element) {
        this.type = element;
        this.name = element.getSimpleName().toString();
        this.isCollection = element.asType().getKind() == TypeKind.ARRAY;

        final Class<?> javaType = ElementUtil.classFromType(context.getTypes(), element.asType());
        final String xmlType = ElementUtil.classToXmlType(javaType, isCollection);

        final Parameter parameterAnnotation = element.getAnnotation(Parameter.class);
        if (parameterAnnotation != null) {
            this.inputType = "".equals(parameterAnnotation.inputType()) ? xmlType : parameterAnnotation.inputType();
            this.contentType = parameterAnnotation.contentType();
        } else {
            this.inputType = xmlType;
            this.contentType = "text/plain";
        }
    }

    public Element getType() {
        return type;
    }

    public String getInputType() {
        return inputType;
    }

    public void setInputType(final String inputType) {
        this.inputType = inputType;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(final String contentType) {
        this.contentType = contentType;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public boolean isCollection() {
        return isCollection;
    }

    public void setCollection(final boolean isCollection) {
        this.isCollection = isCollection;
    }

    @Override
    public String toString() {
        return "ParameterType [type=" + type + ", name=" + name + ", inputType=" + inputType + ", contentType="
                + contentType + ", isCollection=" + isCollection + "]";
    }

}
