/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor.model;

import com.aurea.sonic.esb.annotation.util.ElementUtil;
import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.Operation;
import com.aurea.sonic.esb.pojo.processor.model.ParameterModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class OperationModel {
    private final Element type;
    private String name;
    private String description;
    private String contentType;
    private String outputType;
    private String outputName;
    private boolean isCollection;
    private final List<ParameterModel> parameters = new ArrayList<ParameterModel>();

    public OperationModel(ProcessorContext context, Element element) {
        this.type = element;
        Operation operationAnnotation = element.getAnnotation(Operation.class);
        this.name = element.getSimpleName().toString();
        this.description = operationAnnotation.description();
        this.contentType = operationAnnotation.contentType();
        ExecutableElement methodElement = (ExecutableElement)element;
        this.isCollection = methodElement.getReturnType().getKind() == TypeKind.ARRAY;
        Class javaType = ElementUtil.classFromType((Types)context.getTypes(), (TypeMirror)methodElement.getReturnType());
        String xmlType = ElementUtil.classToXmlType((Class)javaType, (boolean)this.isCollection);
        this.outputType = "".equals(operationAnnotation.outputType()) ? xmlType : operationAnnotation.outputType();
        this.outputName = operationAnnotation.outputName();
        for (Element element2 : methodElement.getParameters()) {
            ParameterModel parameter = new ParameterModel(context, element2);
            this.addParameter(parameter);
        }
    }

    public Element getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public List<ParameterModel> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(ParameterModel parameter) {
        this.parameters.add(parameter);
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public void setCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String toString() {
        return "OperationType [type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", contentType=" + this.contentType + ", outputType=" + this.outputType + ", outputName=" + this.outputName + ", isCollection=" + this.isCollection + ", parameters=" + this.parameters + "]";
    }
}

