/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy;

import com.sonicsw.deploy.IArtifactStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public interface IArtifactDiff {
    public void setVerbose(boolean var1);

    public void setHeader(String var1, String var2);

    public void run(IArtifactStorage var1, IArtifactStorage var2) throws Exception;

    public void generateReport(File var1) throws IOException;

    public String getDefaultOutputFilename();

    public void setTraversalMode(TraversalMode var1);

    public static class TraversalMode {
        public static final TraversalMode LIST_ALL = new TraversalMode("ListAll");
        public static final TraversalMode CHECK_EXISTENCE = new TraversalMode("CheckExistence");
        private String m_mode;
        private static Map s_enumMap = new HashMap();

        TraversalMode(String mode) {
            this.m_mode = mode;
        }

        public static TraversalMode getTraversalMode(String strMode) {
            TraversalMode mode = (TraversalMode)s_enumMap.get(strMode);
            return mode != null ? mode : LIST_ALL;
        }

        static {
            s_enumMap.put(TraversalMode.LIST_ALL.m_mode, LIST_ALL);
            s_enumMap.put(TraversalMode.CHECK_EXISTENCE.m_mode, CHECK_EXISTENCE);
        }
    }
}

