/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.storage;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipArtifactStorage
extends FileArtifactStorage {
    public static String ARCHIVE_EXTN = ".tmpZipExtr";
    private File m_archive;

    public ZipArtifactStorage() {
        this.setStoreName("Storage[Zip]");
    }

    @Override
    public String toString() {
        String canonicalPath = null;
        if (this.m_archive != null) {
            try {
                canonicalPath = this.m_archive.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getStoreName() + (canonicalPath != null ? " for archive \"" + canonicalPath + "\"" : "");
    }

    public void openArchive(String archiveFilePath, boolean create) throws Exception {
        this.openArchive(archiveFilePath, create, null);
    }

    public void openArchive(String archiveFilePath, boolean create, String expandToDirectory) throws Exception {
        File archive = new File(archiveFilePath);
        if (!create && !archive.exists()) {
            throw new Exception("Archive '" + archiveFilePath + "' does not exist");
        }
        if (!create && !archive.isFile()) {
            throw new Exception("Archive '" + archiveFilePath + "' is not a file");
        }
        this.m_archive = archive;
        File tempZip = this.setZipTempDirectory(expandToDirectory);
        if (archive.exists()) {
            this.unzip(tempZip, archive);
        }
        this._notifyMessage(2, "Open Archive '" + archiveFilePath + "' into '" + tempZip.getAbsolutePath() + "'");
    }

    public void newArchive() throws Exception {
        File tempZip = this.setZipTempDirectory(null);
        this._notifyMessage(2, "New Archive into '" + tempZip.getAbsolutePath() + "'");
    }

    public void saveArchive() throws Exception {
        if (this.m_archive == null) {
            throw new Exception("Failed to save archive - file is not specified");
        }
        this._notifyMessage(2, "Save Archive to '" + this.m_archive.getAbsolutePath() + "'");
        this._saveArchiveAs(this.m_archive, null);
    }

    public void saveArchiveAs(String path) throws Exception {
        this.saveArchiveAs(path, null);
    }

    public void saveArchiveAs(String path, String root) throws Exception {
        this._notifyMessage(2, "Save Archive As '" + path + "' in root '" + root + "'");
        File archive = new File(path);
        this._saveArchiveAs(archive, root);
        this.m_archive = archive;
    }

    private void _saveArchiveAs(File file, String root) throws Exception {
        if (file.exists() && file.isDirectory()) {
            throw new Exception(file.getAbsolutePath() + " already exists and is a directory");
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.zip(root == null ? this.getRoot() : new File(root), file);
    }

    public void closeArchive() throws Exception {
        File root = this.getRoot();
        if (root != null) {
            this._notifyMessage(2, "Close Archive at '" + root.getAbsolutePath() + "'");
            this._deleteDir(root);
            root.delete();
        }
        this.m_archive = null;
    }

    public File getArchive() {
        return this.m_archive;
    }

    @Override
    protected void checkConnected() throws Exception {
        super.checkConnected();
    }

    public File setZipTempDirectory(String basePath) throws Exception {
        File dir = null;
        if (basePath == null) {
            String suffix = null != this.m_archive ? this.m_archive.getName() : "new.xar";
            dir = File.createTempFile("deploy", suffix);
            dir.delete();
        } else {
            dir = new File(basePath);
        }
        dir.deleteOnExit();
        this.setRoot(dir.getAbsolutePath());
        return dir;
    }

    private void unzip(File root, File archive) throws Exception {
        String rootPath = root.getAbsolutePath();
        byte[] buffer = new byte[2048];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(archive));
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String filename = entry.getName().replace('\\', '/');
            if (entry.isDirectory()) {
                File dir = new File(rootPath + File.separatorChar + filename);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            } else {
                File dest = new File(rootPath + File.separatorChar + filename);
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(dest);
                int cnt = 0;
                while (cnt != -1) {
                    fos.write(buffer, 0, cnt);
                    cnt = zis.read(buffer);
                }
                fos.close();
                zis.closeEntry();
            }
            entry = zis.getNextEntry();
        }
        zis.close();
    }

    private void zip(File root, File archive) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(archive));
        this._writeToZip(zos, root.getAbsolutePath(), root);
        zos.close();
    }

    private void _writeToZip(ZipOutputStream zos, String root, File dir) throws Exception {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isFile()) {
                String entryName = list[i].getAbsolutePath().substring(root.length() + 1);
                zos.putNextEntry(new ZipEntry(entryName));
                zos.write(FileUtils.readFile(list[i]));
                zos.closeEntry();
                continue;
            }
            if (!list[i].isDirectory() || list[i].getName().endsWith(ARCHIVE_EXTN)) continue;
            this._writeToZip(zos, root, list[i]);
        }
    }

    public byte[] readContent(IArtifact artifact) throws Exception {
        byte[] ret = null;
        if (!artifact.isValidArtifact()) {
            throw new Exception("Failed to get byte[] content of '" + artifact + "' - invalid artifact");
        }
        String path = ZipArtifactStorage.getFilename(artifact);
        File file = new File(this.getRoot(), path);
        this.checkValidFile(file);
        ret = FileUtils.readFile(file);
        return ret;
    }
}

