/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQHeader;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.envelope.XQHeaderImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import progress.message.jimpl.Message;

public class XQPartImpl
implements XQPart {
    private static final long serialVersionUID = 446011137639865899L;
    private transient DataHandler m_handler;
    private transient Object m_content;
    private XQHeaderImpl m_header = new XQHeaderImpl();
    private transient NodeInfo m_nodeInfoCache;

    public XQPartImpl() {
    }

    public XQPartImpl(Object content, String type) {
        this();
        this.setContent(content, type);
    }

    public Object clone() {
        try {
            XQPartImpl clone = (XQPartImpl)super.clone();
            clone.m_header = (XQHeaderImpl)this.m_header.clone();
            Object content = this.getContent();
            String contentType = this.getContentType();
            Object newContent = content instanceof byte[] ? ((byte[])content).clone() : (content instanceof String ? content : (content instanceof Message ? ((Message)content).protectedClone() : content));
            clone.setContent(newContent, contentType);
            clone.getHeader().setValue("Content-Type", this.m_header.getValue("Content-Type"));
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError("Clone must be supported by XQPartImpl and XQHeaderImpl");
        }
    }

    public XQHeader getHeader() {
        return this.m_header;
    }

    public String getContentId() {
        return this.m_header.getValue("Content-ID");
    }

    public void setContentId(String id) {
        this.m_header.setValue("Content-ID", id);
    }

    public final void setContent(Object content, String type) {
        if (content == null) {
            this.m_handler = null;
            this.m_content = null;
        } else {
            try {
                this.m_handler = new DataHandler(content, type);
                this.m_content = null;
            }
            catch (Exception e) {
                this.m_handler = null;
                this.m_content = content;
            }
        }
        this.m_header.setValue("Content-Type", type);
        this.m_nodeInfoCache = null;
    }

    public Object getContent() {
        Object ret = null;
        if (this.m_handler != null) {
            try {
                ret = this.m_handler.getContent();
            }
            catch (Exception exception) {}
        } else {
            ret = this.m_content;
        }
        return ret;
    }

    public String getContentType() {
        String contentType = this.m_header.getValue("Content-Type");
        if (contentType == null && this.m_handler != null) {
            contentType = this.m_handler.getContentType();
        }
        return contentType;
    }

    public DataHandler getDataHandler() {
        return this.m_handler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.m_handler = dataHandler;
        this.m_content = null;
        if (dataHandler != null) {
            this.m_header.setValue("Content-Type", dataHandler.getContentType());
        } else {
            this.m_header.remove("Content-Type");
        }
        this.m_nodeInfoCache = null;
    }

    public String toString() {
        return "XQPart [headers=" + this.m_header + ", content=" + this.getContent() + ", Content-Type=" + this.getContentType() + ", Content-ID=" + this.getContentId() + "]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getContentType());
        oos.writeObject(this.getContent());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String contentType = (String)ois.readObject();
        Object content = ois.readObject();
        this.setContent(content, contentType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Object content = this.getContent();
        result = content instanceof byte[] ? 31 * result + Arrays.hashCode((byte[])content) : 31 * result + (content == null ? 0 : content.hashCode());
        result = 31 * result + (this.m_header == null ? 0 : this.m_header.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XQPartImpl other = (XQPartImpl)obj;
        Object content = this.getContent();
        Object otherContent = other.getContent();
        if (content == null) {
            if (otherContent != null) {
                return false;
            }
        } else {
            if (content instanceof byte[]) {
                return Arrays.equals((byte[])content, (byte[])otherContent);
            }
            if (!content.equals(otherContent)) {
                return false;
            }
        }
        return !(this.m_header == null ? other.m_header != null : !this.m_header.equals(other.m_header));
    }

    InputSource getInputSource() throws XQMessageException {
        InputSource inputSource;
        Object content = this.getContent();
        if (content instanceof String) {
            inputSource = new InputSource(new StringReader((String)content));
        } else if (content instanceof InputStream) {
            inputSource = new InputSource((InputStream)content);
        } else if (content instanceof byte[]) {
            inputSource = new InputSource(new ByteArrayInputStream((byte[])content));
        } else {
            throw new XQMessageException("Cannot parse document with Content-Type=" + this.getContentType());
        }
        return inputSource;
    }

    NodeInfo getAsNodeInfo() throws XQMessageException {
        if (this.m_nodeInfoCache != null) {
            return this.m_nodeInfoCache;
        }
        InputSource inputSource = this.getInputSource();
        try {
            XMLUtils xmlUtils = new XMLUtils();
            this.m_nodeInfoCache = xmlUtils.createNodeInfo(inputSource);
            return this.m_nodeInfoCache;
        }
        catch (TransformerException e) {
            throw new XQMessageException("Error parsing message part", (Throwable)e);
        }
    }

    Document getAsDocument(boolean validate) throws XQMessageException {
        InputSource inputSource = this.getInputSource();
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder((boolean)validate);
            return builder.parse(inputSource);
        }
        catch (Exception e) {
            throw new XQMessageException("Error parsing message part", (Throwable)e);
        }
    }
}

