/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.artifact;

import com.sonicsw.deploy.IArtifact;
import java.util.StringTokenizer;

public abstract class AbstractArtifact
implements IArtifact {
    protected String m_path;
    protected String m_type;
    protected boolean m_directory;

    protected AbstractArtifact() {
    }

    public AbstractArtifact(String type, String path) {
        this.m_type = type;
        if (path == null || path.length() == 0) {
            throw new UnsupportedOperationException("Invalid artifact path");
        }
        String newPath = path;
        if (!path.startsWith("/")) {
            newPath = "/" + newPath;
        }
        this.m_directory = newPath.endsWith("/");
        this.m_path = newPath;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public String getParentPath() {
        return this._getParentPath(this.m_path);
    }

    @Override
    public String getExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    @Override
    public String getArchivePath() {
        return "/" + this.m_type + (this.m_path == null ? "" : this.m_path);
    }

    @Override
    public String getArchiveParentPath() {
        return this._getParentPath(this.getArchivePath());
    }

    @Override
    public String getDisplayType() {
        return this.m_type;
    }

    @Override
    public String getName() {
        String name = this.m_path;
        if (name.endsWith("/") && name.length() > 1) {
            name = name.substring(0, name.length() - 1);
        }
        return name.substring(this._lastIndexOfNoQuotes(name, '/') + 1);
    }

    @Override
    public String getRootDirectory() {
        if (this.isRootPath()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.m_path, "/");
        if (st.countTokens() == 0) {
            return null;
        }
        return st.nextToken();
    }

    @Override
    public boolean isValidArtifact() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.m_directory;
    }

    @Override
    public boolean isRootPath() {
        return this.m_path == null || this.m_path.length() == 0 || "/".equals(this.m_path);
    }

    public String toString() {
        return this.m_type + ":" + (this.m_path != null ? this.m_path : "<none>");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IArtifact)) {
            return false;
        }
        return this.toString().equalsIgnoreCase(obj.toString());
    }

    public int compareTo(Object other) {
        if (other instanceof IArtifact) {
            return this.getPath().toLowerCase().compareTo(((IArtifact)other).getPath().toLowerCase());
        }
        return this.getPath().toLowerCase().compareTo(other.toString().toLowerCase());
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    protected String _getParentPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path.substring(0, this._lastIndexOfNoQuotes(path, '/') + 1);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    protected int _lastIndexOfNoQuotes(String s, char c) {
        boolean inQuotes = false;
        int lastIndex = -1;
        for (int i = 0; i < s.length(); ++i) {
            char sc = s.charAt(i);
            if (sc == '\"' || sc == '\'') {
                inQuotes = !inQuotes;
                continue;
            }
            if (sc != c || inQuotes) continue;
            lastIndex = i;
        }
        return lastIndex;
    }
}

