/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.compare.MQDependencyBase;
import com.sonicsw.sonicxq.ConnectionDependencyType;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.ConnectionInfoType;
import com.sonicsw.sonicxq.DependencyListType;
import com.sonicsw.sonicxq.DependencyReportType;
import com.sonicsw.sonicxq.ESBDependencyDocument;
import com.sonicsw.sonicxq.EndpointDependencyType;
import com.sonicsw.sonicxq.EndpointDocument;
import com.sonicsw.sonicxq.EndpointInfoType;
import com.sonicsw.sonicxq.ParamsType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xmlbeans.XmlOptions;

public class MQDependency
extends MQDependencyBase {
    protected ESBDependencyDocument m_dependencyDoc;
    protected HashMap m_endpointDependencyList = new HashMap();
    protected HashMap m_connectionDependencyList = new HashMap();

    public MQDependency() {
        this.m_dependencyDoc = ESBDependencyDocument.Factory.newInstance();
        DependencyReportType dependencyReport = DependencyReportType.Factory.newInstance();
        DependencyListType dependencyList = DependencyListType.Factory.newInstance();
        dependencyReport.setDependencies(dependencyList);
        this.m_dependencyDoc.setESBDependency(dependencyReport);
    }

    @Override
    public void generateReport(File file, String storeName) throws IOException {
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        this.m_dependencyDoc.getESBDependency().setSource(storeName);
        this.m_dependencyDoc.getESBDependency().setDate(this.m_reportDate);
        this.m_dependencyDoc.save(file, opts);
    }

    @Override
    protected void handleEndpoint(EndpointDocument endpoint) {
        EndpointDependencyType ep = this.getEndpointData(endpoint);
        if (ep != null) {
            String key = MQDependency.formEndpointKey(ep);
            ArrayList<EndpointInfoType> destinationAssociations = (ArrayList<EndpointInfoType>)this.m_endpointDependencyList.get(key);
            if (destinationAssociations == null) {
                this.m_mqDestinationList.add(ep);
                destinationAssociations = new ArrayList<EndpointInfoType>();
                this.m_endpointDependencyList.put(key, destinationAssociations);
            }
            EndpointInfoType epInfo = EndpointInfoType.Factory.newInstance();
            epInfo.setName(endpoint.getEndpoint().getName());
            epInfo.setConnectionName(endpoint.getEndpoint().getConnectionRef());
            destinationAssociations.add(epInfo);
        }
    }

    private EndpointDependencyType getEndpointData(EndpointDocument endpoint) {
        EndpointDependencyType ep = null;
        ParamsType params = endpoint.getEndpoint().getParams();
        if (params != null) {
            ep = EndpointDependencyType.Factory.newInstance();
            ParamsType.StringParam[] stringParams = params.getStringParamArray();
            for (int i = 0; i < stringParams.length; ++i) {
                if (stringParams[i].getName().compareTo("destination") == 0) {
                    ep.setDestinationName(stringParams[i].getStringValue());
                }
                if (stringParams[i].getName().compareTo("type") == 0) {
                    ep.setDestinationType(stringParams[i].getStringValue());
                }
                if (stringParams[i].getName().compareTo("durableSubscriber") != 0) continue;
                ep.setDestinationIsDurable(stringParams[i].getStringValue());
            }
            String connUrl = this.getConnectionUrl(endpoint.getEndpoint().getConnectionRef());
            if (connUrl == null) {
                connUrl = endpoint.getEndpoint().getConnectionRef();
            }
            ep.setDependencyURL(connUrl);
        }
        return ep;
    }

    protected String getConnectionUrl(String esbConnectionName) {
        for (int i = 0; i < this.m_mqConnectionList.size(); ++i) {
            ConnectionDependencyType connData = (ConnectionDependencyType)this.m_mqConnectionList.get(i);
            ConnectionInfoType[] connectionInfo = connData.getConnectionInfoArray();
            for (int j = 0; j < connectionInfo.length; ++j) {
                if (esbConnectionName.compareTo(connectionInfo[j].getConnectionName()) != 0) continue;
                return connData.getDependencyURL();
            }
        }
        return null;
    }

    public static String formEndpointKey(EndpointDependencyType ep) {
        String key = ep.getDependencyURL() + ep.getDestinationType() + ep.getDestinationName();
        return key;
    }

    @Override
    protected void completeConnectionAnalysis() {
        ConnectionDependencyType[] connectionDependencies = this.m_mqConnectionList.toArray(new ConnectionDependencyType[0]);
        for (int i = 0; i < connectionDependencies.length; ++i) {
            String key = connectionDependencies[i].getDependencyURL();
            ArrayList dependencyList = (ArrayList)this.m_connectionDependencyList.get(key);
            ConnectionInfoType[] dependencies = dependencyList.toArray(new ConnectionInfoType[0]);
            connectionDependencies[i].setConnectionInfoArray(dependencies);
        }
        this.m_dependencyDoc.getESBDependency().getDependencies().setConnectionDependencyArray(connectionDependencies);
    }

    @Override
    protected void completeEndpointAnalysis() {
        EndpointDependencyType[] endpointDependencies = this.m_mqDestinationList.toArray(new EndpointDependencyType[0]);
        for (int i = 0; i < endpointDependencies.length; ++i) {
            String key = MQDependency.formEndpointKey(endpointDependencies[i]);
            ArrayList dependencyList = (ArrayList)this.m_endpointDependencyList.get(key);
            EndpointInfoType[] dependencies = dependencyList.toArray(new EndpointInfoType[0]);
            endpointDependencies[i].setEndpointInfoArray(dependencies);
        }
        this.m_dependencyDoc.getESBDependency().getDependencies().setEndpointDependencyArray(endpointDependencies);
    }

    @Override
    protected void handleConnection(ConnectionDocument connection) {
        ConnectionDependencyType conn = this.getConnectionData(connection);
        if (conn != null) {
            String key = conn.getDependencyURL();
            ArrayList<ConnectionInfoType> urlAssociations = (ArrayList<ConnectionInfoType>)this.m_connectionDependencyList.get(key);
            if (urlAssociations == null) {
                this.m_mqConnectionList.add(conn);
                urlAssociations = new ArrayList<ConnectionInfoType>();
                this.m_connectionDependencyList.put(key, urlAssociations);
            }
            ConnectionInfoType connectionInfo = ConnectionInfoType.Factory.newInstance();
            connectionInfo.setConnectionName(connection.getConnection().getName());
            urlAssociations.add(connectionInfo);
        }
    }

    private ConnectionDependencyType getConnectionData(ConnectionDocument connection) {
        ConnectionDependencyType conn = null;
        ParamsType params = connection.getConnection().getParams();
        if (params != null) {
            conn = ConnectionDependencyType.Factory.newInstance();
            ParamsType.StringParam[] stringParams = params.getStringParamArray();
            for (int i = 0; i < stringParams.length; ++i) {
                if (stringParams[i].getName().compareTo("url") != 0) continue;
                conn.setDependencyURL(stringParams[i].getStringValue());
            }
        }
        return conn;
    }

    public ArrayList getMqDestinationList() {
        return this.m_mqDestinationList;
    }

    public ArrayList getMqConnectionList() {
        return this.m_mqConnectionList;
    }

    public HashMap getMqDestinationDependencyList() {
        return this.m_endpointDependencyList;
    }

    public HashMap getMqConnectionDependencyList() {
        return this.m_connectionDependencyList;
    }
}

