/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.Diff;
import com.sonicsw.sonicxq.DiffTextArtifactType;
import com.sonicsw.sonicxq.DiffTextDetailType;
import com.sonicsw.sonicxq.DiffTextLineType;
import com.sonicsw.sonicxq.DiffTextType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class TextDiff
extends Diff {
    private int m_srcLocation = 0;
    private int m_trgLocation = 0;
    private String[] m_srcLineArray;
    private String[] m_trgLineArray;
    private ArrayList m_diffs = new ArrayList();

    public TextDiff(IArtifactStorage srcStore, IArtifactStorage trgStore) {
        super(srcStore, trgStore);
    }

    @Override
    public Object diffArtifact(IArtifact src, IArtifact trg) throws Exception {
        DiffTextLineType lines;
        DiffTextDetailType details;
        DiffTextType diff;
        String trgAsString;
        String srcAsString = this.m_sourceStore.getContentsAsString(src);
        if (srcAsString.equals(trgAsString = this.m_targetStore.getContentsAsString(trg))) {
            return null;
        }
        this.m_srcLineArray = this.parseTextDoc(srcAsString);
        this.m_trgLineArray = this.parseTextDoc(trgAsString);
        boolean recovered = true;
        while (this.m_srcLocation < this.m_srcLineArray.length && this.m_trgLocation < this.m_trgLineArray.length) {
            String srcLine = this.m_srcLineArray[this.m_srcLocation];
            String trgLine = this.m_trgLineArray[this.m_trgLocation];
            if (srcLine.equals(trgLine)) {
                ++this.m_srcLocation;
                ++this.m_trgLocation;
                continue;
            }
            recovered = this.recover();
            if (recovered) continue;
            break;
        }
        if (this.m_srcLocation < this.m_srcLineArray.length && recovered) {
            diff = DiffTextType.Factory.newInstance();
            details = DiffTextDetailType.Factory.newInstance();
            lines = DiffTextLineType.Factory.newInstance();
            for (int i = this.m_srcLocation; i < this.m_srcLineArray.length; ++i) {
                lines.addLine(this.m_srcLineArray[i]);
            }
            details.setLines(lines);
            String descText = "Lines deleted from artifact at" + this.linesChanged(this.m_srcLocation, this.m_srcLineArray.length);
            details.setPosition(descText);
            diff.setSource(details);
            this.m_diffs.add(diff);
        }
        if (this.m_trgLocation < this.m_trgLineArray.length && recovered) {
            diff = DiffTextType.Factory.newInstance();
            details = DiffTextDetailType.Factory.newInstance();
            lines = DiffTextLineType.Factory.newInstance();
            for (int i = this.m_trgLocation; i < this.m_trgLineArray.length; ++i) {
                lines.addLine(this.m_trgLineArray[i]);
            }
            details.setLines(lines);
            String descText = "Lines added to artifact at" + this.linesChanged(this.m_trgLocation, this.m_trgLineArray.length);
            details.setPosition(descText);
            diff.setTarget(details);
            this.m_diffs.add(diff);
        }
        return this.formDiffRecord(src.getArchivePath());
    }

    private DiffTextArtifactType formDiffRecord(String path) {
        if (this.m_diffs.size() == 0) {
            return null;
        }
        DiffTextType[] diffs = this.m_diffs.toArray(new DiffTextType[0]);
        DiffTextArtifactType diffRecord = DiffTextArtifactType.Factory.newInstance();
        diffRecord.setPath(path);
        diffRecord.setDiffsArray(diffs);
        return diffRecord;
    }

    private String[] parseTextDoc(String doc) throws IOException {
        ArrayList<String> linesOfText = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(doc));
        String line = null;
        while ((line = reader.readLine()) != null) {
            linesOfText.add(line);
        }
        return linesOfText.toArray(new String[0]);
    }

    private boolean recover() {
        int srcStartLoc = this.m_srcLocation;
        while (this.m_srcLocation < this.m_srcLineArray.length) {
            String descText;
            int i;
            int recoveryPoint = this.findRecoveryPoint();
            if (recoveryPoint == -1) {
                ++this.m_srcLocation;
            }
            if (recoveryPoint <= -1 && this.m_srcLocation != this.m_srcLineArray.length) continue;
            DiffTextType diff = DiffTextType.Factory.newInstance();
            DiffTextDetailType srcDetails = DiffTextDetailType.Factory.newInstance();
            DiffTextDetailType trgDetails = DiffTextDetailType.Factory.newInstance();
            int sourceLinesAffected = this.m_srcLocation - srcStartLoc;
            int targetLinesAffected = (recoveryPoint == -1 ? this.m_trgLineArray.length : recoveryPoint) - this.m_trgLocation;
            if (sourceLinesAffected > 0) {
                DiffTextLineType srcLines = DiffTextLineType.Factory.newInstance();
                for (i = 0; i < sourceLinesAffected; ++i) {
                    srcLines.addLine(this.m_srcLineArray[srcStartLoc + i]);
                }
                srcDetails.setLines(srcLines);
            }
            if (targetLinesAffected > 0) {
                DiffTextLineType trgLines = DiffTextLineType.Factory.newInstance();
                for (i = 0; i < targetLinesAffected; ++i) {
                    trgLines.addLine(this.m_trgLineArray[this.m_trgLocation + i]);
                }
                trgDetails.setLines(trgLines);
            }
            if (sourceLinesAffected == 0) {
                descText = "Lines added to artifact at" + this.linesChanged(this.m_trgLocation, recoveryPoint);
                trgDetails.setPosition(descText);
                diff.setTarget(trgDetails);
            } else if (targetLinesAffected == 0) {
                descText = "Lined deleted from artifact at" + this.linesChanged(srcStartLoc, this.m_srcLocation);
                srcDetails.setPosition(descText);
                diff.setSource(srcDetails);
            } else {
                String srcDescText = "Difference in source at" + this.linesChanged(srcStartLoc, this.m_srcLocation);
                String trgDescText = "Changed in target at" + this.linesChanged(this.m_trgLocation, recoveryPoint == -1 ? this.m_trgLineArray.length : recoveryPoint);
                srcDetails.setPosition(srcDescText);
                trgDetails.setPosition(trgDescText);
                diff.setSource(srcDetails);
                diff.setTarget(trgDetails);
            }
            this.m_diffs.add(diff);
            this.m_trgLocation = recoveryPoint;
            return recoveryPoint != -1;
        }
        return false;
    }

    private int findRecoveryPoint() {
        for (int tempTrgLoc = this.m_trgLocation; tempTrgLoc < this.m_trgLineArray.length; ++tempTrgLoc) {
            String srcLine = this.m_srcLineArray[this.m_srcLocation];
            String trgLine = this.m_trgLineArray[tempTrgLoc];
            if (!srcLine.equals(trgLine)) continue;
            return tempTrgLoc;
        }
        return -1;
    }

    private String linesChanged(int startLoc, int endLoc) {
        int linesAffected = endLoc - startLoc;
        String linesText = linesAffected == 1 ? " line " + (startLoc + 1) : " lines " + (startLoc + 1) + " to " + endLoc;
        return linesText;
    }
}

