/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.storage;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactAction;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactNotificationEvent;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.compare.AbstractFileComparator;
import com.sonicsw.deploy.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractArtifactStorage
implements IArtifactStorage {
    private ArrayList m_listeners = new ArrayList();
    private String m_storeName;
    public static final String DOT_XML = ".xml";

    protected final void setStoreName(String storeName) {
        this.m_storeName = storeName;
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    @Override
    public void addNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.remove(listener);
    }

    public void _list(IArtifact artifact, IArtifactTraversalContext context) throws Exception {
        if (!artifact.isValidArtifact()) {
            throw new Exception("Failed to list '" + artifact + "' - invalid artifact");
        }
        if (!artifact.isDirectory()) {
            throw new Exception("Failed to list '" + artifact + "' - not a directory");
        }
        if (context.isIgnored(artifact)) {
            this._notifyMessage(2, "Skipping '" + artifact + "' - it is on the ignore list");
            return;
        }
        if (artifact instanceof ESBArtifact) {
            this._listESBArtifacts(artifact, context);
        } else if (artifact instanceof SonicFSArtifact) {
            this._listSonicFSArtifacts(artifact, context);
        } else if (artifact instanceof ConfigBeanArtifact) {
            this._listConfigBeanArtifacts(artifact, context);
        } else if (artifact instanceof SystemArtifact) {
            this._listSystemArtifacts(context);
        }
    }

    protected abstract void _listESBArtifacts(IArtifact var1, IArtifactTraversalContext var2) throws Exception;

    protected abstract void _listSonicFSArtifacts(IArtifact var1, IArtifactTraversalContext var2) throws Exception;

    protected abstract void _listConfigBeanArtifacts(IArtifact var1, IArtifactTraversalContext var2) throws Exception;

    protected abstract void _listSystemArtifacts(IArtifactTraversalContext var1) throws Exception;

    @Override
    public void performAction(IArtifactAction action) throws Exception {
        try {
            this._notifyMessage(0, "Start " + action.getDescription());
            action.run(this);
        }
        finally {
            this._notifyMessage(1, "End " + action.getDescription());
        }
    }

    @Override
    public void performActionTo(IArtifactStorage destination, IArtifactAction action) throws Exception {
        try {
            this._notifyMessage(0, "Start " + action.getDescription());
            action.run(this, destination);
        }
        finally {
            this._notifyMessage(1, "End " + action.getDescription());
        }
    }

    public String buildPath(String path1, String path2) {
        String result = "";
        if (path1 != null && !"".equals(path1)) {
            result = result + path1;
        }
        if (path2 != null && !"".equals(path2)) {
            if (!path2.startsWith("/") && !"/".endsWith(result)) {
                result = result + "/";
            }
            result = result + path2;
        }
        return result;
    }

    public void _notifyMessage(int type, String message) {
        this._notifyMessage(this.m_storeName, type, message, null);
    }

    public void _notifyErrorMessage(String message, Exception exception) {
        this._notifyMessage(this.m_storeName, 4, message, exception);
    }

    public void store(IArtifact artifact, Object content, File root) throws Exception {
        File file = new File(root, AbstractArtifactStorage.getFilename(artifact));
        if (content instanceof String) {
            FileUtils.writeFile(file, (String)content, AbstractArtifactStorage.getEncoding(artifact));
        } else if (content instanceof byte[]) {
            FileUtils.writeFile(file, (byte[])content);
        } else {
            throw new Exception("Failed to store '" + artifact + "' - only supports String or byte[] content");
        }
    }

    public static String getEncoding(IArtifact artifact) throws Exception {
        return AbstractArtifactStorage.getEncoding(artifact, null);
    }

    public static String getEncoding(IArtifact artifact, byte[] content) throws Exception {
        if (artifact instanceof ESBArtifact) {
            return "UTF-8";
        }
        String extension = artifact.getExtension();
        boolean isXmlFile = AbstractFileComparator.isXMLExtension(extension);
        if (artifact instanceof SonicFSArtifact && isXmlFile) {
            if (content != null) {
                String encoding = AbstractArtifactStorage.getXMLEncoding(new ByteArrayInputStream(content));
                ((SonicFSArtifact)artifact).setEncoding(encoding);
                return encoding;
            }
            if (((SonicFSArtifact)artifact).getEncoding() != null) {
                return ((SonicFSArtifact)artifact).getEncoding();
            }
        }
        return null;
    }

    public static String getXMLEncoding(InputStream input) throws XMLStreamException {
        XMLEvent event;
        XMLInputFactory f = XMLInputFactory.newInstance();
        XMLEventReader events = f.createXMLEventReader(input);
        if (events.hasNext() && (event = events.nextEvent()) instanceof StartDocument) {
            StartDocument startDocument = (StartDocument)event;
            return startDocument.getCharacterEncodingScheme();
        }
        return null;
    }

    public static String getFilename(IArtifact artifact) {
        if (artifact instanceof SystemArtifact) {
            return artifact.getPath();
        }
        String path = artifact.getArchivePath();
        if (!artifact.isDirectory() && artifact instanceof ESBArtifact) {
            path = path + DOT_XML;
        }
        return path;
    }

    private void _notifyMessage(Object source, int type, String message, Exception exception) {
        ArtifactNotificationEvent event = new ArtifactNotificationEvent(source, type, message, exception);
        if (this.m_listeners.size() == 0) {
            System.out.println(event.toString());
            if (exception != null) {
                exception.printStackTrace();
            }
        }
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((IArtifactNotificationListener)this.m_listeners.get(i)).notifyMessage(event);
        }
    }
}

