/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.deploy.traversal.SonicFSTraverserFactory;
import com.sonicsw.deploy.util.ELExpressionUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ESBProcessTraverser
extends AbstractESBTraverser {
    public static String processAnnotationTypePath = "/Resources/SonicESB/Annotations/process/";

    public ESBProcessTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    protected void doTraversal(IArtifactTraversalContext context) throws Exception {
        String onRampRef;
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        String entryRef = element.getAttribute("entry_ref");
        if (entryRef != null && entryRef.length() > 0) {
            ESBTraverserFactory.createEndpointTraverser(entryRef).traverse(context);
        }
        if ((onRampRef = element.getAttribute("onRampReference")) != null && onRampRef.length() > 0) {
            ESBTraverserFactory.createServiceTraverser(onRampRef).traverse(context);
        }
        this.traverseEndpoints(context, element, "faultEndpoint");
        this.traverseEndpoints(context, element, "rejectEndpoint");
        this.traverseEndpoints(context, DOMUtils.getImmediateChildElementByName((Element)element, (String)"exitEndpoint_list"), "exitEndpoint");
        Element fhElem = DOMUtils.getImmediateChildElementByName((Element)element, (String)"faultHandler");
        this.traverseFaultHandler(context, fhElem);
        Element tracking = DOMUtils.getImmediateChildElementByName((Element)element, (String)"trackingDetails");
        if (tracking != null) {
            this.traverseEndpoints(context, tracking, "eventEndpoint");
            Element idGen = DOMUtils.getImmediateChildElementByName((Element)tracking, (String)"idGenerator");
            this.traverseParameters(context, DOMUtils.getImmediateChildElementByName((Element)idGen, (String)"params"));
        }
        Element itenerary = DOMUtils.getImmediateChildElementByName((Element)element, (String)"itinerary");
        this.processItinerary(context, itenerary);
        String wsdl = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"wsdlUrl");
        if (wsdl != null && wsdl.length() > 0) {
            this.traverseURLRefs(wsdl, context);
        }
        String annotatioFilePath = processAnnotationTypePath + this.m_artifact.getName() + "." + "annotation";
        IArtifact annotationArtifact = ArtifactFactory.createArtifact("SonicFS", annotatioFilePath);
        if (context.getStorage().exists(annotationArtifact)) {
            context.addTraversed(annotationArtifact, false);
        }
    }

    protected void processItinerary(IArtifactTraversalContext context, Element Itinerary) throws Exception {
        NodeList childs = Itinerary.getChildNodes();
        block3: for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            String elemName = child.getLocalName();
            switch (child.getNodeType()) {
                case 1: {
                    if (elemName.equals("step")) {
                        String ep_ref = ((Element)child).getAttribute("endpoint_ref");
                        String type = ((Element)child).getAttribute("type");
                        if (type.equalsIgnoreCase("SERVICE")) {
                            ESBTraverserFactory.createServiceTraverser(ep_ref).traverse(context);
                        } else if (type.equalsIgnoreCase("PROCESS")) {
                            ESBTraverserFactory.createProcessTraverser(ep_ref).traverse(context);
                        } else if (type.equalsIgnoreCase("ENDPOINT")) {
                            ESBTraverserFactory.createEndpointTraverser(ep_ref).traverse(context);
                        }
                        this.processItinerary(context, (Element)child);
                        continue block3;
                    }
                    if (elemName.equals("terminate") || elemName.equals("fault") || elemName.equals("throw") || elemName.equals("rethrow") || elemName.equals("exit") || elemName.equals("resubmit") || elemName.equals("transform")) {
                        this.processItinerary(context, (Element)child);
                        continue block3;
                    }
                    if (elemName.equals("fanout") || elemName.equals("decision") || "option".equals(elemName) || "path".equals(elemName)) {
                        this.processItinerary(context, (Element)child);
                        continue block3;
                    }
                    if (elemName.equals("params")) {
                        this.traverseParameters(context, (Element)child);
                        continue block3;
                    }
                    if (elemName.equals("faultHandler")) {
                        this.traverseFaultHandler(context, (Element)child);
                        continue block3;
                    }
                    if (!elemName.equals("messageMapping")) continue block3;
                    this.traverseMessageMapping(context, (Element)child);
                }
            }
        }
    }

    private void traverseMessageMapping(IArtifactTraversalContext context, Element child) {
        NodeList nodes = child.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            Element elem = (Element)nodes.item(i);
            if ("rule".equals(elem.getLocalName())) {
                String sonicFSFile = null;
                String action = elem.getAttribute("action");
                if ("xslt".equalsIgnoreCase(action)) {
                    sonicFSFile = elem.getAttribute("use");
                }
                String sourceXMLFile = ELExpressionUtils.getFSNameFromELExpression(elem.getAttribute("source"));
                if (sonicFSFile != null) {
                    this.createTraverser(context, sonicFSFile);
                }
                if (sourceXMLFile == null) continue;
                this.createTraverser(context, sourceXMLFile);
                continue;
            }
            this.traverseMessageMapping(context, elem);
        }
    }

    private void createTraverser(IArtifactTraversalContext context, String sonicFile) {
        try {
            IArtifact artifact = this.createArtifactForSonicfsURL(sonicFile, context);
            SonicFSTraverserFactory.createTraverser(artifact).traverse(context);
        }
        catch (Exception e) {
            context.addErrored(this.m_artifact);
            ((AbstractArtifactStorage)context.getStorage())._notifyErrorMessage("Error traversing mapping referenced file '" + sonicFile + "' : " + e.getMessage(), e);
        }
    }
}

