/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.util.XmlBeanValidator;
import com.sonicsw.sonicxq.ClassPathReplaceMapsType;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.ConnectionMapType;
import com.sonicsw.sonicxq.ConnectionMapsType;
import com.sonicsw.sonicxq.ConnectionRulesType;
import com.sonicsw.sonicxq.DecisionType;
import com.sonicsw.sonicxq.DevEndpointMapsType;
import com.sonicsw.sonicxq.DevMappingType;
import com.sonicsw.sonicxq.DevServiceMapsType;
import com.sonicsw.sonicxq.EndpointDocument;
import com.sonicsw.sonicxq.EndpointMapType;
import com.sonicsw.sonicxq.EndpointMapsType;
import com.sonicsw.sonicxq.EndpointRefMapType;
import com.sonicsw.sonicxq.EndpointRefType;
import com.sonicsw.sonicxq.EndpointRefTypeEnumeration;
import com.sonicsw.sonicxq.EndpointRulesType;
import com.sonicsw.sonicxq.ExitEndpointMapType;
import com.sonicsw.sonicxq.ExitEndpointsMapType;
import com.sonicsw.sonicxq.FanoutType;
import com.sonicsw.sonicxq.ItineraryStepMapType;
import com.sonicsw.sonicxq.ItineraryStepsMapType;
import com.sonicsw.sonicxq.ItineraryType;
import com.sonicsw.sonicxq.ParamTypeEnum;
import com.sonicsw.sonicxq.ParamsMapType;
import com.sonicsw.sonicxq.ParamsType;
import com.sonicsw.sonicxq.ProcessDocument;
import com.sonicsw.sonicxq.ProcessMapType;
import com.sonicsw.sonicxq.ProcessMapsType;
import com.sonicsw.sonicxq.PropertyReplaceMapsType;
import com.sonicsw.sonicxq.RuleParamType;
import com.sonicsw.sonicxq.RuleType;
import com.sonicsw.sonicxq.ServiceDocument;
import com.sonicsw.sonicxq.ServiceMapType;
import com.sonicsw.sonicxq.ServiceMapsType;
import com.sonicsw.sonicxq.ServiceRulesType;
import com.sonicsw.sonicxq.StepType;
import com.sonicsw.sonicxq.StringReplaceMapsType;
import com.sonicsw.sonicxq.TailoringMapsDocument;
import com.sonicsw.sonicxq.TailoringMapsType;
import com.sonicsw.sonicxq.TailoringRulesDocument;
import com.sonicsw.sonicxq.TailoringRulesType;
import com.sonicsw.sonicxq.XQCONTAINERDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class MapCreator {
    private IArtifactStorage m_store;
    private Vector<XQCONTAINERDocument> m_XARContainerList = new Vector();
    private Vector<ServiceDocument> m_XARServiceList = new Vector();
    private Vector<ProcessDocument> m_XARProcessList = new Vector();
    private Vector<EndpointDocument> m_XAREndpointList = new Vector();
    private Vector<ConnectionDocument> m_XARConnectionList = new Vector();
    private TailoringMapsDocument m_TailoringDoc = null;
    private TailoringRulesDocument m_rulesDoc = null;
    private TailoringRulesType m_rulesList = null;
    private DevMappingType[] m_serviceMapArray = null;
    private DevMappingType[] m_endpointMapArray = null;
    private StringReplaceMapsType m_stringReplaceMaps = null;
    private PropertyReplaceMapsType[] m_propertyReplaceMapsArray = null;
    private ClassPathReplaceMapsType[] m_classPathReplaceMapsArray = null;
    public static String[] serviceIgnoreList = new String[]{new String("BPEType")};
    private static String s_mapVersion = "TailorMap8.0";
    private static String[] s_compatibleVersions = new String[]{new String("TailorMap7.0")};

    public MapCreator(IArtifactStorage source) {
        this.m_store = source;
        this.m_TailoringDoc = TailoringMapsDocument.Factory.newInstance();
        TailoringMapsType tailoringList = TailoringMapsType.Factory.newInstance();
        tailoringList.setVersion(s_mapVersion);
        this.m_TailoringDoc.setTailoringMaps(tailoringList);
    }

    public static boolean isCompatibleVersion(String mapVersion) {
        if (s_mapVersion.equals(mapVersion)) {
            return true;
        }
        if (mapVersion == null) {
            return false;
        }
        for (int i = 0; i < s_compatibleVersions.length; ++i) {
            if (!s_compatibleVersions[i].equals(mapVersion)) continue;
            return true;
        }
        return false;
    }

    public void addArchiveContainer(XQCONTAINERDocument item) {
        this.m_XARContainerList.add(item);
    }

    public void addArchiveProcess(ProcessDocument item) {
        this.m_XARProcessList.add(item);
    }

    public void addArchiveService(ServiceDocument item) {
        this.m_XARServiceList.add(item);
    }

    public void addArchiveEndpoint(EndpointDocument item) {
        this.m_XAREndpointList.add(item);
    }

    public void addArchiveConnection(ConnectionDocument item) {
        this.m_XARConnectionList.add(item);
    }

    public void createMapFile(File mapFile, File rulesFile) throws IOException, XmlException, Exception {
        if (rulesFile != null) {
            this.processRules(rulesFile);
        }
        this.processDevURLs();
        this.processProcessDoc();
        this.processServiceDoc();
        this.processEndpointDoc();
        this.processConnectionDoc();
        this.processPropertyRules();
        this.processClassPathRules();
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        opts.setUseDefaultNamespace();
        if (!XmlBeanValidator.validate(this.m_store, this.m_TailoringDoc)) {
            throw new Exception("Process results in an invalid map file");
        }
        this.m_TailoringDoc.save(mapFile, opts);
    }

    private void processRules(File rulesFile) throws IOException, XmlException, Exception {
        this.m_rulesDoc = TailoringRulesDocument.Factory.parse(rulesFile);
        this.m_rulesList = this.m_rulesDoc.getTailoringRules();
        this.validateRulesFile();
        if (this.m_rulesList != null && this.m_rulesList.getDevEnvRules() != null) {
            DevServiceMapsType serviceMaps;
            this.m_stringReplaceMaps = this.m_rulesList.getDevEnvRules().getStringReplaceMaps();
            DevEndpointMapsType endpointMaps = this.m_rulesList.getDevEnvRules().getDevEndpointMaps();
            if (endpointMaps != null) {
                this.m_endpointMapArray = endpointMaps.getDevEndpointMapArray();
            }
            if ((serviceMaps = this.m_rulesList.getDevEnvRules().getDevServiceMaps()) != null) {
                this.m_serviceMapArray = serviceMaps.getDevServiceMapArray();
            }
        }
        if (this.m_rulesList != null && this.m_rulesList.getPropertyRules() != null) {
            this.m_propertyReplaceMapsArray = this.m_rulesList.getPropertyRules().getPropertyReplaceMapsArray();
        }
        if (this.m_rulesList != null && this.m_rulesList.getClassPathRules() != null) {
            this.m_classPathReplaceMapsArray = this.m_rulesList.getClassPathRules().getClassPathReplaceMapsArray();
        }
    }

    private void processDevURLs() {
        if (this.m_stringReplaceMaps != null) {
            this.m_TailoringDoc.getTailoringMaps().setStringReplaceMaps(this.m_stringReplaceMaps);
        }
    }

    private void processPropertyRules() {
        if (this.m_propertyReplaceMapsArray != null) {
            this.m_TailoringDoc.getTailoringMaps().setPropertyReplaceMapsArray(this.m_propertyReplaceMapsArray);
        }
    }

    private void processClassPathRules() {
        if (this.m_classPathReplaceMapsArray != null) {
            this.m_TailoringDoc.getTailoringMaps().setClassPathReplaceMapsArray(this.m_classPathReplaceMapsArray);
        }
    }

    private void processProcessDoc() {
        ProcessMapsType processList = ProcessMapsType.Factory.newInstance();
        if (this.m_XARProcessList.isEmpty()) {
            this.m_TailoringDoc.getTailoringMaps().setProcessMaps(processList);
            return;
        }
        ProcessMapType[] processes = new ProcessMapType[this.m_XARProcessList.size()];
        for (int i = 0; i < this.m_XARProcessList.size(); ++i) {
            ExitEndpointsMapType mapExitEndpoints;
            String onRampReference;
            ProcessDocument ProcessDoc = this.m_XARProcessList.elementAt(i);
            ProcessMapType process = ProcessMapType.Factory.newInstance();
            String name = ProcessDoc.getProcess().getName();
            process.setName(name);
            process.setTimeToLive(ProcessDoc.getProcess().getTimeToLive());
            process.setQoS(ProcessDoc.getProcess().getQualityOfService());
            if (ProcessDoc.getProcess().getTrackingDetails() != null) {
                process.setTrackingLevel(ProcessDoc.getProcess().getTrackingDetails().getTrackingLevel());
            }
            if ((onRampReference = this.getOnRampReferenceDevReplacement(ProcessDoc.getProcess().getOnRampReference())) != null) {
                process.setOnRampReference(onRampReference);
            }
            EndpointRefMapType replacementEndPoint = null;
            String entry = this.getEndpointDevReplacement(ProcessDoc.getProcess().getEntryRef());
            if (entry != null) {
                process.setEntryRef(entry);
            }
            if ((replacementEndPoint = this.getDevReplacement(ProcessDoc.getProcess().getFaultEndpoint())) != null) {
                process.setFaultEndpoint(replacementEndPoint);
            }
            if ((replacementEndPoint = this.getDevReplacement(ProcessDoc.getProcess().getRejectEndpoint())) != null) {
                process.setRejectEndpoint(replacementEndPoint);
            }
            if (ProcessDoc.getProcess().getTrackingDetails() != null && (replacementEndPoint = this.getDevReplacement(ProcessDoc.getProcess().getTrackingDetails().getEventEndpoint())) != null) {
                process.setTrackingDetailsEndpoint(replacementEndPoint);
            }
            if (ProcessDoc.getProcess().getExitEndpointList() != null && (mapExitEndpoints = this.getExitEdpoints(ProcessDoc.getProcess().getExitEndpointList().getExitEndpointArray())) != null) {
                process.setExitEndpoints(mapExitEndpoints);
            }
            if (ProcessDoc.getProcess().getItinerary() != null) {
                ArrayList<ItineraryStepMapType> stepArray = new ArrayList<ItineraryStepMapType>();
                this.processItinerary(ProcessDoc.getProcess().getItinerary(), stepArray);
                if (!stepArray.isEmpty()) {
                    ItineraryStepsMapType mapSteps = ItineraryStepsMapType.Factory.newInstance();
                    mapSteps.setStepsArray(stepArray.toArray(new ItineraryStepMapType[0]));
                    process.setSteps(mapSteps);
                }
            }
            processes[i] = process;
        }
        processList.setProcessMapArray(processes);
        this.m_TailoringDoc.getTailoringMaps().setProcessMaps(processList);
    }

    private String getOnRampReferenceDevReplacement(String onRampReference) {
        if (this.m_serviceMapArray != null && onRampReference != null) {
            for (int i = 0; i < this.m_serviceMapArray.length; ++i) {
                if (!onRampReference.equalsIgnoreCase(this.m_serviceMapArray[i].getName())) continue;
                return this.m_serviceMapArray[i].getUpdatedName();
            }
        }
        return null;
    }

    private void processItinerary(ItineraryType itinerary, ArrayList<ItineraryStepMapType> result) {
        FanoutType[] fanouts;
        if (itinerary == null) {
            return;
        }
        this.processItineraryStepArray(itinerary.getStepArray(), result);
        DecisionType[] decisions = itinerary.getDecisionArray();
        if (decisions != null) {
            for (int j = 0; j < decisions.length; ++j) {
                DecisionType.Option[] options = decisions[j].getOptionArray();
                if (options == null) continue;
                for (int k = 0; k < options.length; ++k) {
                    this.processItinerary(options[k], result);
                }
            }
        }
        if ((fanouts = itinerary.getFanoutArray()) != null) {
            for (int j = 0; j < fanouts.length; ++j) {
                FanoutType.Path[] paths = fanouts[j].getPathArray();
                if (paths == null) continue;
                for (int k = 0; k < paths.length; ++k) {
                    this.processItinerary(paths[k], result);
                }
            }
        }
    }

    private void processItineraryStepArray(StepType[] steps, ArrayList<ItineraryStepMapType> result) {
        if (steps == null) {
            return;
        }
        for (int j = 0; j < steps.length; ++j) {
            EndpointRefType stepAddress = EndpointRefType.Factory.newInstance();
            stepAddress.setEndpointRef(steps[j].getEndpointRef());
            stepAddress.setType(steps[j].getType());
            EndpointRefMapType replacementEndPoint = this.getDevReplacement(stepAddress);
            if (replacementEndPoint == null) continue;
            ItineraryStepMapType step = ItineraryStepMapType.Factory.newInstance();
            String stepName = steps[j].getName();
            if (stepName == null) {
                stepName = "Step " + (result.size() + 1);
            }
            step.setStep(stepName);
            step.setStepEndpoint(replacementEndPoint);
            result.add(step);
        }
    }

    private ExitEndpointsMapType getExitEdpoints(EndpointRefType[] exitEndpoints) {
        ExitEndpointsMapType mapExitEndpoints = null;
        if (exitEndpoints != null) {
            mapExitEndpoints = ExitEndpointsMapType.Factory.newInstance();
            ExitEndpointMapType[] mapExitEndpointArray = new ExitEndpointMapType[exitEndpoints.length];
            for (int i = 0; i < exitEndpoints.length; ++i) {
                ExitEndpointMapType mapExitEndpoint = ExitEndpointMapType.Factory.newInstance();
                EndpointRefMapType originalEndPoint = this.endpointEsbToMap(exitEndpoints[i]);
                mapExitEndpoint.setOriginalValue(originalEndPoint);
                EndpointRefMapType replacementEndPoint = this.getDevReplacement(exitEndpoints[i]);
                if (replacementEndPoint != null) {
                    mapExitEndpoint.setValue(replacementEndPoint);
                } else {
                    mapExitEndpoint.setValue(originalEndPoint);
                }
                mapExitEndpointArray[i] = mapExitEndpoint;
            }
            mapExitEndpoints.setExitEndpointMapArray(mapExitEndpointArray);
        }
        return mapExitEndpoints;
    }

    private String getEndpointDevReplacement(String entry) {
        if (entry == null) {
            return null;
        }
        if (this.m_endpointMapArray != null) {
            for (int i = 0; i < this.m_endpointMapArray.length; ++i) {
                if (!entry.equalsIgnoreCase(this.m_endpointMapArray[i].getName())) continue;
                return this.m_endpointMapArray[i].getUpdatedName();
            }
        }
        return entry;
    }

    private EndpointRefMapType getDevReplacement(EndpointRefType endpointRef) {
        EndpointRefMapType endpointRefMap;
        block4: {
            EndpointRefTypeEnumeration.Enum type;
            String name;
            block5: {
                if (endpointRef == null) {
                    return null;
                }
                endpointRefMap = this.endpointEsbToMap(endpointRef);
                name = endpointRef.getEndpointRef();
                type = endpointRef.getType();
                if (!type.toString().equalsIgnoreCase("service")) break block5;
                if (this.m_serviceMapArray == null) break block4;
                for (int i = 0; i < this.m_serviceMapArray.length; ++i) {
                    if (!name.equalsIgnoreCase(this.m_serviceMapArray[i].getName())) continue;
                    endpointRefMap.setEndpointRef(this.m_serviceMapArray[i].getUpdatedName());
                    break block4;
                }
                break block4;
            }
            if (type.toString().equalsIgnoreCase("endpoint") && this.m_endpointMapArray != null) {
                for (int i = 0; i < this.m_endpointMapArray.length; ++i) {
                    if (!name.equalsIgnoreCase(this.m_endpointMapArray[i].getName())) continue;
                    endpointRefMap.setEndpointRef(this.m_endpointMapArray[i].getUpdatedName());
                    break;
                }
            }
        }
        return endpointRefMap;
    }

    private EndpointRefMapType endpointEsbToMap(EndpointRefType endpointRef) {
        EndpointRefMapType endpointRefMap = EndpointRefMapType.Factory.newInstance();
        endpointRefMap.setEndpointRef(endpointRef.getEndpointRef());
        if (endpointRef.getType() != null) {
            endpointRefMap.setType(endpointRef.getType().toString());
        }
        return endpointRefMap;
    }

    private void processServiceDoc() throws XmlException {
        ServiceMapsType serviceList = ServiceMapsType.Factory.newInstance();
        if (this.m_XARServiceList.isEmpty()) {
            this.m_TailoringDoc.getTailoringMaps().setServiceMaps(serviceList);
            return;
        }
        ArrayList<ServiceMapType> mappedServices = new ArrayList<ServiceMapType>();
        for (int i = 0; i < this.m_XARServiceList.size(); ++i) {
            RuleParamType[] ruleArray;
            ExitEndpointsMapType mapExitEndpoints;
            boolean addService = false;
            ServiceDocument ServiceDoc = this.m_XARServiceList.elementAt(i);
            ServiceMapType service = ServiceMapType.Factory.newInstance();
            String serviceName = ServiceDoc.getService().getName();
            String typeName = ServiceDoc.getService().getTypeRef();
            service.setName(serviceName);
            service.setTypeRef(typeName);
            if (MapCreator.ignoreInstance(serviceIgnoreList, typeName)) continue;
            EndpointRefMapType replacementEndPoint = null;
            String entry = this.getEndpointDevReplacement(ServiceDoc.getService().getEntryRef());
            if (entry != null) {
                service.setEntryRef(entry);
                addService = true;
            }
            if ((replacementEndPoint = this.getDevReplacement(ServiceDoc.getService().getFaultEndpoint())) != null) {
                service.setFaultEndpoint(replacementEndPoint);
                addService = true;
            }
            if ((replacementEndPoint = this.getDevReplacement(ServiceDoc.getService().getRejectEndpoint())) != null) {
                service.setRejectEndpoint(replacementEndPoint);
                addService = true;
            }
            if (ServiceDoc.getService().getExitEndpointList() != null && (mapExitEndpoints = this.getExitEdpoints(ServiceDoc.getService().getExitEndpointList().getExitEndpointArray())) != null) {
                service.setExitEndpoints(mapExitEndpoints);
                addService = true;
            }
            if (this.m_rulesList != null && this.m_rulesList.getServiceRules() != null && (ruleArray = this.getParamRules(typeName, this.m_rulesList.getServiceRules().getServiceRuleArray())) != null) {
                ParamsMapType serviceParams = ParamsMapType.Factory.newInstance();
                serviceParams = this.ProcessParamList(serviceName, ruleArray, ServiceDoc.getService().getParams());
                service.setParamMap(serviceParams);
                addService = true;
            }
            if (addService) {
                mappedServices.add(service);
                continue;
            }
            ((AbstractArtifactStorage)this.m_store)._notifyMessage(3, "Skipping '" + ServiceDoc.getService().getName() + "' - no rules for this artifact");
        }
        ServiceMapType[] services = null;
        if (!mappedServices.isEmpty()) {
            services = new ServiceMapType[mappedServices.size()];
            services = mappedServices.toArray(new ServiceMapType[0]);
            serviceList.setServiceMapArray(services);
        }
        this.m_TailoringDoc.getTailoringMaps().setServiceMaps(serviceList);
    }

    private void processEndpointDoc() throws XmlException {
        EndpointMapsType endpointList = EndpointMapsType.Factory.newInstance();
        if (this.m_XAREndpointList.isEmpty()) {
            this.m_TailoringDoc.getTailoringMaps().setEndpointMaps(endpointList);
            return;
        }
        EndpointMapType[] endpoints = new EndpointMapType[this.m_XAREndpointList.size()];
        for (int i = 0; i < this.m_XAREndpointList.size(); ++i) {
            RuleParamType[] ruleArray;
            ParamsMapType mapParams;
            EndpointDocument EndpointDoc = this.m_XAREndpointList.elementAt(i);
            String endpointName = EndpointDoc.getEndpoint().getName();
            String typeName = EndpointDoc.getEndpoint().getTypeRef();
            EndpointMapType endpoint = EndpointMapType.Factory.newInstance();
            endpoint.setName(endpointName);
            endpoint.setTypeRef(typeName);
            endpoint.setQoS(EndpointDoc.getEndpoint().getQualityOfService());
            if (this.m_rulesList != null && this.m_rulesList.getEndpointRules() != null && EndpointDoc.getEndpoint().getParams() != null && (mapParams = this.ProcessParamList(endpointName, ruleArray = this.getParamRules(typeName, this.m_rulesList.getEndpointRules().getEndpointRuleArray()), EndpointDoc.getEndpoint().getParams())) != null) {
                endpoint.setParamMap(mapParams);
            }
            endpoints[i] = endpoint;
        }
        endpointList.setEndpointMapArray(endpoints);
        this.m_TailoringDoc.getTailoringMaps().setEndpointMaps(endpointList);
    }

    private void processConnectionDoc() throws XmlException {
        ConnectionMapsType connectionList = ConnectionMapsType.Factory.newInstance();
        if (this.m_XARConnectionList.isEmpty()) {
            this.m_TailoringDoc.getTailoringMaps().setConnectionMaps(connectionList);
            return;
        }
        ArrayList<ConnectionMapType> mappedConnections = new ArrayList<ConnectionMapType>();
        for (int i = 0; i < this.m_XARConnectionList.size(); ++i) {
            ConnectionDocument ConnectionDoc = this.m_XARConnectionList.elementAt(i);
            String connectionName = ConnectionDoc.getConnection().getName();
            String typeName = ConnectionDoc.getConnection().getTypeRef();
            if (this.m_rulesList == null || this.m_rulesList.getConnectionRules() == null) {
                ((AbstractArtifactStorage)this.m_store)._notifyMessage(3, "Skipping '" + ConnectionDoc.getConnection().getName() + "' - no rules for this artifact");
                continue;
            }
            RuleParamType[] ruleArray = null;
            ruleArray = this.getParamRules(ConnectionDoc.getConnection().getTypeRef(), this.m_rulesList.getConnectionRules().getConnectionRuleArray());
            if (ruleArray == null) {
                ((AbstractArtifactStorage)this.m_store)._notifyMessage(3, "Skipping '" + ConnectionDoc.getConnection().getName() + "' - no rules for this artifact");
                continue;
            }
            ConnectionMapType connection = ConnectionMapType.Factory.newInstance();
            connection.setName(connectionName);
            connection.setTypeRef(typeName);
            ParamsMapType mapParams = this.ProcessParamList(connection.getName(), ruleArray, ConnectionDoc.getConnection().getParams());
            if (mapParams != null) {
                connection.setParamMap(mapParams);
            }
            mappedConnections.add(connection);
        }
        ConnectionMapType[] connections = null;
        if (!mappedConnections.isEmpty()) {
            connections = new ConnectionMapType[mappedConnections.size()];
            connections = mappedConnections.toArray(new ConnectionMapType[0]);
            connectionList.setConnectionMapArray(connections);
        }
        this.m_TailoringDoc.getTailoringMaps().setConnectionMaps(connectionList);
    }

    public static boolean ignoreInstance(String[] ignoreList, String ignoreThis) {
        if (ignoreThis != null) {
            for (int i = 0; i < ignoreList.length; ++i) {
                if (!ignoreThis.equals(ignoreList[i])) continue;
                return true;
            }
        }
        return false;
    }

    private RuleParamType[] getParamRules(String typeName, RuleType[] rules) {
        RuleParamType[] ruleArray = null;
        for (int i = 0; i < rules.length; ++i) {
            if (!typeName.equals(rules[i].getType())) continue;
            ruleArray = rules[i].getParamArray();
        }
        return ruleArray;
    }

    private ParamsMapType ProcessParamList(String name, RuleParamType[] ruleArray, ParamsType archiveParams) throws XmlException {
        ParamsMapType mapParamsList = ParamsMapType.Factory.newInstance();
        if (ruleArray == null) {
            return mapParamsList;
        }
        RuleParamType[] stringRules = this.getRules(ruleArray, ParamTypeEnum.STRING);
        RuleParamType[] xmlRules = this.getRules(ruleArray, ParamTypeEnum.XML);
        ParamsType.StringParam[] archiveStringParams = null;
        ParamsType.XmlParam[] archiveXmlParams = null;
        if (archiveParams != null) {
            archiveStringParams = archiveParams.getStringParamArray();
            archiveXmlParams = archiveParams.getXmlParamArray();
        }
        if (stringRules.length + xmlRules.length == 0) {
            return mapParamsList;
        }
        ParamsMapType.StringParam[] mapStringParams = this.handleStringParams(stringRules, archiveStringParams);
        ParamsMapType.XmlParam[] mapXmlParams = this.handleXmlParams(xmlRules, archiveXmlParams);
        mapParamsList.setStringParamArray(mapStringParams);
        mapParamsList.setXmlParamArray(mapXmlParams);
        return mapParamsList;
    }

    private RuleParamType[] getRules(RuleParamType[] ruleParams, ParamTypeEnum.Enum type) {
        ArrayList<RuleParamType> rulesArray = new ArrayList<RuleParamType>();
        for (int j = 0; j < ruleParams.length; ++j) {
            if (ruleParams[j].getType() != type) continue;
            rulesArray.add(ruleParams[j]);
        }
        RuleParamType[] stringRules = rulesArray.toArray(new RuleParamType[0]);
        return stringRules;
    }

    private ParamsMapType.StringParam[] handleStringParams(RuleParamType[] rules, ParamsType.StringParam[] archiveStringParams) {
        ParamsMapType.StringParam[] mapParams = new ParamsMapType.StringParam[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            ParamsMapType.StringParam mapStringParam = ParamsMapType.StringParam.Factory.newInstance();
            mapStringParam.setName(rules[i].getName());
            if (archiveStringParams != null) {
                for (int j = 0; j < archiveStringParams.length; ++j) {
                    String value;
                    if (!rules[i].getName().equals(archiveStringParams[j].getName())) continue;
                    String url = archiveStringParams[j].getUrl();
                    if (url != null) {
                        mapStringParam.setUrl(url);
                    }
                    if ((value = archiveStringParams[j].getStringValue()) == null) continue;
                    mapStringParam.setStringValue(value);
                }
            }
            mapParams[i] = mapStringParam;
        }
        return mapParams;
    }

    private ParamsMapType.XmlParam[] handleXmlParams(RuleParamType[] rules, ParamsType.XmlParam[] archiveXmlParams) {
        ParamsMapType.XmlParam[] mapParams = new ParamsMapType.XmlParam[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            ParamsMapType.XmlParam mapXmlParam = ParamsMapType.XmlParam.Factory.newInstance();
            if (archiveXmlParams != null) {
                for (int j = 0; j < archiveXmlParams.length; ++j) {
                    if (!rules[i].getName().equals(archiveXmlParams[j].getName())) continue;
                    String url = archiveXmlParams[j].getUrl();
                    if (url != null) {
                        mapXmlParam.setUrl(url);
                        continue;
                    }
                    XmlCursor archiveParamCursor = archiveXmlParams[j].newCursor();
                    if (!archiveParamCursor.toFirstChild()) continue;
                    XmlCursor mapParamCursor = mapXmlParam.newCursor();
                    mapParamCursor.toEndDoc();
                    archiveParamCursor.copyXml(mapParamCursor);
                }
            }
            mapXmlParam.setName(rules[i].getName());
            mapParams[i] = mapXmlParam;
        }
        return mapParams;
    }

    public void validateRulesFile() throws Exception {
        String badParam;
        String badParam2;
        String badParam3;
        if (this.m_rulesList == null) {
            return;
        }
        if (!XmlBeanValidator.validate(this.m_store, this.m_rulesDoc)) {
            throw new Exception("Invalid rules file provided");
        }
        ServiceRulesType serviceRules = this.m_rulesList.getServiceRules();
        if (serviceRules != null && (badParam3 = this.validateRulesArray(serviceRules.getServiceRuleArray())) != null) {
            String errorMessage = new String("Duplicate service found in rules file: ");
            errorMessage = errorMessage + badParam3;
            throw new Exception(errorMessage);
        }
        EndpointRulesType endpointRules = this.m_rulesList.getEndpointRules();
        if (endpointRules != null && (badParam2 = this.validateRulesArray(endpointRules.getEndpointRuleArray())) != null) {
            String errorMessage = new String("Duplicate endpoint found in rules file: ");
            errorMessage = errorMessage + badParam2;
            throw new Exception(errorMessage);
        }
        ConnectionRulesType connectionRules = this.m_rulesList.getConnectionRules();
        if (connectionRules != null && (badParam = this.validateRulesArray(connectionRules.getConnectionRuleArray())) != null) {
            String errorMessage = new String("Duplicate connection found in rules file: ");
            errorMessage = errorMessage + badParam;
            throw new Exception(errorMessage);
        }
    }

    public String validateRulesArray(RuleType[] ruleArray) throws Exception {
        if (ruleArray != null) {
            for (int i = 0; i < ruleArray.length; ++i) {
                String rule = ruleArray[i].getType();
                for (int j = 0; j < ruleArray.length; ++j) {
                    String compareRule;
                    if (i == j || !rule.equals(compareRule = ruleArray[j].getType())) continue;
                    return ruleArray[i].getType();
                }
            }
        }
        return null;
    }
}

