/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.xqimpl.tools.install.config.ScriptWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class XQDSLister
implements ScriptWriter.ScriptListener {
    public static boolean DEBUG = true;
    public static String[] s_basicNames = new String[]{"xpath", "property", "BPEType", "CallOutType", "CBRType", "JMSType", "WebLogicType", "jsHelperFunctions.js"};
    public static String[] XQ_TYPES = new String[]{"container", "process", "connection", "file", "params", "accessor", "endpointtype", "service", "connectiontype", "wsdlporttype", "servicetype", "endpoint", "wsdltype"};
    public ScriptWriter m_scriptWriter = null;
    private BufferedWriter m_logWriter = null;
    public boolean m_isWindows = true;
    public String m_xq15DSURL;
    public String m_xq15DSUser;
    public String m_xq15DSPassword;
    public String m_dsURL;
    public String m_domain;
    public String m_dsUser;
    public String m_dsPassword;
    public String m_installPath;
    public boolean m_force;

    public XQDSLister(String[] args) {
        if (!this.parseArgs(args)) {
            System.out.println("*Error*: invalid args");
            return;
        }
        this.openLogFile();
        this.execute();
        System.out.println("*Success*: Successfully generated migration scripts");
    }

    public final boolean execute() {
        boolean result = false;
        try {
            this.m_scriptWriter = new ScriptWriter(this.getScriptPath(), s_basicNames, this, this.getMigrationScriptsPath(), this.m_force);
            this.generateScriptsData();
            this.m_scriptWriter.waitForExitCode();
            this.makeParentDir();
            this.writeScriptFile(true);
            this.writeScriptFile(false);
            this.makeDirectories();
            this.writeToLogFile("Successfully generated migration scripts");
            result = true;
        }
        catch (Exception e) {
            this.writeToLogFile(e.getMessage());
        }
        this.closeLogFile();
        return result;
    }

    @Override
    public void onOutput(String s) {
        System.out.println("output: " + s);
        if (s.startsWith("*Error*:")) {
            this.m_scriptWriter.killProcess();
            this.m_scriptWriter.close();
            this.m_scriptWriter = null;
        }
        this.writeToLogFile(s);
    }

    public void generateScriptsData() throws Exception {
        try {
            this.m_scriptWriter.launchScript();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String params = "connect " + this.m_xq15DSURL + " " + this.m_xq15DSUser + " " + this.m_xq15DSPassword;
        this.m_scriptWriter.writeToStdin(params + "\n");
        this.m_scriptWriter.writeToStdin(this.getListCmds());
        this.m_scriptWriter.writeToStdin("disconnect\n");
        this.m_scriptWriter.writeToStdin("bye\n");
    }

    public void writeScriptFile(boolean export) throws IOException {
        BufferedWriter bw = null;
        String fileName = export ? "export.script" : "import.script";
        File f = new File(this.getMigrationScriptsPath() + File.separator + fileName);
        try {
            f.delete();
            bw = new BufferedWriter(new FileWriter(f));
            String params = null;
            params = export ? this.m_xq15DSURL + " " + this.m_xq15DSUser + " " + this.m_xq15DSPassword : this.m_dsURL + " " + this.m_dsUser + " " + this.m_dsPassword;
            String cmdConnect = export ? "connect " + params : "connect " + this.m_domain + " " + params;
            bw.write(cmdConnect);
            bw.newLine();
            Vector data = export ? this.m_scriptWriter.getExportScriptCommands() : this.m_scriptWriter.getImportScriptCommands();
            for (int i = 0; i < data.size(); ++i) {
                bw.write((String)data.get(i));
                bw.newLine();
            }
            bw.write("disconnect");
            bw.newLine();
            bw.close();
            this.writeToLogFile(fileName + " generated successfully");
        }
        catch (IOException ioe) {
            String msg = "An error occurred while writing to the file " + fileName;
            this.writeToLogFile("*Error*:" + msg);
            throw new IOException(msg + ": " + ioe.getMessage());
        }
    }

    public final void openLogFile() {
        try {
            File f = new File(this.getLogPath());
            if (f.exists()) {
                f.delete();
            }
            this.m_logWriter = new BufferedWriter(new FileWriter(f));
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void writeToLogFile(String line) {
        try {
            this.m_logWriter.write(line);
            this.m_logWriter.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeLogFile() {
        try {
            if (this.m_logWriter != null) {
                this.m_logWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getScriptPath() {
        return this.m_installPath + File.separator + "bin" + File.separator + "xqadmin." + (this.m_isWindows ? "bat" : "sh");
    }

    public String getMigrationScriptsPath() {
        return this.m_installPath + File.separator + "migrate" + File.separator + "xq1.5";
    }

    public String getLogPath() {
        return this.m_installPath + File.separator + "logs" + File.separator + "scriptgeneration.log";
    }

    public String[] getListCmds() {
        ArrayList<String> cmds = new ArrayList<String>(XQ_TYPES.length);
        for (int i = 0; i < XQ_TYPES.length; ++i) {
            cmds.add(i, "list " + XQ_TYPES[i] + "\n");
        }
        return cmds.toArray(new String[cmds.size()]);
    }

    public void makeParentDir() {
        File migrate = new File(this.getMigrationScriptsPath());
        if (!migrate.exists()) {
            migrate.mkdirs();
        }
    }

    public void makeDirectories() {
        for (int i = 0; i < XQ_TYPES.length; ++i) {
            File dir = new File(this.getMigrationScriptsPath(), XQ_TYPES[i]);
            if (dir.exists()) continue;
            dir.mkdir();
        }
    }

    private boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String force;
            if ("-xq15dsurl".equals(args[i])) {
                this.m_xq15DSURL = args[++i];
                continue;
            }
            if ("-xq15dsuser".equals(args[i])) {
                this.m_xq15DSUser = args[++i];
                continue;
            }
            if ("-xq15dspassword".equals(args[i])) {
                this.m_xq15DSPassword = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
                continue;
            }
            if ("-url".equals(args[i])) {
                this.m_dsURL = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                this.m_dsUser = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                this.m_dsPassword = args[++i];
                continue;
            }
            if ("-installpath".equals(args[i])) {
                this.m_installPath = args[++i];
                continue;
            }
            if (!"-force".equals(args[i])) continue;
            if ("true".equalsIgnoreCase(force = args[++i])) {
                this.m_force = true;
            }
            this.m_force = true;
        }
        if (this.m_xq15DSURL == null || this.m_xq15DSUser == null || this.m_xq15DSPassword == null || this.m_dsURL == null || this.m_dsUser == null || this.m_dsPassword == null || this.m_installPath == null) {
            return false;
        }
        if (DEBUG) {
            System.out.println("-xq15dsurl: " + this.m_xq15DSURL);
            System.out.println("-xq15dsuser: " + this.m_xq15DSUser);
            System.out.println("-xq15dspassword: " + this.m_xq15DSPassword);
            System.out.println("-url: " + this.m_dsURL);
            System.out.println("-domain: " + this.m_domain);
            System.out.println("-user: " + this.m_dsUser);
            System.out.println("-password: " + this.m_dsPassword);
            System.out.println("-installpath: " + this.m_installPath);
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            XQDSLister lister = new XQDSLister(args);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

