/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.Version;
import com.sonicsw.xqimpl.config.XQViewHelper;
import com.sonicsw.xqimpl.util.crypto.DES;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.JMRuntimeException;
import javax.management.RuntimeOperationsException;

public class XQDSSeeder {
    private boolean m_installMode = true;
    private static final String DEFAULT_URL = "localhost";
    private static final String DEFAULT_USER = "Administrator";
    private static final String DEFAULT_PASSWORD = "Administrator";
    private static final String DEFAULT_DOMAIN = "Domain1";
    private static final String ESB_ARCHIVE_DIR = "/System/SonicESB/" + Version.getMajorMinorVersion() + "/lib/";
    private static final String CAR = "/Archives/ESB/" + Version.getMajorMinorVersion() + "/ESBcontainer.car";
    private static final String RESOURCES_DIR = "/Resources";
    private String m_url = "localhost";
    private String m_user = "Administrator";
    private String m_password = null;
    private String m_domain = "Domain1";
    private Vector m_files = new Vector();
    private Vector m_archives = new Vector();
    private String m_car = null;
    private String m_dsArchives = null;
    private boolean m_force = false;
    private ConfigServerUtility m_csu = null;
    private IDirectoryAdminService m_dsAdmin = null;
    private IDirectoryFileSystemService m_dsFS = null;
    private SonicFSFileSystem m_fs = null;
    private static String[] s_xqDirectories = new String[]{"/xqContainers", "/xqProcesses", "/xqFiles", "/xqServices", "/xqServiceTypes", "/xqEndpoints", "/xqEndpointTypes", "/xqConnectionTypes", "/xqConnections", "/xqAccessors", "/xqParams", "/xqMessageTypes", "/xqWSDLPortTypes", "/xqWSDLTypes", "/licenses", "/licenses/sonicxq", "/licenses/sonicxq/container"};

    public XQDSSeeder(String[] args) throws Exception {
        try {
            this.parseArgs(args);
            this.m_csu = new ConfigServerUtility();
            this.m_csu.connect(this.m_domain, this.m_url, this.m_user, this.m_password, true);
            this.m_dsAdmin = (IDirectoryAdminService)this.m_csu.getDirectoryService();
            this.m_dsFS = this.m_csu.getDirectoryService();
            this.m_fs = new SonicFSFileSystem(this.m_dsFS, this.m_user);
            if (this.m_installMode) {
                this.createDSDirectories();
                this.createLicenseTimestamp();
                this.removeExpiredValidator();
                this.importFiles();
            } else {
                this.removeDSDirectories();
                this.removeFromSonicFS();
            }
        }
        catch (Exception e) {
            System.out.println("*Error*: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this.m_csu != null) {
                try {
                    this.m_csu.disconnect();
                }
                catch (ConfigServiceException configServiceException) {}
                this.m_csu = null;
                this.m_dsAdmin = null;
                this.m_dsFS = null;
                this.m_fs = null;
            }
        }
    }

    private void createLicenseTimestamp() throws ConfigException, DirectoryServiceException {
        try {
            IDirElement elem = this.m_dsAdmin.getElement("/licenses/sonicxq/" + Version.getMajorMinorVersion() + "/timestamp", false);
            if (null != elem) {
                return;
            }
        }
        catch (DirectoryServiceException elem) {
            // empty catch block
        }
        try {
            this.m_dsAdmin.createDirectory("/licenses/sonicxq/" + Version.getMajorMinorVersion());
        }
        catch (DirectoryServiceException elem) {
            // empty catch block
        }
        Long timestamp = new Long(new DES().encryptLong(System.currentTimeMillis(), 2030L));
        IDirElement licenseElement = ElementFactory.createElement((String)("/licenses/sonicxq/" + Version.getMajorMinorVersion() + "/timestamp"), (String)"licenses", (String)"1.0");
        licenseElement.getAttributes().setLongAttribute("timestamp", timestamp);
        this.m_dsAdmin.setElement(licenseElement.doneUpdate(), null);
    }

    private void removeExpiredValidator() {
        try {
            try {
                IDirElement elem = this.m_dsAdmin.getElement("/_MFArchive/ESB/5.5/xq_validator.jar", true);
                this.m_dsAdmin.detachBlob((IDeltaDirElement)elem.doneUpdate(), null);
            }
            catch (DirectoryServiceException e) {
                return;
            }
            this.removeDirectory("/_MFArchive/ESB/5.5/");
            this.m_dsAdmin.deleteElement("/_MFLibrary/validators/ESB_5.5", null);
        }
        catch (Exception e) {
            System.out.println("*Warning*: Unable to remove ESB validator(s): " + e.getMessage());
        }
    }

    private void removeFromSonicFS() throws Exception {
        for (int i = 0; i < this.m_archives.size(); ++i) {
            this.removeFromSonicFS((String)this.m_archives.get(i));
        }
    }

    private void createDSDirectories() throws Exception {
        if (this.m_dsAdmin != null) {
            try {
                this.m_dsAdmin.getDirectoryServiceVersion();
            }
            catch (JMRuntimeException e) {
                String message = e.getMessage();
                RuntimeException linkedException = null;
                if (e instanceof RuntimeOperationsException) {
                    linkedException = ((RuntimeOperationsException)e).getTargetException();
                }
                if (linkedException != null && linkedException instanceof InvokeTimeoutException) {
                    message = "Cannot connect to Directory Service";
                }
                throw new Exception(message);
            }
            if (!this.m_force) {
                IDirIdentity[] directories = this.m_dsAdmin.listDirectories("/");
                for (int i = 0; i < directories.length; ++i) {
                    String directory = directories[i].getName();
                    for (int j = 0; j < s_xqDirectories.length; ++j) {
                        if (!directory.equals(s_xqDirectories[j])) continue;
                        System.out.println("*Error*: Found previous instance of XQ directory");
                        return;
                    }
                }
            }
            for (int i = 0; i < s_xqDirectories.length; ++i) {
                this.createDirectory(s_xqDirectories[i]);
            }
            this.m_dsFS.setStorageHint("XQ_CONTAINER", "/xqContainers");
        }
    }

    private void createDirectory(String name) {
        try {
            this.m_dsAdmin.createDirectory(name);
        }
        catch (Exception e) {
            System.out.println("*Warning*: " + e.getMessage());
        }
    }

    private void importFiles() throws Exception {
        String file;
        int i;
        try {
            if (!this.m_fs.exists(RESOURCES_DIR)) {
                this.m_fs.createDirectoryPath(RESOURCES_DIR);
                System.out.println("Created /Resources");
            }
        }
        catch (Exception e) {
            System.out.println("*Warning*: Unable to create resources directory: " + e.getMessage());
        }
        for (i = 0; i < this.m_archives.size(); ++i) {
            file = (String)this.m_archives.get(i);
            try {
                this.loadIntoSonicFS(file);
                System.out.println("Loaded " + file + " into sonicfs");
                continue;
            }
            catch (Exception e) {
                System.out.println("*Warning*: Unable to load file '" + file + "' into sonicfs: " + e.getMessage());
            }
        }
        for (i = 0; i < this.m_files.size(); ++i) {
            file = (String)this.m_files.get(i);
            try {
                this.m_dsAdmin.importFromXML(this.readFile(file));
                System.out.println("Seeded " + file);
                continue;
            }
            catch (Exception e) {
                throw new Exception("*Error*: Unable to seed '" + file + "' into the DS: " + e.getMessage());
            }
        }
        if (null != this.m_car) {
            this.loadCarIntoSonicFS();
        }
    }

    public String readFile(String file) throws Exception {
        String contents = null;
        BufferedReader reader = null;
        StringWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            writer = new StringWriter();
            char[] buffer = new char[1024];
            int read = reader.read(buffer, 0, 1024);
            while (read != -1) {
                writer.write(buffer, 0, read);
                read = reader.read(buffer, 0, 1024);
            }
            contents = writer.toString();
        }
        catch (Exception e) {
            throw new Exception("Error reading file:" + file + e.getMessage());
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (Exception exception) {}
        }
        return contents;
    }

    private void removeDSDirectories() throws Exception {
        if (this.m_dsAdmin != null) {
            try {
                this.m_dsAdmin.getDirectoryServiceVersion();
            }
            catch (JMRuntimeException e) {
                String message = e.getMessage();
                RuntimeException linkedException = null;
                if (e instanceof RuntimeOperationsException) {
                    linkedException = ((RuntimeOperationsException)e).getTargetException();
                }
                if (linkedException != null && linkedException instanceof InvokeTimeoutException) {
                    message = "Cannot connect to Directory Service";
                }
                throw new Exception(message);
            }
            this.removeXQContainers();
            for (int i = s_xqDirectories.length - 1; i >= 0; --i) {
                this.removeDirectory(s_xqDirectories[i], true);
            }
        }
    }

    private void removeXQContainers() {
        try {
            new XQViewHelper(this.m_dsAdmin).deleteAllContainers();
        }
        catch (Exception e) {
            System.out.println("*Warning*: Failed to remove XQContainers from view - " + e.getMessage());
        }
    }

    private void removeDirectory(String name) {
        this.removeDirectory(name, false);
    }

    private void removeDirectory(String name, boolean recurse) {
        int i;
        IElementIdentity[] elements = null;
        try {
            elements = this.m_dsAdmin.listElements(name);
            if (recurse) {
                IDirIdentity[] dirs = this.m_dsAdmin.listDirectories(name);
                for (i = 0; i < dirs.length; ++i) {
                    this.removeDirectory(dirs[i].getName(), true);
                }
            }
        }
        catch (Exception e) {
            return;
        }
        try {
            if (elements != null && elements.length > 0) {
                String[] names = new String[elements.length];
                for (i = 0; i < elements.length; ++i) {
                    names[i] = elements[i].getName();
                }
                this.m_dsAdmin.setElements(null, names, null);
            }
            this.m_dsAdmin.deleteDirectory(name);
        }
        catch (Exception e) {
            System.out.println("*Warning*: Failed to delete configurations from " + name + " - " + e.getMessage());
        }
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            StringTokenizer strTok;
            if ("-url".equals(args[i])) {
                this.m_url = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                this.m_user = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                this.m_password = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
                continue;
            }
            if ("-archives".equals(args[i])) {
                strTok = new StringTokenizer(args[++i], ",");
                while (strTok.hasMoreTokens()) {
                    this.m_archives.add(strTok.nextToken());
                }
                continue;
            }
            if ("-importFiles".equals(args[i])) {
                strTok = new StringTokenizer(args[++i], ",");
                while (strTok.hasMoreTokens()) {
                    this.m_files.add(strTok.nextToken());
                }
                continue;
            }
            if ("-mode".equals(args[i])) {
                String mode;
                if ((mode = args[++i]) == null || !"uninstall".equalsIgnoreCase(mode)) continue;
                this.m_installMode = false;
                continue;
            }
            if ("-force".equals(args[i])) {
                String force;
                if ((force = args[++i]) != null && "true".equalsIgnoreCase(force)) {
                    this.m_force = true;
                }
                this.m_force = true;
                continue;
            }
            if ("-car".equals(args[i])) {
                this.m_car = args[++i];
                continue;
            }
            if (!"-ds.archives".equals(args[i])) continue;
            this.m_dsArchives = args[++i];
        }
    }

    private void loadIntoSonicFS(String archiveFile) throws Exception {
        String archive = archiveFile.substring(archiveFile.lastIndexOf(File.separator) + 1);
        File file = new File(archiveFile);
        String name = ESB_ARCHIVE_DIR + archive;
        this.m_fs.createDirectoryPath(name.substring(0, name.lastIndexOf(47)));
        if (this.m_fs.exists(name)) {
            this.m_fs.updateFile(name, file, true);
        } else {
            this.m_fs.createFile(name, file);
        }
    }

    private void loadCarIntoSonicFS() throws Exception {
        File file = new File(this.m_car);
        String carDestination = CAR;
        if (this.m_dsArchives != null) {
            carDestination = carDestination.replaceAll("Archives", this.m_dsArchives);
        }
        this.m_fs.createDirectoryPath(carDestination.substring(0, carDestination.lastIndexOf(47)));
        if (this.m_fs.exists(carDestination)) {
            this.m_fs.updateFile(carDestination, file, true);
        } else {
            this.m_fs.createFile(carDestination, file);
        }
    }

    private void removeFromSonicFS(String archiveFile) throws Exception {
        String archive = archiveFile.substring(archiveFile.lastIndexOf(File.separator) + 1);
        String name = ESB_ARCHIVE_DIR + archive;
        if (this.m_fs.exists(name)) {
            this.m_fs.deleteFile(name);
        }
    }

    public static void main(String[] args) throws Exception {
        new XQDSSeeder(args);
    }
}

