/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mq.mgmtapi.config.IBrokerBean;
import com.sonicsw.mq.mgmtapi.config.IQueuesBean;
import com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory;
import com.sonicsw.mx.config.ConfigServerUtility;
import java.util.List;

public class XQSampleConfig {
    private static final int INSTALL_MODE = 1;
    private static final int UNINSTALL_MODE = 2;
    private static volatile int m_mode = 1;
    private static volatile String m_brokerViewName = "/Brokers/Broker1";
    private static volatile String m_domainName = "Domain1";
    private static volatile String m_connectionsURLs = "tcp://localhost:2506";
    private static volatile String m_userName = "Administrator";
    private static volatile String m_password = null;
    private static String[][] XQQUEUES = new String[][]{{"Sample.Q1", "1000"}, {"Sample.Q2", "1000"}, {"Sample.Q3", "1000"}, {"Sample.Q4", "1000"}, {"Sample.Q5", "1000"}, {"Sample.Q6", "1000"}, {"Sample.Q7", "1000"}, {"Sample.Q8", "1000"}, {"Sample.Q9", "1000"}};
    private static String TEST_XQQUEUE = "Sample.Q1";

    public XQSampleConfig(String[] args) throws Exception {
        try {
            this.parseArgs(args);
        }
        catch (Exception e) {
            throw new Exception("Invalid args");
        }
        this.configQueues();
        StringBuilder sb = new StringBuilder("*Success*: Successfully ");
        sb.append(m_mode == 1 ? "added" : "removed");
        sb.append(" sample queues.");
    }

    public final void configQueues() throws Exception {
        ConfigServerUtility csu = new ConfigServerUtility();
        try {
            csu.connect(m_domainName, m_connectionsURLs, m_userName, m_password, true);
            MQMgmtBeanFactory domain = new MQMgmtBeanFactory();
            domain.connect(csu.getDirectoryService());
            IBrokerBean brokerBean = null;
            List brokersName = domain.getBrokerBeanNames();
            for (String beanName : brokersName) {
                if (!m_brokerViewName.equals(beanName)) continue;
                brokerBean = domain.getBrokerBean(beanName);
                break;
            }
            if (brokerBean == null) {
                throw new Exception("Failed to load configuration for broker " + m_brokerViewName);
            }
            IQueuesBean queuesBean = brokerBean.getQueuesBean();
            IQueuesBean.IQueuesSetType queues = queuesBean.getQueues();
            if (m_mode == 1) {
                this.createQueues(domain, brokerBean, queuesBean, queues, XQQUEUES);
                this.testQueue(domain, brokerBean, queuesBean, queues, TEST_XQQUEUE, 1000);
            } else {
                this.removeQueues(domain, brokerBean, queuesBean, queues, XQQUEUES);
            }
            domain.saveBean((IMgmtBeanBase)brokerBean);
            domain.commit();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            csu.disconnect();
        }
    }

    private void removeQueues(MQMgmtBeanFactory domain, IBrokerBean brokerBean, IQueuesBean queuesBean, IQueuesBean.IQueuesSetType queues, String[][] queueSet) throws MgmtException {
        try {
            for (int i = 0; i < queueSet.length; ++i) {
                String name = queueSet[i][0];
                queues.deleteQueue(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createQueues(MQMgmtBeanFactory domain, IBrokerBean brokerBean, IQueuesBean queuesBean, IQueuesBean.IQueuesSetType queues, String[][] queueSet) throws MgmtException {
        for (int i = 0; i < queueSet.length; ++i) {
            this.createQueue(queues, queueSet[i][0], Integer.parseInt(queueSet[i][1]));
        }
    }

    private void testQueue(MQMgmtBeanFactory domain, IBrokerBean brokerBean, IQueuesBean queuesBean, IQueuesBean.IQueuesSetType queues, String queueName, int queueSize) throws MgmtException {
        System.out.println("Queue verification: " + queueName);
        brokerBean = domain.getBrokerBean(m_brokerViewName);
        queuesBean = brokerBean.getQueuesBean();
        queues = queuesBean.getQueues();
        IQueuesBean.IQueueAttributes test_queue = queues.getQueue(queueName);
        if (test_queue != null) {
            int size = test_queue.getQueueMaxSize();
            if (size == queueSize) {
                System.out.println("Test passed");
                System.out.println("QueueInfo: \nNAME: " + test_queue.getQueueName() + "\nTYPE: " + test_queue.getQueueType() + "\nMAXSIZE: " + test_queue.getQueueMaxSize() + "\nGLOBAL: " + test_queue.getGlobal() + "\nREAD_EXCLUSIVE: " + test_queue.getReadExclusive() + "\nSAVE_TRESHOLD: " + test_queue.getQueueSaveThreshold() + "\n");
            } else {
                System.out.println("Test failed\n");
            }
        }
    }

    private void createQueue(IQueuesBean.IQueuesSetType queues, String queueName, int queueMaxSize) throws MgmtException {
        try {
            queues.getQueue(queueName);
            return;
        }
        catch (MgmtException mgmtException) {
            IQueuesBean.IQueueAttributes queue = queues.createQueue();
            queue.setQueueName(queueName);
            queue.setGlobal(true);
            queue.setReadExclusive(false);
            queue.setQueueMaxSize(queueMaxSize);
            queue.setQueueSaveThreshold(1536);
            queues.addQueue(queueName, queue);
            return;
        }
    }

    private void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String mode;
            if ("-url".equals(args[i])) {
                m_connectionsURLs = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                m_userName = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                m_password = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                m_domainName = args[++i];
                continue;
            }
            if ("-broker".equals(args[i])) {
                m_brokerViewName = args[++i];
                continue;
            }
            if (!"-mode".equals(args[i]) || !"uninstall".equalsIgnoreCase(mode = args[++i])) continue;
            m_mode = 2;
        }
    }

    public static void main(String[] args) {
        try {
            new XQSampleConfig(args);
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("*Error*: " + e.getMessage());
            System.exit(-1);
        }
    }
}

