/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactDiff;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.artifact.RootArtifact;
import com.sonicsw.deploy.compare.ArtifactDiff;
import com.sonicsw.deploy.traversal.CheckExistenceTraverser;
import com.sonicsw.deploy.traversal.TraverserFactory;
import com.sonicsw.sonicxq.ArtifactDiffList;
import com.sonicsw.sonicxq.DiffArtifactPathType;
import com.sonicsw.sonicxq.DiffArtifactsMissingType;
import com.sonicsw.sonicxq.DiffTerseType;
import com.sonicsw.sonicxq.DiffType;
import com.sonicsw.sonicxq.DiffVerboseType;
import com.sonicsw.sonicxq.ESBArtifactDiffDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.apache.xmlbeans.XmlOptions;

public class DiffAction
extends AbstractAction
implements IArtifactDiff {
    protected String m_defaultFileName = "Sonic_Diff.xml";
    protected Hashtable m_sourceHash = new Hashtable();
    protected Hashtable m_targetHash = new Hashtable();
    protected IArtifact[] m_sourceArtifacts;
    protected IArtifact[] m_targetArtifacts;
    protected DiffVerboseType m_verboseDiffs;
    protected DiffTerseType m_terseDiffs;
    protected DiffArtifactsMissingType m_inSourceOnly = DiffArtifactsMissingType.Factory.newInstance();
    protected DiffArtifactsMissingType m_inTargetOnly = DiffArtifactsMissingType.Factory.newInstance();
    protected String m_reportSource = "";
    protected String m_reportTarget = "";
    protected boolean m_verbose = false;
    protected ArrayList m_artifactsToMerge = new ArrayList();
    private IArtifactDiff.TraversalMode m_traversalMode = IArtifactDiff.TraversalMode.LIST_ALL;

    @Override
    public void setHeader(String reportSource, String reportTarget) {
        this.m_reportSource = reportSource;
        this.m_reportTarget = reportTarget;
    }

    @Override
    public String getDescription() {
        return "Diff";
    }

    @Override
    public void run(IArtifactStorage sourceStore, IArtifactStorage targetStore) throws Exception {
        this.m_sourceArtifacts = SearchAction.search(sourceStore, null, TraverserFactory.createListAllTraverser());
        this.m_targetArtifacts = this.m_traversalMode == IArtifactDiff.TraversalMode.CHECK_EXISTENCE ? SearchAction.search(targetStore, null, new CheckExistenceTraverser(RootArtifact.ROOT, true, this.m_sourceArtifacts)) : SearchAction.search(targetStore, null, TraverserFactory.createListAllTraverser());
        this.m_targetArtifacts = SearchAction.search(targetStore, null, new CheckExistenceTraverser(RootArtifact.ROOT, true, this.m_sourceArtifacts));
        this.hashArtifacts(this.m_sourceArtifacts, this.m_sourceHash);
        this.hashArtifacts(this.m_targetArtifacts, this.m_targetHash);
        ArtifactDiff artifacts = new ArtifactDiff(this.m_sourceHash, this.m_targetHash, sourceStore, targetStore);
        if (this.m_verbose) {
            this.m_verboseDiffs = artifacts.diffArtifactListVerbose();
        } else {
            this.m_terseDiffs = artifacts.diffArtifactListTerse();
        }
        this.m_artifactsToMerge.addAll(artifacts.getDifferentArtifacts());
        this.setMissing(this.m_sourceHash, this.m_inSourceOnly, true);
        this.setMissing(this.m_targetHash, this.m_inTargetOnly, false);
    }

    public void setMissing(Hashtable artifactHash, DiffArtifactsMissingType missingArtifacts, boolean addToMergeList) {
        DiffArtifactPathType[] missing = new DiffArtifactPathType[artifactHash.size()];
        IArtifact[] remainingArtifacts = artifactHash.values().toArray(new IArtifact[0]);
        for (int i = 0; i < remainingArtifacts.length; ++i) {
            missing[i] = DiffArtifactPathType.Factory.newInstance();
            missing[i].setPath(remainingArtifacts[i].getArchivePath());
            if (!addToMergeList) continue;
            this.m_artifactsToMerge.add(remainingArtifacts[i]);
        }
        missingArtifacts.setArtifactDiffArray(missing);
    }

    @Override
    public void generateReport(File diffFile) throws IOException {
        ArtifactDiffList artifactDiffList = ArtifactDiffList.Factory.newInstance();
        artifactDiffList.setDate(new Date(System.currentTimeMillis()).toString());
        artifactDiffList.setSource(this.m_reportSource);
        artifactDiffList.setTarget(this.m_reportTarget);
        DiffType diffs = DiffType.Factory.newInstance();
        if (this.m_verbose) {
            diffs.setArtifactDiffsVerbose(this.m_verboseDiffs);
            diffs.setArtifactsInSource(this.m_inSourceOnly);
            diffs.setArtifactsInTarget(this.m_inTargetOnly);
        } else {
            diffs.setArtifactDiffsTerse(this.m_terseDiffs);
            diffs.setArtifactsInSource(this.m_inSourceOnly);
            diffs.setArtifactsInTarget(this.m_inTargetOnly);
        }
        ESBArtifactDiffDocument diffDoc = ESBArtifactDiffDocument.Factory.newInstance();
        artifactDiffList.setDiffs(diffs);
        diffDoc.setESBArtifactDiff(artifactDiffList);
        XmlOptions xmlOpts = new XmlOptions();
        xmlOpts.setSavePrettyPrint();
        xmlOpts.setSavePrettyPrintIndent(4);
        diffDoc.save(diffFile, xmlOpts);
    }

    public void hashArtifacts(IArtifact[] artifacts, Hashtable artifactHash) throws Exception, IOException {
        for (int i = 0; i < artifacts.length; ++i) {
            artifactHash.put(DiffAction.formArtifactKey(artifacts[i]), artifacts[i]);
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public static String formArtifactKey(IArtifact artifact) {
        return artifact.getDisplayType() + artifact.getPath();
    }

    @Override
    public String getDefaultOutputFilename() {
        return this.m_defaultFileName;
    }

    @Override
    public void setTraversalMode(IArtifactDiff.TraversalMode mode) {
        this.m_traversalMode = mode;
    }

    public IArtifactDiff.TraversalMode getTraversalMode() {
        return this.m_traversalMode;
    }
}

