/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifactNotificationEvent;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import java.util.ArrayList;

public abstract class AbstractHandler
implements IArtifactNotificationListener {
    private IArtifactStorage m_source;
    private IArtifactStorage m_destination;
    private final ArrayList<IArtifactNotificationListener> m_listeners = new ArrayList();

    public void setSourceStorage(IArtifactStorage store) {
        if (this.m_source != null) {
            this.m_source.removeNotificationListener(this);
        }
        this.m_source = store;
        if (this.m_source != null) {
            this.m_source.addNotificationListener(this);
        }
    }

    public IArtifactStorage getSourceStorage() {
        return this.m_source;
    }

    public void setDestinationStorage(IArtifactStorage store) {
        if (this.m_destination != null) {
            this.m_destination.removeNotificationListener(this);
        }
        this.m_destination = store;
        if (this.m_destination != null) {
            this.m_destination.addNotificationListener(this);
        }
    }

    public IArtifactStorage getDestinationStorage() {
        return this.m_destination;
    }

    public void addNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void notifyMessage(IArtifactNotificationEvent event) {
        for (IArtifactNotificationListener listener : this.m_listeners) {
            listener.notifyMessage(event);
        }
    }
}

