/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.AbstractListTraverser;
import com.sonicsw.deploy.traversal.ESBServiceTypeTraverser;

public class ESBListTraverser
extends AbstractListTraverser {
    private boolean m_listOnly = false;

    public ESBListTraverser(IArtifact artifact) {
        this(artifact, false);
    }

    public ESBListTraverser(IArtifact artifact, boolean listOnly) {
        super(artifact);
        this.m_listOnly = listOnly;
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        if (this.m_artifact.isRootPath()) {
            IArtifact[] valid = ESBArtifact.getValidTypes();
            for (int i = 0; i < valid.length; ++i) {
                this.traverseList(valid[i], context);
            }
            if (!this.m_listOnly) {
                IArtifact[] traversed = context.getTraversed();
                for (int i = 0; i < traversed.length; ++i) {
                    if (!traversed[i].getParentPath().equals(ESBArtifact.SERVICE_TYPE.getPath())) continue;
                    new ESBServiceTypeTraverser(traversed[i])._traverse(context);
                }
            }
        } else {
            this.traverseList(this.m_artifact, context);
        }
    }
}

