/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBServiceTraverser
extends AbstractESBTraverser {
    public static String serviceAnnotationTypePath = "/Resources/SonicESB/Annotations/service/";

    public ESBServiceTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    protected void doTraversal(IArtifactTraversalContext context) throws Exception {
        String wsdl;
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        String type = element.getAttribute("type_ref");
        String entryRef = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"entry_ref");
        if (entryRef != null && entryRef.length() > 0) {
            ESBTraverserFactory.createEndpointTraverser(entryRef).traverse(context);
        }
        this.traverseEndpoints(context, element, "faultEndpoint");
        this.traverseEndpoints(context, element, "rejectEndpoint");
        this.traverseEndpoints(context, DOMUtils.getImmediateChildElementByName((Element)element, (String)"exitEndpoint_list"), "exitEndpoint");
        this.traverseParameters(context, DOMUtils.getImmediateChildElementByName((Element)element, (String)"params"));
        Element clsLoading = DOMUtils.getImmediateChildElementByName((Element)element, (String)"classLoading");
        this.traverseClassLoading(context, clsLoading, "serviceInstance");
        this.traverseClassLoading(context, clsLoading, "serviceType");
        this.traverseClassLoading(context, clsLoading, "xqContainer");
        String interfaceRef = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"interfaceRef");
        if (interfaceRef != null && interfaceRef.length() > 0) {
            this.traverseURLRefs(interfaceRef, context);
        }
        if ((wsdl = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"wsdlUrl")) != null && wsdl.length() > 0) {
            this.traverseURLRefs(wsdl, context);
        }
        if (type.equals("BPEType")) {
            ESBTraverserFactory.createProcessTraverser(this.m_artifact.getName()).traverse(context);
            context.addSkipped(this.m_artifact);
        } else {
            ESBTraverserFactory.createServiceTypeTraverser(type).traverse(context);
        }
        String annotatioFilePath = serviceAnnotationTypePath + this.m_artifact.getName() + "." + "annotation";
        IArtifact annotationArtifact = ArtifactFactory.createArtifact("SonicFS", annotatioFilePath);
        if (context.getStorage().exists(annotationArtifact)) {
            context.addTraversed(annotationArtifact, false);
        }
    }
}

